/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import org.jkiss.dbeaver.model.DBPDataKind;

public enum FireBirdFieldType {
    SMALLINT(7, 5, DBPDataKind.NUMERIC, "SMALLINT"),
    INTEGER(8, 4, DBPDataKind.NUMERIC, "INTEGER"),
    FLOAT(10, 6, DBPDataKind.NUMERIC, "FLOAT"),
    DECFLOAT(11, 6, DBPDataKind.NUMERIC, "DECFLOAT"),
    DATE(12, 91, DBPDataKind.DATETIME, "DATE"),
    TIME(13, 92, DBPDataKind.DATETIME, "TIME"),
    CHAR(14, 1, DBPDataKind.STRING, "CHAR"),
    BIGINT(16, -5, DBPDataKind.NUMERIC, "BIGINT"),
    NUMERIC(16, 2, DBPDataKind.NUMERIC, "NUMERIC"),
    DECIMAL(16, 3, DBPDataKind.NUMERIC, "DECIMAL"),
    BOOLEAN(23, 16, DBPDataKind.BOOLEAN, "BOOLEAN"),
    INT128(26, -5, DBPDataKind.NUMERIC, "INT128"),
    DOUBLE_PRECISION(27, 8, DBPDataKind.NUMERIC, "DOUBLE PRECISION"),
    TIME_WITH_TIMEZONE(28, 2013, DBPDataKind.DATETIME, "TIME WITH TIMEZONE"),
    TIMESTAMP_WITH_TIMEZONE(29, 2014, DBPDataKind.DATETIME, "TIMESTAMP WITH TIMEZONE"),
    TIMESTAMP(35, 93, DBPDataKind.DATETIME, "TIMESTAMP"),
    VARCHAR(37, 12, DBPDataKind.STRING, "VARCHAR"),
    CSTRING(40, 12, DBPDataKind.STRING, "CSTRING"),
    BLOB(261, 2004, DBPDataKind.CONTENT, "BLOB");

    private final int typeID;
    private final int valueType;
    private final DBPDataKind dataKind;
    private final String name;

    private FireBirdFieldType(int typeID, int valueType, DBPDataKind dataKind, String name) {
        this.typeID = typeID;
        this.valueType = valueType;
        this.dataKind = dataKind;
        this.name = name;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public int getValueType() {
        return this.valueType;
    }

    public DBPDataKind getDataKind() {
        return this.dataKind;
    }

    public String getName() {
        return this.name;
    }

    public static FireBirdFieldType getById(int id, int subTypeId) {
        if (id == 16 || id == 8) {
            switch (subTypeId) {
                case 1: {
                    return NUMERIC;
                }
                case 2: {
                    return DECIMAL;
                }
            }
            return id == 16 ? BIGINT : INTEGER;
        }
        FireBirdFieldType[] fireBirdFieldTypeArray = FireBirdFieldType.values();
        int n = fireBirdFieldTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FireBirdFieldType ft = fireBirdFieldTypeArray[n2];
            if (ft.getTypeID() == id) {
                return ft;
            }
            ++n2;
        }
        return null;
    }
}

