/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.JAutoToggleButton;
import org.freeplane.core.ui.components.ToolbarLayout;
import org.freeplane.core.ui.menubuilders.menu.JButtonWithDropdownMenu;
import org.freeplane.core.ui.menubuilders.menu.UnitGridBagLayout;
import org.freeplane.core.util.Compat;

public class FreeplaneToolBar
extends JToolBar {
    public static final int FLOATING_HORIZONTAL = 2;
    protected static Insets nullInsets = new Insets(0, 0, 0, 0);
    private static final GridBagConstraints separatorConstraints = new GridBagConstraints();
    private static final long serialVersionUID = 1L;
    private boolean disablesFocus = true;
    private boolean reducesButtonSize = true;

    public FreeplaneToolBar(int orientation) {
        this(null, orientation);
    }

    public FreeplaneToolBar(String name, int orientation) {
        super(name, orientation == 2 ? 0 : orientation);
        this.setMargin(nullInsets);
        this.setFloatable(false);
        this.setRollover(true);
        if (orientation == 0) {
            UnitGridBagLayout gridBagLayout = new UnitGridBagLayout();
            super.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createEmptyBorder());
        } else if (orientation == 2) {
            super.setLayout(ToolbarLayout.floatingHorizontal());
        } else if (orientation == 1) {
            super.setLayout(ToolbarLayout.vertical());
        } else {
            throw new IllegalArgumentException();
        }
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                FreeplaneToolBar.this.revalidate();
                FreeplaneToolBar.this.repaint();
            }

            @Override
            public void ancestorMoved(HierarchyEvent e) {
            }
        });
    }

    public boolean disablesFocus() {
        return this.disablesFocus;
    }

    public void setDisablesFocus(boolean disablesFocus) {
        this.disablesFocus = disablesFocus;
    }

    public void setReducesButtonSize(boolean reducesButtonSize) {
        this.reducesButtonSize = reducesButtonSize;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public Component add(Component comp) {
        super.add(comp);
        this.configureComponent(comp);
        return comp;
    }

    @Override
    public Component add(Component comp, int index) {
        super.add(comp, index);
        this.configureComponent(comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        this.configureComponent(comp);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        super.add(comp, constraints, index);
        this.configureComponent(comp);
    }

    @Override
    public Component add(String name, Component comp) {
        super.add(name, comp);
        this.configureComponent(comp);
        return comp;
    }

    @Override
    public void addSeparator() {
        if (this.getOrientation() == 1) {
            super.addSeparator();
        } else {
            JToolBar.Separator s = new JToolBar.Separator();
            this.add((Component)s, separatorConstraints);
        }
    }

    protected void configureComponent(Component comp) {
        if (!(comp instanceof AbstractButton)) {
            return;
        }
        AbstractButton abstractButton = (AbstractButton)comp;
        this.configureToolbarButton(abstractButton);
    }

    public static AbstractButton createButton(AFreeplaneAction action) {
        AbstractButton button = new JButton(action);
        button = action.isSelectable() ? new JAutoToggleButton(action) : new JButton(action);
        return button;
    }

    private void configureToolbarButton(AbstractButton abstractButton) {
        if (this.reducesButtonSize) {
            this.configureToolbarButtonText(abstractButton);
            this.configureToolbarButtonSize(abstractButton);
        }
        if (this.disablesFocus) {
            abstractButton.setRequestFocusEnabled(false);
            abstractButton.setFocusable(false);
        }
    }

    private void configureToolbarButtonText(AbstractButton abstractButton) {
        if (null != abstractButton.getIcon() && !(abstractButton instanceof JButtonWithDropdownMenu)) {
            String text = abstractButton.getText();
            String toolTipText = abstractButton.getToolTipText();
            if (text != null) {
                if (toolTipText == null) {
                    abstractButton.setToolTipText(text);
                }
                abstractButton.setText(null);
            }
        }
    }

    private void configureToolbarButtonSize(AbstractButton abstractButton) {
        if (Compat.isMacOsX()) {
            abstractButton.putClientProperty("JButton.buttonType", "segmentedGradient");
            abstractButton.putClientProperty("JButton.segmentPosition", "middle");
            abstractButton.setFocusPainted(false);
        }
        abstractButton.setMargin(nullInsets);
    }

    static {
        FreeplaneToolBar.separatorConstraints.gridy = 0;
        FreeplaneToolBar.separatorConstraints.fill = 3;
        FreeplaneToolBar.separatorConstraints.gridheight = 0;
    }
}

