/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.UIManagerUtil;
import net.infonode.util.ColorUtil;
import net.infonode.util.Direction;

public class ShadowPainter {
    private Color panelBackgroundColor;
    private Color tabBackgroundColor;
    private Component component;
    private JComponent componentsPanel;
    private JComponent highlightedTab;
    private JComponent contentPanel;
    private JComponent tabAreaComponentsPanel;
    private JComponent tabAreaContainer;
    private JComponent tabBox;
    private Direction tabOrientation;
    private boolean paintTabAreaShadow;
    private int shadowSize;
    private int shadowBlendSize;
    private Color shadowColor;
    private float shadowStrength;
    private boolean highlightedTabIsLast;

    public ShadowPainter(Component component, JComponent componentsPanel, JComponent highlightedTab, JComponent contentPanel, JComponent tabAreaComponentsPanel, JComponent tabAreaContainer, JComponent tabBox, Direction tabOrientation, boolean paintTabAreaShadow, int shadowSize, int shadowBlendSize, Color shadowColor, float shadowStrength, boolean highlightedTabIsLast) {
        this.component = component;
        this.componentsPanel = componentsPanel;
        this.highlightedTab = highlightedTab == null ? null : (!highlightedTab.isVisible() || !tabAreaContainer.isVisible() ? null : highlightedTab);
        this.contentPanel = contentPanel;
        this.tabAreaComponentsPanel = tabAreaComponentsPanel;
        this.tabAreaContainer = tabAreaContainer;
        this.tabBox = tabBox;
        this.tabOrientation = tabOrientation;
        this.paintTabAreaShadow = paintTabAreaShadow && tabAreaContainer.isVisible();
        this.shadowSize = shadowSize;
        this.shadowBlendSize = shadowBlendSize;
        this.shadowColor = shadowColor;
        this.shadowStrength = shadowStrength;
        this.highlightedTabIsLast = highlightedTabIsLast;
    }

    public void paint(Graphics g) {
        this.panelBackgroundColor = ComponentUtil.getBackgroundColor(this.component);
        Color color = this.panelBackgroundColor = this.panelBackgroundColor == null ? UIManagerUtil.getColor("Panel.background", "control") : this.panelBackgroundColor;
        if (this.paintTabAreaShadow) {
            Rectangle bounds = SwingUtilities.calculateInnerArea(this.componentsPanel, new Rectangle());
            this.drawBottomRightEdgeShadow(g, bounds.y, bounds.x + bounds.width, bounds.height, true, this.panelBackgroundColor);
            this.drawBottomRightEdgeShadow(g, bounds.x, bounds.y + bounds.height, bounds.width, false, this.panelBackgroundColor);
            this.drawRightCornerShadow(g, bounds.x + bounds.width, bounds.y + bounds.height, false, this.panelBackgroundColor);
        } else {
            this.tabBackgroundColor = this.highlightedTab == null ? this.panelBackgroundColor : ComponentUtil.getBackgroundColor(this.highlightedTab.getParent());
            this.tabBackgroundColor = this.tabBackgroundColor == null ? this.panelBackgroundColor : this.tabBackgroundColor;
            Rectangle contentPanelBounds = this.contentPanel.getBounds();
            int len = 0;
            if (this.highlightedTab != null) {
                len = this.paintHighlightedTabShadow(g, this.tabOrientation, contentPanelBounds);
            }
            if (this.tabAreaComponentsPanel.isVisible()) {
                int n = this.tabOrientation.isHorizontal() ? (this.tabAreaContainer.getInsets().bottom == 0 ? this.tabAreaComponentsPanel.getWidth() : 0) : (len = this.tabAreaContainer.getInsets().right == 0 ? this.tabAreaComponentsPanel.getHeight() : 0);
            }
            if (!this.tabAreaContainer.isVisible()) {
                len = 0;
            }
            if (this.tabOrientation != Direction.RIGHT || this.highlightedTab == null) {
                this.drawBottomRightEdgeShadow(g, contentPanelBounds.y - (this.tabOrientation == Direction.UP ? len : 0), contentPanelBounds.x + contentPanelBounds.width, contentPanelBounds.height + (!this.tabOrientation.isHorizontal() ? len : 0), true, this.highlightedTab == null ? null : this.panelBackgroundColor);
            }
            if (this.tabOrientation != Direction.DOWN || this.highlightedTab == null) {
                this.drawBottomRightEdgeShadow(g, contentPanelBounds.x - (this.tabOrientation == Direction.LEFT ? len : 0), contentPanelBounds.y + contentPanelBounds.height, contentPanelBounds.width + (this.tabOrientation.isHorizontal() ? len : 0), false, this.highlightedTab == null ? null : this.panelBackgroundColor);
            }
            this.drawRightCornerShadow(g, contentPanelBounds.x + contentPanelBounds.width + (this.tabOrientation == Direction.RIGHT ? len : 0), contentPanelBounds.y + contentPanelBounds.height + (this.tabOrientation == Direction.DOWN ? len : 0), false, this.panelBackgroundColor);
        }
    }

    private int paintHighlightedTabShadow(Graphics g, Direction tabOrientation, Rectangle contentPanelBounds) {
        Point p = SwingUtilities.convertPoint(this.highlightedTab.getParent(), this.highlightedTab.getLocation(), this.component);
        Dimension tabsSize = this.tabBox.getSize();
        Rectangle bounds = this.tabAreaComponentsPanel.isVisible() ? SwingUtilities.convertRectangle(this.tabAreaComponentsPanel.getParent(), this.tabAreaComponentsPanel.getBounds(), this.component) : new Rectangle(contentPanelBounds.x + contentPanelBounds.width, contentPanelBounds.y + contentPanelBounds.height, 0, 0);
        Point tabsPos = SwingUtilities.convertPoint(this.tabBox, 0, 0, this.component);
        int width = (tabOrientation.isHorizontal() ? 0 : tabsPos.x) + tabsSize.width;
        int height = (tabOrientation.isHorizontal() ? tabsPos.y : 0) + tabsSize.height;
        if (tabOrientation == Direction.DOWN) {
            this.drawBottomRightTabShadow(g, contentPanelBounds.x, contentPanelBounds.y + contentPanelBounds.height, contentPanelBounds.width, p.x, this.highlightedTab.getWidth(), this.highlightedTab.getHeight(), bounds.x, bounds.width, bounds.height, false, this.highlightedTabIsLast);
        } else if (tabOrientation == Direction.RIGHT) {
            this.drawBottomRightTabShadow(g, contentPanelBounds.y, contentPanelBounds.x + contentPanelBounds.width, contentPanelBounds.height, p.y, this.highlightedTab.getHeight(), this.highlightedTab.getWidth(), bounds.y, bounds.height, bounds.width, true, this.highlightedTabIsLast);
        } else if (tabOrientation == Direction.UP) {
            this.drawTopLeftTabShadow(g, p.x + this.highlightedTab.getWidth(), p.y, this.highlightedTab.getHeight(), bounds, contentPanelBounds.width, false, this.highlightedTabIsLast);
        } else {
            this.drawTopLeftTabShadow(g, p.y + this.highlightedTab.getHeight(), p.x, this.highlightedTab.getWidth(), ShadowPainter.flipRectangle(bounds), contentPanelBounds.height, true, this.highlightedTabIsLast);
        }
        if (this.highlightedTabIsLast) {
            return tabOrientation.isHorizontal() ? (p.y + this.highlightedTab.getHeight() >= contentPanelBounds.height && contentPanelBounds.height == height ? this.highlightedTab.getWidth() : 0) : (p.x + this.highlightedTab.getWidth() >= contentPanelBounds.width && contentPanelBounds.width == width ? this.highlightedTab.getHeight() : 0);
        }
        return 0;
    }

    private static Rectangle flipRectangle(Rectangle bounds) {
        return new Rectangle(bounds.y, bounds.x, bounds.height, bounds.width);
    }

    private static Rectangle createRectangle(int x, int y, int width, int height, boolean flip) {
        return flip ? new Rectangle(y, x, height, width) : new Rectangle(x, y, width, height);
    }

    private void drawTopLeftTabShadow(Graphics g, int x, int y, int height, Rectangle componentsBounds, int totalWidth, boolean flip, boolean isLast) {
        int endX;
        boolean connected;
        boolean bl = connected = x + this.shadowSize > componentsBounds.x;
        if (!connected || y + this.shadowSize + this.shadowBlendSize <= componentsBounds.y) {
            this.drawLeftCornerShadow(g, y, Math.min(x, componentsBounds.x), !flip, isLast ? this.tabBackgroundColor : null);
            this.drawEdgeShadow(g, y, connected ? componentsBounds.y : y + height, Math.min(x, componentsBounds.x), false, !flip, isLast ? this.tabBackgroundColor : null);
        }
        if ((endX = componentsBounds.x + componentsBounds.width) < totalWidth) {
            this.drawLeftCornerShadow(g, componentsBounds.y, endX, !flip, this.tabBackgroundColor);
            this.drawEdgeShadow(g, componentsBounds.y, componentsBounds.y + componentsBounds.height, endX, false, !flip, this.tabBackgroundColor);
        }
    }

    private void drawBottomRightTabShadow(Graphics g, int x, int y, int width, int tabX, int tabWidth, int tabHeight, int componentsX, int componentsWidth, int componentsHeight, boolean flip, boolean isLast) {
        Shape oldClipRect = g.getClip();
        Rectangle clipRect = ShadowPainter.createRectangle(x, y, Math.min(tabX, componentsX) - x, 1000000, flip);
        g.clipRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        this.drawLeftCornerShadow(g, x, y, flip, null);
        this.drawEdgeShadow(g, x, tabX, y, false, flip, null);
        boolean connected = tabX < componentsX && tabX + tabWidth >= componentsX;
        g.setClip(oldClipRect);
        if (!connected) {
            Rectangle clipRect2 = ShadowPainter.createRectangle(x, y, componentsX - x, 1000000, flip);
            g.clipRect(clipRect2.x, clipRect2.y, clipRect2.width, clipRect2.height);
        }
        if (tabX < componentsX) {
            int endX;
            int n = endX = connected && tabHeight == componentsHeight ? componentsX + componentsWidth : Math.min(componentsX, tabX + tabWidth);
            if (tabX + this.shadowSize < endX) {
                this.drawLeftCornerShadow(g, tabX, y + tabHeight, flip, this.panelBackgroundColor);
            }
            this.drawEdgeShadow(g, tabX, endX, y + tabHeight, false, flip, this.panelBackgroundColor);
            if (!(endX >= x + width || connected && componentsHeight >= tabHeight)) {
                this.drawRightCornerShadow(g, endX, y + tabHeight, flip, this.panelBackgroundColor);
                this.drawEdgeShadow(g, y + (connected ? componentsHeight : 0), y + tabHeight, endX, true, !flip, isLast ? this.tabBackgroundColor : null);
            }
        }
        if (!connected) {
            this.drawEdgeShadow(g, tabX + tabWidth, componentsX, y, true, flip, isLast ? this.tabBackgroundColor : null);
            g.setClip(oldClipRect);
        }
        if (!(componentsHeight <= 0 || connected && tabHeight == componentsHeight)) {
            if (!connected || componentsHeight > tabHeight) {
                this.drawLeftCornerShadow(g, componentsX, y + componentsHeight, flip, this.panelBackgroundColor);
                this.drawEdgeShadow(g, componentsX, componentsX + componentsWidth, y + componentsHeight, false, flip, this.panelBackgroundColor);
            } else {
                this.drawEdgeShadow(g, componentsX, componentsX + componentsWidth, y + componentsHeight, true, flip, this.panelBackgroundColor);
            }
        }
        if (componentsX + componentsWidth < x + width) {
            this.drawRightCornerShadow(g, componentsX + componentsWidth, y + componentsHeight, flip, this.panelBackgroundColor);
            this.drawEdgeShadow(g, y, y + componentsHeight, componentsX + componentsWidth, true, !flip, this.panelBackgroundColor);
            this.drawEdgeShadow(g, componentsX + componentsWidth, x + width, y, true, flip, this.panelBackgroundColor);
        }
    }

    private void drawBottomRightEdgeShadow(Graphics g, int x, int y, int width, boolean flip, Color backgroundColor) {
        this.drawLeftCornerShadow(g, x, y, flip, backgroundColor);
        this.drawEdgeShadow(g, x, x + width, y, false, flip, backgroundColor);
    }

    private void drawLeftCornerShadow(Graphics g, int x, int y, boolean upper, Color backgroundColor) {
        int i = 0;
        while (i < this.shadowBlendSize) {
            g.setColor(this.getShadowBlendColor(i, backgroundColor));
            int x1 = x + this.shadowSize + this.shadowBlendSize - 1 - i;
            int y1 = y + this.shadowSize - this.shadowBlendSize;
            if (y1 > y) {
                ShadowPainter.drawLine(g, x1, y, x1, y1 - 1, upper);
            }
            ShadowPainter.drawLine(g, x1, y1, x + this.shadowSize + this.shadowBlendSize - 1, y + this.shadowSize - this.shadowBlendSize + i, upper);
            ++i;
        }
    }

    private void drawRightCornerShadow(Graphics g, int x, int y, boolean flip, Color backgroundColor) {
        g.setColor(this.getShadowColor(backgroundColor));
        int i = 0;
        while (i < this.shadowSize - this.shadowBlendSize) {
            ShadowPainter.drawLine(g, x + i, y, x + i, y + this.shadowSize - this.shadowBlendSize, flip);
            ++i;
        }
        i = 0;
        while (i < this.shadowBlendSize) {
            g.setColor(this.getShadowBlendColor(i, backgroundColor));
            int d = this.shadowSize - this.shadowBlendSize + i;
            ShadowPainter.drawLine(g, x + d, y, x + d, y + this.shadowSize - this.shadowBlendSize, flip);
            ShadowPainter.drawLine(g, x, y + d, x + this.shadowSize - this.shadowBlendSize, y + d, flip);
            ShadowPainter.drawLine(g, x + d, y + this.shadowSize - this.shadowBlendSize, x + this.shadowSize - this.shadowBlendSize, y + d, flip);
            ++i;
        }
    }

    private void drawEdgeShadow(Graphics g, int startX, int endX, int y, boolean cornerStart, boolean vertical, Color backgroundColor) {
        if (startX + (cornerStart ? 0 : this.shadowSize + this.shadowBlendSize) >= endX) {
            return;
        }
        g.setColor(this.getShadowColor(backgroundColor));
        int i = 0;
        while (i < this.shadowSize - this.shadowBlendSize) {
            ShadowPainter.drawLine(g, startX + (cornerStart ? i + (vertical ? 1 : 0) : this.shadowSize + this.shadowBlendSize), y + i, endX - 1, y + i, vertical);
            ++i;
        }
        i = 0;
        while (i < this.shadowBlendSize) {
            g.setColor(this.getShadowBlendColor(i, backgroundColor));
            int d = this.shadowSize - this.shadowBlendSize + i;
            ShadowPainter.drawLine(g, startX + (cornerStart ? d + (vertical ? 1 : 0) : this.shadowSize + this.shadowBlendSize), y + d, endX - 1, y + d, vertical);
            ++i;
        }
    }

    private static void drawLine(Graphics g, int x1, int y1, int x2, int y2, boolean flip) {
        if (flip) {
            GraphicsUtil.drawOptimizedLine(g, y1, x1, y2, x2);
        } else {
            GraphicsUtil.drawOptimizedLine(g, x1, y1, x2, y2);
        }
    }

    private Color getShadowBlendColor(int offset, Color backgroundColor) {
        return backgroundColor == null ? new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), (int)(255.0f * this.shadowStrength * (float)(this.shadowBlendSize - offset) / (float)(this.shadowBlendSize + 1))) : ColorUtil.blend(backgroundColor, this.shadowColor, this.shadowStrength * (float)(this.shadowBlendSize - offset) / (float)(this.shadowBlendSize + 1));
    }

    private Color getShadowColor(Color backgroundColor) {
        return backgroundColor == null ? new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), (int)(255.0f * this.shadowStrength)) : ColorUtil.blend(backgroundColor, this.shadowColor, this.shadowStrength);
    }
}

