/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiPrintStream;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.internal.logging.console.ColorMap;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.sink.OutputEventRenderer;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.internal.nativeintegration.services.NativeServices;

public class ConsoleConfigureAction {
    private ConsoleConfigureAction() {
    }

    public static void execute(OutputEventRenderer renderer, ConsoleOutput consoleOutput) {
        ConsoleConfigureAction.execute(renderer, consoleOutput, ConsoleConfigureAction.getConsoleMetaData(), renderer.getOriginalStdOut(), renderer.getOriginalStdErr());
    }

    public static void execute(OutputEventRenderer renderer, ConsoleOutput consoleOutput, ConsoleMetaData consoleMetadata, OutputStream stdout, OutputStream stderr) {
        if (consoleOutput == ConsoleOutput.Auto) {
            ConsoleConfigureAction.configureAutoConsole(renderer, consoleMetadata, stdout, stderr);
        } else if (consoleOutput == ConsoleOutput.Rich) {
            ConsoleConfigureAction.configureRichConsole(renderer, consoleMetadata, stdout, stderr, false);
        } else if (consoleOutput == ConsoleOutput.Verbose) {
            ConsoleConfigureAction.configureRichConsole(renderer, consoleMetadata, stdout, stderr, true);
        } else if (consoleOutput == ConsoleOutput.Plain) {
            ConsoleConfigureAction.configurePlainConsole(renderer, consoleMetadata, stdout, stderr);
        } else if (consoleOutput == ConsoleOutput.Colored) {
            ConsoleConfigureAction.configureColoredConsole(renderer, consoleMetadata, stdout, stderr);
        }
    }

    private static ConsoleMetaData getConsoleMetaData() {
        ConsoleDetector consoleDetector = (ConsoleDetector)NativeServices.getInstance().get(ConsoleDetector.class);
        ConsoleMetaData metaData = consoleDetector.getConsole();
        if (metaData != null) {
            return metaData;
        }
        return FallbackConsoleMetaData.NOT_ATTACHED;
    }

    private static void configureAutoConsole(OutputEventRenderer renderer, ConsoleMetaData consoleMetaData, OutputStream stdout, OutputStream stderr) {
        if (consoleMetaData.isStdOutATerminal() && consoleMetaData.isStdErrATerminal()) {
            Console console = ConsoleConfigureAction.consoleForStdOut(stdout, consoleMetaData, renderer.getColourMap());
            renderer.addRichConsoleWithErrorOutputOnStdout(console, consoleMetaData, false);
        } else if (consoleMetaData.isStdOutATerminal()) {
            Console stdoutConsole = ConsoleConfigureAction.consoleForStdOut(stdout, consoleMetaData, renderer.getColourMap());
            renderer.addRichConsole(stdoutConsole, stderr, consoleMetaData, false);
        } else if (consoleMetaData.isStdErrATerminal()) {
            Console stderrConsole = ConsoleConfigureAction.consoleForStdErr(stderr, consoleMetaData, renderer.getColourMap());
            renderer.addRichConsole(stdout, stderrConsole, true);
        } else {
            renderer.addPlainConsole(stdout, stderr);
        }
    }

    private static void configurePlainConsole(OutputEventRenderer renderer, ConsoleMetaData consoleMetaData, OutputStream stdout, OutputStream stderr) {
        if (consoleMetaData.isStdOutATerminal() && consoleMetaData.isStdErrATerminal()) {
            renderer.addPlainConsoleWithErrorOutputOnStdout(stdout);
        } else {
            renderer.addPlainConsole(stdout, stderr);
        }
    }

    private static void configureColoredConsole(OutputEventRenderer renderer, ConsoleMetaData consoleMetaData, OutputStream stdout, OutputStream stderr) {
        if (consoleMetaData.isStdOutATerminal() && consoleMetaData.isStdErrATerminal()) {
            Console console = ConsoleConfigureAction.consoleForStdOut(stdout, consoleMetaData, renderer.getColourMap());
            renderer.addColoredConsoleWithErrorOutputOnStdout(console);
        } else {
            Console stdoutConsole = ConsoleConfigureAction.consoleForStdOut(stdout, consoleMetaData, renderer.getColourMap());
            Console stderrConsole = ConsoleConfigureAction.consoleForStdErr(stderr, consoleMetaData, renderer.getColourMap());
            renderer.addColoredConsole(stdoutConsole, stderrConsole);
        }
    }

    private static void configureRichConsole(OutputEventRenderer renderer, ConsoleMetaData consoleMetaData, OutputStream stdout, OutputStream stderr, boolean verbose) {
        if (consoleMetaData.isStdOutATerminal() && consoleMetaData.isStdErrATerminal()) {
            Console console = ConsoleConfigureAction.consoleForStdOut(stdout, consoleMetaData, renderer.getColourMap());
            renderer.addRichConsoleWithErrorOutputOnStdout(console, consoleMetaData, verbose);
        } else {
            Console stdoutConsole = ConsoleConfigureAction.consoleForStdOut(stdout, consoleMetaData, renderer.getColourMap());
            Console stderrConsole = ConsoleConfigureAction.consoleForStdErr(stderr, consoleMetaData, renderer.getColourMap());
            renderer.addRichConsole(stdoutConsole, stderrConsole, consoleMetaData, verbose);
        }
    }

    private static Console consoleFor(OutputStream stream, Supplier<OutputStream> jansiFallback, ConsoleMetaData consoleMetaData, ColorMap colourMap) {
        boolean force = !consoleMetaData.isWrapStreams();
        OutputStreamWriter writer = new OutputStreamWriter(force ? stream : jansiFallback.get(), Charset.defaultCharset());
        return new org.gradle.internal.logging.console.AnsiConsole((Appendable)writer, (Flushable)writer, colourMap, consoleMetaData, force);
    }

    private static Console consoleForStdOut(OutputStream stdout, ConsoleMetaData consoleMetaData, ColorMap colourMap) {
        return ConsoleConfigureAction.consoleFor(stdout, () -> ConsoleConfigureAction.installJansiStream(AnsiConsole.out()), consoleMetaData, colourMap);
    }

    private static Console consoleForStdErr(OutputStream stderr, ConsoleMetaData consoleMetaData, ColorMap colourMap) {
        return ConsoleConfigureAction.consoleFor(stderr, () -> ConsoleConfigureAction.installJansiStream(AnsiConsole.err()), consoleMetaData, colourMap);
    }

    private static OutputStream installJansiStream(AnsiPrintStream ansiPrintStream) {
        try {
            ansiPrintStream.install();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ansiPrintStream;
    }
}

