/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationException;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0001\u000fJ\u0018\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0004H&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0004H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "withLocalDeclarations", "", "getWithLocalDeclarations", "()Z", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformFlatRestricted", "Visitor", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nLower.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lower.kt\norg/jetbrains/kotlin/backend/common/DeclarationTransformer\n+ 2 transform.kt\norg/jetbrains/kotlin/ir/util/TransformKt\n*L\n1#1,320:1\n68#2,7:321\n*S KotlinDebug\n*F\n+ 1 Lower.kt\norg/jetbrains/kotlin/backend/common/DeclarationTransformer\n*L\n219#1:321,7\n*E\n"})
public interface DeclarationTransformer
extends FileLoweringPass {
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration var1);

    default public boolean getWithLocalDeclarations() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Visitor visitor2 = new Visitor(this);
        List<IrDeclaration> $this$transformFlat$iv = irFile.getDeclarations();
        boolean $i$f$transformFlat = false;
        int i$iv = 0;
        while (i$iv < $this$transformFlat$iv.size()) {
            List<IrDeclaration> list;
            void declaration;
            IrDeclaration item$iv;
            IrDeclaration irDeclaration = item$iv = $this$transformFlat$iv.get(i$iv);
            List<IrDeclaration> list2 = $this$transformFlat$iv;
            boolean bl = false;
            try {
                IrVisitorsKt.acceptVoid((IrElement)declaration, visitor2);
                list = this.transformFlatRestricted((IrDeclaration)declaration);
            }
            catch (CompilationException e2) {
                e2.initializeFileDetails(irFile);
                throw e2;
            }
            catch (Throwable e3) {
                throw CompilationExceptionKt.wrapWithCompilationException(e3, "Internal error in declaration transformer", irFile, (IrElement)declaration);
            }
            i$iv = TransformKt.replaceInPlace(list2, list, i$iv);
        }
    }

    private List<IrDeclaration> transformFlatRestricted(IrDeclaration declaration) {
        return (List)declaration.getFactory().getStageController().restrictTo(declaration, () -> DeclarationTransformer.transformFlatRestricted$lambda$0(this, declaration));
    }

    private static List transformFlatRestricted$lambda$0(DeclarationTransformer this$0, IrDeclaration $declaration) {
        return this$0.transformFlat($declaration);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer$Visitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "transformer", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nLower.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lower.kt\norg/jetbrains/kotlin/backend/common/DeclarationTransformer$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 transform.kt\norg/jetbrains/kotlin/ir/util/TransformKt\n*L\n1#1,320:1\n1869#2,2:321\n1869#2,2:323\n1869#2,2:332\n68#3,7:325\n82#3,12:334\n*S KotlinDebug\n*F\n+ 1 Lower.kt\norg/jetbrains/kotlin/backend/common/DeclarationTransformer$Visitor\n*L\n292#1:321,2\n293#1:323,2\n301#1:332,2\n295#1:325,7\n306#1:334,12\n*E\n"})
    private static final class Visitor
    extends IrVisitorVoid {
        @NotNull
        private final DeclarationTransformer transformer;

        public Visitor(@NotNull DeclarationTransformer transformer2) {
            Intrinsics.checkNotNullParameter((Object)transformer2, (String)"transformer");
            this.transformer = transformer2;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            IrVisitorsKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrVisitorsKt.acceptChildrenVoid((IrElement)declaration, this);
            for (IrValueParameter v2 : declaration.getParameters()) {
                List result2 = this.transformer.transformFlatRestricted(v2);
                if (result2 == null) continue;
                throw new IllegalStateException("Don't know how to add value parameters".toString());
            }
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Visitor visitor2 = this;
                IrField irField = declaration.getBackingField();
                if (irField != null) {
                    Visitor.visitProperty$transform(irField, visitor2, this, declaration);
                }
                IrSimpleFunction irSimpleFunction = declaration.getGetter();
                if (irSimpleFunction != null) {
                    Visitor.visitProperty$transform(irSimpleFunction, visitor2, this, declaration);
                }
                IrSimpleFunction irSimpleFunction2 = declaration.getSetter();
                if (irSimpleFunction2 == null) break block2;
                Visitor.visitProperty$transform(irSimpleFunction2, visitor2, this, declaration);
            }
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            IrDeclaration it;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrValueParameter irValueParameter = declaration.getThisReceiver();
            if (irValueParameter != null) {
                irValueParameter.accept(this, null);
            }
            Iterable $this$forEach$iv = declaration.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrTypeParameter)element$iv;
                boolean bl = false;
                ((IrTypeParameter)it).accept(this, null);
            }
            $this$forEach$iv = new ArrayList(declaration.getDeclarations());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrDeclaration)element$iv;
                boolean bl = false;
                it.accept(this, null);
            }
            List<IrDeclaration> $this$transformFlat$iv = declaration.getDeclarations();
            boolean $i$f$transformFlat = false;
            int i$iv = 0;
            while (i$iv < $this$transformFlat$iv.size()) {
                IrDeclaration item$iv;
                it = item$iv = $this$transformFlat$iv.get(i$iv);
                List<IrDeclaration> list = $this$transformFlat$iv;
                boolean bl = false;
                i$iv = TransformKt.replaceInPlace(list, this.transformer.transformFlatRestricted(it), i$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitScript(@NotNull IrScript declaration) {
            block3: {
                void $this$transformSubsetFlat$iv;
                int n2;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                List<IrStatement> $this$forEach$iv = new ArrayList(declaration.getStatements());
                boolean $i$f$forEach = false;
                for (Object t2 : $this$forEach$iv) {
                    IrStatement it = (IrStatement)t2;
                    boolean bl2 = false;
                    if (!this.transformer.getWithLocalDeclarations() && !(it instanceof IrDeclaration)) continue;
                    it.accept(this, null);
                }
                $this$forEach$iv = declaration.getStatements();
                DeclarationTransformer declarationTransformer2 = this.transformer;
                boolean $i$f$transformSubsetFlat = false;
                boolean bl = false;
                while (n2 < $this$transformSubsetFlat$iv.size()) {
                    void p0;
                    Object item$iv = $this$transformSubsetFlat$iv.get(n2);
                    if (!(item$iv instanceof IrDeclaration)) {
                        ++n2;
                        continue;
                    }
                    IrDeclaration bl2 = (IrDeclaration)item$iv;
                    void var9_14 = $this$transformSubsetFlat$iv;
                    boolean bl22 = false;
                    n2 = TransformKt.replaceInPlace(var9_14, declarationTransformer2.transformFlatRestricted((IrDeclaration)p0), n2);
                }
                IrValueParameter irValueParameter = declaration.getThisReceiver();
                if (irValueParameter == null) break block3;
                irValueParameter.accept(this, null);
            }
        }

        private static final boolean visitProperty$replaceInContainer(IrDeclaration $this$visitProperty_u24replaceInContainer, IrProperty $declaration, List<? super IrDeclaration> container, List<? extends IrDeclaration> result2) {
            int index = container.indexOf($this$visitProperty_u24replaceInContainer);
            if (index == -1) {
                index = container.indexOf($declaration);
            } else {
                container.remove(index);
                --index;
            }
            return container.addAll(index + 1, (Collection<? super IrDeclaration>)result2);
        }

        private static final void visitProperty$transform(IrDeclaration $this$visitProperty_u24transform, Visitor visitor2, Visitor this$0, IrProperty $declaration) {
            IrVisitorsKt.acceptVoid((IrElement)$this$visitProperty_u24transform, visitor2);
            List result2 = this$0.transformer.transformFlatRestricted($this$visitProperty_u24transform);
            if (result2 != null) {
                IrDeclarationParent parentCopy = $this$visitProperty_u24transform.getParent();
                if (parentCopy instanceof IrDeclarationContainer) {
                    Visitor.visitProperty$replaceInContainer($this$visitProperty_u24transform, $declaration, ((IrDeclarationContainer)parentCopy).getDeclarations(), result2);
                } else if (parentCopy instanceof IrStatementContainer) {
                    Visitor.visitProperty$replaceInContainer($this$visitProperty_u24transform, $declaration, ((IrStatementContainer)((Object)parentCopy)).getStatements(), result2);
                }
            }
        }
    }
}

