/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;

public class MultiPackIndexPrettyPrinter {
    public static void prettyPrint(byte[] rawMidx, PrintWriter out) {
        out.println("[ 0] Magic: " + new String(rawMidx, 0, 4, StandardCharsets.UTF_8));
        out.println("[ 4] Version number: " + rawMidx[4]);
        out.println("[ 5] OID version: " + rawMidx[5]);
        byte chunkCount = rawMidx[6];
        out.println("[ 6] # of chunks: " + chunkCount);
        out.println("[ 7] # of bases: " + rawMidx[7]);
        int numberOfPacks = NB.decodeInt32(rawMidx, 8);
        out.println("[ 8] # of packs: " + numberOfPacks);
        ArrayList<ChunkSegment> chunkSegments = new ArrayList<ChunkSegment>();
        int current = MultiPackIndexPrettyPrinter.printChunkLookup(out, rawMidx, chunkCount, chunkSegments);
        int i = 0;
        while (i < chunkSegments.size() - 1) {
            ChunkSegment segment = (ChunkSegment)chunkSegments.get(i);
            if ((long)current != segment.startOffset()) {
                throw new IllegalStateException(String.format("We are at byte %d, but segment should start at %d", current, segment.startOffset()));
            }
            out.printf("Starting chunk: %s @ %d%n", segment.chunkName(), segment.startOffset());
            switch (segment.chunkName()) {
                case "OIDF": {
                    current = MultiPackIndexPrettyPrinter.printOIDF(out, rawMidx, current);
                    break;
                }
                case "OIDL": {
                    current = MultiPackIndexPrettyPrinter.printOIDL(out, rawMidx, current, ((ChunkSegment)chunkSegments.get((int)(i + 1))).startOffset);
                    break;
                }
                case "OOFF": {
                    current = MultiPackIndexPrettyPrinter.printOOFF(out, rawMidx, current, ((ChunkSegment)chunkSegments.get((int)(i + 1))).startOffset);
                    break;
                }
                case "PNAM": {
                    current = MultiPackIndexPrettyPrinter.printPNAM(out, rawMidx, current, ((ChunkSegment)chunkSegments.get((int)(i + 1))).startOffset);
                    break;
                }
                case "RIDX": {
                    current = MultiPackIndexPrettyPrinter.printRIDX(out, rawMidx, current, ((ChunkSegment)chunkSegments.get((int)(i + 1))).startOffset);
                    break;
                }
                default: {
                    out.printf("Skipping %s (don't know how to print it yet)%n", segment.chunkName());
                    current = (int)((ChunkSegment)chunkSegments.get(i + 1)).startOffset();
                }
            }
            ++i;
        }
        out.printf("[ %d] Checksum %s%n", current, ObjectId.fromRaw(rawMidx, current).name());
        out.printf("Total size: " + (current + 20), new Object[0]);
    }

    private static int printChunkLookup(PrintWriter out, byte[] rawMidx, int chunkCount, List<ChunkSegment> chunkSegments) {
        out.println("Starting chunk lookup @ 12");
        int current = 12;
        int i = 0;
        while (i < chunkCount) {
            String chunkName = new String(rawMidx, current, 4, StandardCharsets.UTF_8);
            long offset = NB.decodeInt64(rawMidx, current + 4);
            out.printf("[ %d] |%8s|%8d|%n", current, chunkName, offset);
            current += 12;
            chunkSegments.add(new ChunkSegment(chunkName, offset));
            ++i;
        }
        String chunkName = "0000";
        long offset = NB.decodeInt64(rawMidx, current + 4);
        out.printf("[ %d] |%8s|%8d|%n", current, chunkName, offset);
        chunkSegments.add(new ChunkSegment(chunkName, offset));
        return current += 12;
    }

    private static int printOIDF(PrintWriter out, byte[] rawMidx, int start) {
        int current = start;
        short i = 0;
        while (i < 256) {
            out.printf("[ %d] (%02X) %d%n", current, i, NB.decodeInt32(rawMidx, current));
            current += 4;
            i = (short)(i + 1);
        }
        return current;
    }

    private static int printOIDL(PrintWriter out, byte[] rawMidx, int start, long end) {
        int i = start;
        while ((long)i < end) {
            out.printf("[ %d] %s%n", i, ObjectId.fromRaw(rawMidx, i).name());
            i += 20;
        }
        return i;
    }

    private static int printOOFF(PrintWriter out, byte[] rawMidx, int start, long end) {
        int i = start;
        while ((long)i < end) {
            out.printf("[ %d] %d %d%n", i, NB.decodeInt32(rawMidx, i), NB.decodeInt32(rawMidx, i + 4));
            i += 8;
        }
        return i;
    }

    private static int printRIDX(PrintWriter out, byte[] rawMidx, int start, long end) {
        int i = start;
        while ((long)i < end) {
            out.printf("[ %d] %d%n", i, NB.decodeInt32(rawMidx, i));
            i += 4;
        }
        return (int)end;
    }

    private static int printPNAM(PrintWriter out, byte[] rawMidx, int start, long end) {
        int nameStart = start;
        int i = start;
        while ((long)i < end) {
            if (rawMidx[i] == 0) {
                out.println(new String(rawMidx, nameStart, i - nameStart));
                nameStart = i + 1;
            }
            ++i;
        }
        return (int)end;
    }

    private record ChunkSegment(String chunkName, long startOffset) {
    }
}

