/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Repository
extends Disposable {
    @NotNull
    public VirtualFile getRoot();

    @NlsSafe
    @NotNull
    public String getPresentableUrl();

    @NotNull
    public Project getProject();

    @NotNull
    public State getState();

    @NlsSafe
    @Nullable
    public String getCurrentBranchName();

    @NotNull
    public AbstractVcs getVcs();

    @NlsSafe
    @Nullable
    public String getCurrentRevision();

    public boolean isFresh();

    public void update();

    @NonNls
    @NotNull
    public String toLogString();

    default public boolean isDisposed() {
        return false;
    }

    public static enum State {
        NORMAL,
        MERGING,
        REBASING,
        GRAFTING,
        REVERTING,
        DETACHED;

    }
}

