/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AdminClientRegisteredContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdatedContext;
import org.keycloak.services.clientpolicy.context.SamlAuthnRequestContext;
import org.keycloak.services.clientpolicy.context.SamlLogoutRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.utils.StringUtil;

public class SamlSecureClientUrisExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private final KeycloakSession session;
    private Configuration config;

    public SamlSecureClientUrisExecutor(KeycloakSession session) {
        this.session = session;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public void setupConfiguration(Configuration config) {
        this.config = config;
    }

    public String getProviderId() {
        return "saml-secure-client-uris";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTERED: {
                this.confirmSecureUris(((AdminClientRegisteredContext)context).getTargetClient());
                break;
            }
            case UPDATED: {
                this.confirmSecureUris(((AdminClientUpdatedContext)context).getTargetClient());
                break;
            }
            case SAML_AUTHN_REQUEST: {
                this.confirmLoginRedirectUri((SamlAuthnRequestContext)context);
                break;
            }
            case SAML_LOGOUT_REQUEST: {
                this.confirmLogoutRedirectUri((SamlLogoutRequestContext)context);
            }
        }
    }

    private void confirmLoginRedirectUri(SamlAuthnRequestContext context) throws ClientPolicyException {
        AuthnRequestType request = (AuthnRequestType)context.getRequest();
        URI uri = request.getAssertionConsumerServiceURL();
        if (uri != null) {
            this.confirmSecureUri(uri.toString(), "AssertionConsumerServiceURL", "invalid_request");
        } else {
            ClientModel client = context.getClient();
            this.confirmSecureUri(client.getManagementUrl(), "Master SAML Processing URL", "invalid_request");
            this.confirmSecureUri(client.getAttribute("saml_assertion_consumer_url_post"), "Assertion Consumer Service POST Binding URL", "invalid_request");
            this.confirmSecureUri(client.getAttribute("saml_assertion_consumer_url_redirect"), "Assertion Consumer Service Redirect Binding URL", "invalid_request");
            this.confirmSecureUri(client.getAttribute("saml_artifact_binding_url"), "Artifact Binding URL", "invalid_request");
        }
    }

    private void confirmLogoutRedirectUri(SamlLogoutRequestContext context) throws ClientPolicyException {
        ClientModel client = context.getClient();
        this.confirmSecureUri(client.getManagementUrl(), "Master SAML Processing URL", "invalid_request");
        this.confirmSecureUri(client.getAttribute("saml_single_logout_service_url_post"), "Logout Service POST Binding URL", "invalid_request");
        this.confirmSecureUri(client.getAttribute("saml_single_logout_service_url_artifact"), "Logout Service ARTIFACT Binding URL", "invalid_request");
        this.confirmSecureUri(client.getAttribute("saml_single_logout_service_url_redirect"), "Logout Service Redirect Binding URL", "invalid_request");
        this.confirmSecureUri(client.getAttribute("saml_single_logout_service_url_soap"), "Logout Service SOAP Binding URL", "invalid_request");
    }

    private void confirmSecureUri(String uri, String uriType) throws ClientPolicyException {
        this.confirmSecureUri(uri, uriType, "invalid_client_metadata");
    }

    private void confirmSecureUri(String uri, String uriType, String error) throws ClientPolicyException {
        if (StringUtil.isBlank((String)uri)) {
            return;
        }
        if (!uri.startsWith("https:")) {
            throw new ClientPolicyException(error, "Non secure scheme for " + uriType);
        }
    }

    private void confirmNoWildcard(String uri, String uriType) throws ClientPolicyException {
        if (uri.endsWith("*") && !uri.contains("?") && !uri.contains("#")) {
            throw new ClientPolicyException("invalid_client_metadata", "Unsecure wildcard redirect " + uri + " for " + uriType);
        }
    }

    private void confirmRedirectUris(Collection<String> uris, String uriType) throws ClientPolicyException {
        if (uris == null) {
            return;
        }
        for (String uri : uris) {
            this.confirmSecureUri(uri, uriType);
            if (this.config.isAllowWildcardResirects()) continue;
            this.confirmNoWildcard(uri, uriType);
        }
    }

    private void confirmSecureUris(ClientModel client) throws ClientPolicyException {
        if (!"saml".equals(client.getProtocol())) {
            return;
        }
        this.confirmSecureUri(client.getRootUrl(), "Root URL");
        this.confirmSecureUri(client.getManagementUrl(), "Master SAML Processing URL");
        this.confirmSecureUri(client.getBaseUrl(), "Home URL");
        this.confirmRedirectUris(RedirectUtils.resolveValidRedirects(this.session, client.getRootUrl(), client.getRedirectUris()), "Valid redirect URIs");
        Map<String, String> attrs = Map.of("saml_assertion_consumer_url_post", "Assertion Consumer Service POST Binding URL", "saml_assertion_consumer_url_redirect", "Assertion Consumer Service Redirect Binding URL", "saml_artifact_binding_url", "Artifact Binding URL", "saml_single_logout_service_url_post", "Logout Service POST Binding URL", "saml_single_logout_service_url_artifact", "Logout Service ARTIFACT Binding URL", "saml_single_logout_service_url_redirect", "Logout Service Redirect Binding URL", "saml_single_logout_service_url_soap", "Logout Service SOAP Binding URL", "saml_artifact_resolution_service_url", "Artifact Resolution Service");
        if (client.getAttributes() != null) {
            for (Map.Entry<String, String> attr : attrs.entrySet()) {
                this.confirmSecureUri(client.getAttribute(attr.getKey()), attr.getValue());
            }
        }
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="allow-wildcard-redirects")
        protected boolean allowWildcardRedirects;

        public Configuration() {
            this(false);
        }

        public Configuration(boolean allowWildcardRedirects) {
            this.allowWildcardRedirects = allowWildcardRedirects;
        }

        public boolean isAllowWildcardResirects() {
            return this.allowWildcardRedirects;
        }

        public void setAllowWildcardResirects(boolean allowWildcardRedirects) {
            this.allowWildcardRedirects = allowWildcardRedirects;
        }
    }
}

