/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.compositediagram.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.compositediagram.CompositeDiagram;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandLinkBlock
extends SingleLineCommand2<CompositeDiagram> {
    public CommandLinkBlock() {
        super(CommandLinkBlock.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandLinkBlock.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "ENT1", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "DECO1", "(\\[\\]|\\*\\))?"), new RegexLeaf(1, "QUEUE", "([=-]+|\\.+)"), new RegexLeaf(1, "DECO2", "(\\[\\]|\\(\\*)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "ENT2", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "DISPLAY", "(\\S*+)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(CompositeDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String ent1 = arg.get("ENT1", 0);
        String ent2 = arg.get("ENT2", 0);
        Quark<Entity> quark1 = diagram.quarkInContext(true, diagram.cleanId(ent1));
        Quark<Entity> quark2 = diagram.quarkInContext(true, diagram.cleanId(ent2));
        Entity cl1 = quark1.getData();
        if (cl1 == null) {
            return CommandExecutionResult.error("No such element " + quark1.getName());
        }
        Entity cl2 = quark2.getData();
        if (cl2 == null) {
            return CommandExecutionResult.error("No such element " + quark2.getName());
        }
        String deco1 = arg.get("DECO1", 0);
        String deco2 = arg.get("DECO2", 0);
        LinkType linkType = new LinkType(this.getLinkDecor(deco1), this.getLinkDecor(deco2));
        String queue = arg.get("QUEUE", 0);
        LinkArg linkArg = LinkArg.build(Display.getWithNewlines(diagram.getPragma(), arg.get("DISPLAY", 0)), queue.length(), diagram.getSkinParam().classAttributeIconSize() > 0);
        Link link = new Link(location, diagram, diagram.getSkinParam().getCurrentStyleBuilder(), cl1, cl2, linkType, linkArg);
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private LinkDecor getLinkDecor(String s) {
        if ("[]".equals(s)) {
            return LinkDecor.SQUARE_toberemoved;
        }
        return LinkDecor.NONE;
    }
}

