/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import schemacrawler.crawl.ImmutableDatabaseProperty;
import schemacrawler.schema.DatabaseInfo;
import us.fatehi.utility.database.DatabaseInformation;
import us.fatehi.utility.property.BaseProductVersion;
import us.fatehi.utility.property.Property;

final class MutableDatabaseInfo
extends BaseProductVersion
implements DatabaseInfo {
    private static final long serialVersionUID = 4051323422934251828L;
    private final DatabaseInformation databaseInformation;
    private final Set<Property> serverInfo;
    private final Set<Property> databaseProperties;

    public MutableDatabaseInfo(DatabaseInformation databaseInformation) {
        super(databaseInformation);
        this.databaseInformation = databaseInformation;
        this.serverInfo = new HashSet<Property>();
        this.databaseProperties = new HashSet<Property>();
    }

    @Override
    public Collection<Property> getProperties() {
        ArrayList<Property> properties = new ArrayList<Property>(this.databaseProperties);
        properties.sort(Comparator.naturalOrder());
        return properties;
    }

    @Override
    public Collection<Property> getServerInfo() {
        return new TreeSet<Property>(this.serverInfo);
    }

    @Override
    public String getUserName() {
        return this.databaseInformation.getUserName();
    }

    @Override
    public String toString() {
        return this.databaseInformation.toString();
    }

    void addAll(Collection<ImmutableDatabaseProperty> dbProperties) {
        if (dbProperties != null) {
            this.databaseProperties.addAll(dbProperties);
        }
    }

    void addServerInfo(Property property) {
        if (property != null) {
            this.serverInfo.add(property);
        }
    }
}

