/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.readconfig;

import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.readconfig.ReadConfig;

public final class SystemPropertiesConfig
implements ReadConfig {
    private static final Logger LOGGER = Logger.getLogger(SystemPropertiesConfig.class.getName());

    @Override
    public boolean containsKey(String propertyName) {
        boolean containsKey = this.getSystemProperty(propertyName) != null;
        return containsKey;
    }

    @Override
    public String getStringValue(String propertyName, String defaultValue) {
        if (propertyName == null) {
            return defaultValue;
        }
        try {
            Object value = this.getSystemProperty(propertyName);
            return value != null ? value.toString() : defaultValue;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error reading key: " + propertyName + " = value class: " + e.getClass().getSimpleName());
            return defaultValue;
        }
    }

    private Object getSystemProperty(String propertyName) {
        return System.getProperties().get(propertyName);
    }
}

