/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator;

import com.ibm.db2.cmx.annotation.Call;
import com.ibm.db2.cmx.annotation.Select;
import com.ibm.db2.cmx.annotation.Update;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXml;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlAnnotation;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDataTypeInfo;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlHint;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlJavaInterface;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlJavaMethod;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlNamedNativeQuery;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlNamedQuery;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlOrigin;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlOrmFile;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlPackage;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlParameter;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlParameterMetaData;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlRSColumn;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlResultSetMetaData;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlSourceFile;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatement;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementMetadata;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementSet;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementSetMetaData;
import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generator.CodeDumper;
import com.ibm.db2.cmx.tools.internal.generator.codegen.ClassGenerator;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MetaDataInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class MetadataPrinterImpl {
    public void print(ClassInfo classInfo, CodeDumper codeDumper, Writer writer, String string) {
        ToolsLogger.getLogger().log(Level.FINEST, "generating application metadata for: " + classInfo.getQualifiedImplName());
        String string2 = this.convertClassInfoToXMLString(classInfo);
        codeDumper.writeMetadata(string2, writer, string);
        ToolsLogger.getLogger().log(Level.FINEST, "metadata created: \n" + string2);
    }

    public String convertClassInfoToXMLString(ClassInfo classInfo) {
        PDQXml pDQXml = new PDQXml();
        this.buildProgramSet(classInfo, pDQXml);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + pDQXml.getXml(0);
    }

    private void buildProgramSet(ClassInfo classInfo, PDQXml pDQXml) {
        this.addOrigin(classInfo, pDQXml);
        this.addStatementSet(classInfo, pDQXml);
    }

    private void addOrigin(ClassInfo classInfo, PDQXml pDQXml) {
        PDQXmlOrigin pDQXmlOrigin = new PDQXmlOrigin();
        pDQXml.setOrigin(pDQXmlOrigin);
        pDQXmlOrigin.setOriginType("pureQueryAPI");
        ClassInfo.OriginInfo originInfo = classInfo.getOriginInfo();
        if (originInfo != null) {
            pDQXmlOrigin.setPDQXmlOriginEnvironment(originInfo.getOriginEnv());
        }
    }

    private void addStatementSet(ClassInfo classInfo, PDQXml pDQXml) {
        PDQXmlStatementSet pDQXmlStatementSet = new PDQXmlStatementSet();
        pDQXml.getStatementSets().add(pDQXmlStatementSet);
        pDQXmlStatementSet.setName(classInfo.getQualifiedImplName());
        this.addStatementSetMetaData(classInfo, pDQXmlStatementSet);
        this.addPackage(classInfo, pDQXmlStatementSet);
        this.addStatements(classInfo, pDQXmlStatementSet);
    }

    private void addStatementSetMetaData(ClassInfo classInfo, PDQXmlStatementSet pDQXmlStatementSet) {
        PDQXmlStatementSetMetaData pDQXmlStatementSetMetaData = new PDQXmlStatementSetMetaData();
        pDQXmlStatementSet.setStatementSetMetaData(pDQXmlStatementSetMetaData);
        PDQXmlSourceFile pDQXmlSourceFile = new PDQXmlSourceFile();
        pDQXmlStatementSetMetaData.setSourceFile(pDQXmlSourceFile);
        pDQXmlSourceFile.setName(classInfo.getImplTypeName() + ".java");
        pDQXmlSourceFile.setContainer(classInfo.getPackageName());
        pDQXmlSourceFile.setCompletePath(classInfo.getOriginInfo().getOutputFileCompletePathAndRootName() + ".java");
        PDQXmlJavaInterface pDQXmlJavaInterface = new PDQXmlJavaInterface();
        pDQXmlStatementSetMetaData.setJavaInterface(pDQXmlJavaInterface);
        pDQXmlJavaInterface.setName(classInfo.getTypeName());
        pDQXmlJavaInterface.setContainer(classInfo.getPackageName());
        if (classInfo.getOriginInfo().getAbsolutePathToXmlFile() != null) {
            PDQXmlOrmFile pDQXmlOrmFile = new PDQXmlOrmFile();
            pDQXmlStatementSetMetaData.setOrmFile(pDQXmlOrmFile);
            pDQXmlOrmFile.setOrmFileName(classInfo.getOriginInfo().getAbsolutePathToXmlFile());
            pDQXmlOrmFile.setOrmFileDate(MetadataPrinterImpl.returnFormattedDate(classInfo.getOriginInfo().getLastModificationDateOfXmlFile()));
        }
    }

    private void addPackage(ClassInfo classInfo, PDQXmlStatementSet pDQXmlStatementSet) {
        PDQXmlPackage pDQXmlPackage = new PDQXmlPackage();
        pDQXmlStatementSet.setPackage(pDQXmlPackage);
        pDQXmlPackage.setPackageName(classInfo.getRootPkgName());
        if (classInfo.getConTokenBytes() != null) {
            pDQXmlPackage.setConsistencyToken(StatementDescriptorImpl.bytesToTimestamp(classInfo.getConTokenBytes()));
        } else {
            pDQXmlPackage.setConsistencyToken(classInfo.getTimeStamp());
        }
        pDQXmlPackage.setPackageVersion(classInfo.getPackageVersion());
        pDQXmlPackage.setCollectionName(classInfo.getCollectionName());
        if (classInfo.isForceSingleBindIsolation()) {
            pDQXmlPackage.setForceSingleBindIsolation(true);
        }
    }

    private void addStatements(ClassInfo classInfo, PDQXmlStatementSet pDQXmlStatementSet) {
        List<MethodInfo> list = classInfo.getListOfMethods();
        for (MethodInfo methodInfo : list) {
            PDQXmlStatement pDQXmlStatement = new PDQXmlStatement();
            int n2 = methodInfo.getValue();
            pDQXmlStatement.setId(String.valueOf(n2));
            pDQXmlStatementSet.getStatements().add(pDQXmlStatement);
            this.addStatementDescriptor(methodInfo, pDQXmlStatement, classInfo.getQualifiedImplName());
            this.addStatementMetaData(methodInfo, pDQXmlStatement);
        }
    }

    private void addStatementDescriptor(MethodInfo methodInfo, PDQXmlStatement pDQXmlStatement, String string) {
        PDQXmlStatementDescriptor pDQXmlStatementDescriptor = new PDQXmlStatementDescriptor();
        pDQXmlStatement.setPDQXmlStatementDescriptor(pDQXmlStatementDescriptor);
        pDQXmlStatementDescriptor.setSql(methodInfo.getProcessedSql());
        pDQXmlStatementDescriptor.setStatementType(methodInfo.getSqlStatementType());
        List<String> list = null;
        if (methodInfo.hasAutoGeneratedKeys() && (methodInfo.getSqlStatementType() == SqlStatementType.UPDATE || methodInfo.getSqlStatementType() == SqlStatementType.INSERT || methodInfo.getSqlStatementType() == SqlStatementType.MERGE)) {
            list = methodInfo.getInputBeanInfo().get(0).getAutoGeneratedKeys();
        }
        String[] stringArray = null;
        if (list != null) {
            stringArray = list.toArray(new String[0]);
        }
        if (stringArray != null) {
            pDQXmlStatementDescriptor.setAutogenColumnNames(stringArray);
        }
        if (methodInfo.getParameterHandlerType() != MethodInfo.HandlerType.NoHandler) {
            pDQXmlStatementDescriptor.setParameterHandlerName(methodInfo.getQualifiedParameterHandlerClassNameForStatementDescriptor(string));
        }
        PDQXmlParameterMetaData pDQXmlParameterMetaData = this.getParameterMetaData(methodInfo.getParameterMetaDataInfo());
        pDQXmlStatementDescriptor.setParameterMetadata(pDQXmlParameterMetaData);
        if (methodInfo.getResultHandlerType() != MethodInfo.HandlerType.NoHandler) {
            pDQXmlStatementDescriptor.setResultHandlerName(methodInfo.getQualifiedResultHandlerClassNameForStatementDescriptor(string));
        }
        if (methodInfo.getRowHandlerType() != MethodInfo.HandlerType.NoHandler) {
            pDQXmlStatementDescriptor.setRowHandlerName(methodInfo.getQualifiedRowHandlerClassNameForStatementDescriptor(string));
        }
        PDQXmlResultSetMetaData pDQXmlResultSetMetaData = this.getResultMetaData(methodInfo.getResultMetaDataInfo());
        pDQXmlStatementDescriptor.setResultSetMetaData(pDQXmlResultSetMetaData);
        PDQXmlStatementAttributes pDQXmlStatementAttributes = PDQXmlStatementAttributes.getPDQXmlStatementAttributesForPdqAPI();
        pDQXmlStatementDescriptor.setStatementAttributes(pDQXmlStatementAttributes);
        pDQXmlStatementAttributes.setConcurrency(methodInfo.getCursorConcurrency());
        pDQXmlStatementAttributes.setHoldability(methodInfo.getCursorHoldability());
        pDQXmlStatementAttributes.setType(methodInfo.getCursorType());
        pDQXmlStatementAttributes.setParameterType(methodInfo.getStatementAttributeParameterType());
        pDQXmlStatementAttributes.setRowType(methodInfo.getStatementAttributeRowType());
        pDQXmlStatementAttributes.setCursorName(methodInfo.getCursorName());
        pDQXmlStatementAttributes.setPositionedCursorName(methodInfo.getPositionedCursorName());
        if (methodInfo.getCallHandlerType() != MethodInfo.HandlerType.NoHandler) {
            pDQXmlStatementDescriptor.setCallHandlerName(methodInfo.getQualifiedCallHandlerClassNameForStatementDescriptor(string));
        }
        pDQXmlStatementDescriptor.setSectionNumber(methodInfo.getValue());
    }

    private void addStatementMetaData(MethodInfo methodInfo, PDQXmlStatement pDQXmlStatement) {
        XmlExporter xmlExporter;
        PDQXmlStatementMetadata pDQXmlStatementMetadata = new PDQXmlStatementMetadata();
        pDQXmlStatement.setPDQXmlStatementMetadata(pDQXmlStatementMetadata);
        PDQXmlJavaMethod pDQXmlJavaMethod = new PDQXmlJavaMethod();
        pDQXmlStatementMetadata.setJavaMethod(pDQXmlJavaMethod);
        pDQXmlJavaMethod.setMethodName(methodInfo.getMethodName());
        pDQXmlJavaMethod.setJavaMethodSignature(methodInfo.getJavaMethodSignature());
        pDQXmlJavaMethod.setSourceCodeLineNumber(methodInfo.getLineNumber());
        Class<?> clazz = methodInfo.getAnnotationType();
        if (!(null == clazz || "".equals(methodInfo.getSql()) && "".equals(methodInfo.getPatternString()))) {
            xmlExporter = new PDQXmlAnnotation();
            pDQXmlJavaMethod.setAnnotation((PDQXmlAnnotation)xmlExporter);
            if (Select.class == clazz) {
                ((PDQXmlAnnotation)xmlExporter).setType("Select");
            } else if (Update.class == clazz) {
                ((PDQXmlAnnotation)xmlExporter).setType("Update");
            } else if (Call.class == clazz) {
                ((PDQXmlAnnotation)xmlExporter).setType("Call");
            }
            if (((PDQXmlAnnotation)xmlExporter).getType() != null) {
                if (!"".equals(methodInfo.getSql())) {
                    ((PDQXmlAnnotation)xmlExporter).setSql(methodInfo.getSql());
                }
                if (!"".equals(methodInfo.getPatternString())) {
                    ((PDQXmlAnnotation)xmlExporter).setPattern(methodInfo.getPatternString());
                }
            }
        }
        if (methodInfo.getNamedNativeQueryName() != null && methodInfo.getNamedNativeQueryName() != "") {
            Properties properties;
            xmlExporter = new PDQXmlNamedNativeQuery();
            pDQXmlStatementMetadata.addNamedNativeQuery((PDQXmlNamedNativeQuery)xmlExporter);
            ((PDQXmlNamedQuery)xmlExporter).setName(methodInfo.getNamedNativeQueryName());
            if (methodInfo.usesNamedNativeQuerySql()) {
                ((PDQXmlNamedNativeQuery)xmlExporter).setSql(methodInfo.getSql());
            }
            if ((properties = methodInfo.getNamedNativeQueryHints()) != null) {
                for (Object object : properties.keySet()) {
                    PDQXmlHint pDQXmlHint = new PDQXmlHint();
                    ((PDQXmlNamedNativeQuery)xmlExporter).getHints().add(pDQXmlHint);
                    pDQXmlHint.setName((String)object);
                    pDQXmlHint.setValue((String)properties.get(object));
                }
            }
        }
    }

    private PDQXmlParameterMetaData getParameterMetaData(MetaDataInfo metaDataInfo) {
        if (metaDataInfo != null) {
            PDQXmlParameterMetaData pDQXmlParameterMetaData = new PDQXmlParameterMetaData();
            int n2 = metaDataInfo.getColumnCount();
            ArrayList<PDQXmlParameter> arrayList = new ArrayList<PDQXmlParameter>();
            int[] nArray = metaDataInfo.getSqlParmMode();
            for (int i10 = 0; i10 < n2; ++i10) {
                PDQXmlParameter pDQXmlParameter = new PDQXmlParameter();
                pDQXmlParameter.setParameterMode(nArray[i10]);
                arrayList.add(pDQXmlParameter);
            }
            this.getCommonMetaData(metaDataInfo, arrayList);
            pDQXmlParameterMetaData.setParameters(arrayList);
            return pDQXmlParameterMetaData;
        }
        return null;
    }

    private PDQXmlResultSetMetaData getResultMetaData(MetaDataInfo metaDataInfo) {
        if (metaDataInfo != null) {
            PDQXmlResultSetMetaData pDQXmlResultSetMetaData = new PDQXmlResultSetMetaData();
            int n2 = metaDataInfo.getColumnCount();
            ArrayList<PDQXmlRSColumn> arrayList = new ArrayList<PDQXmlRSColumn>();
            int[] nArray = metaDataInfo.getSqlCcsid();
            for (int i10 = 0; i10 < n2; ++i10) {
                PDQXmlRSColumn pDQXmlRSColumn = new PDQXmlRSColumn();
                pDQXmlRSColumn.setCcsid(nArray[i10]);
                arrayList.add(pDQXmlRSColumn);
            }
            this.getCommonMetaData(metaDataInfo, arrayList);
            pDQXmlResultSetMetaData.setColumns(arrayList);
            return pDQXmlResultSetMetaData;
        }
        return null;
    }

    private void getCommonMetaData(MetaDataInfo metaDataInfo, ArrayList<? extends PDQXmlDataTypeInfo> arrayList) {
        int n2 = arrayList.size();
        int[] nArray = metaDataInfo.getSqlTypeForStorageInImplOrXml();
        int[] nArray2 = metaDataInfo.getSqlPrecision();
        int[] nArray3 = metaDataInfo.getSqlScale();
        for (int i10 = 0; i10 < n2; ++i10) {
            PDQXmlDataTypeInfo pDQXmlDataTypeInfo = arrayList.get(i10);
            pDQXmlDataTypeInfo.setJdbcType(nArray[i10]);
            pDQXmlDataTypeInfo.setPrecision(nArray2[i10]);
            pDQXmlDataTypeInfo.setScale(nArray3[i10]);
        }
    }

    private static String returnFormattedDate(long l2) {
        ClassGenerator.calendar__.setTimeInMillis(l2);
        return ClassGenerator.simpleDateFormat__.format(ClassGenerator.calendar__.getTime());
    }
}

