/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

public abstract class GetTables
extends AbstractMetadataMethod {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(12, DbMetadataMediator.datatypeCoder).at(0).simple(449, 63, "TABLE_CAT", "TABLES").addField().at(1).simple(449, 63, "TABLE_SCHEM", "TABLES").addField().at(2).simple(448, 63, "TABLE_NAME", "TABLES").addField().at(3).simple(448, 20, "TABLE_TYPE", "TABLES").addField().at(4).simple(449, Integer.MAX_VALUE, "REMARKS", "TABLES").addField().at(5).simple(449, 63, "TYPE_CAT", "TABLES").addField().at(6).simple(449, 63, "TYPE_SCHEM", "TABLES").addField().at(7).simple(449, 63, "TYPE_NAME", "TABLES").addField().at(8).simple(449, 63, "SELF_REFERENCING_COL_NAME", "TABLES").addField().at(9).simple(449, 10, "REF_GENERATION", "TABLES").addField().at(10).simple(449, 63, "OWNER_NAME", "TABLES").addField().at(11).simple(500, 0, "JB_RELATION_ID", "TABLES").addField().toRowDescriptor();
    private static final RowDescriptor ROW_DESCRIPTOR_TABLE_TYPES = new RowDescriptorBuilder(1, DbMetadataMediator.datatypeCoder).at(0).simple(448, 31, "TABLE_TYPE", "TABLETYPES").addField().toRowDescriptor();

    private GetTables(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public final ResultSet getTables(String tableNamePattern, String[] types) throws SQLException {
        if ("".equals(tableNamePattern) || types != null && types.length == 0) {
            return this.createEmpty();
        }
        DbMetadataMediator.MetadataQuery metadataQuery = this.createGetTablesQuery(tableNamePattern, this.toTypesSet(types));
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    final RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        return valueBuilder.at(2).setString(rs.getString("TABLE_NAME")).at(3).setString(rs.getString("TABLE_TYPE")).at(4).setString(rs.getString("REMARKS")).at(10).setString(rs.getString("OWNER_NAME")).at(11).setShort(rs.getShort("JB_RELATION_ID")).toRowValue(true);
    }

    public final ResultSet getTableTypes() throws SQLException {
        RowValueBuilder valueBuilder = new RowValueBuilder(ROW_DESCRIPTOR_TABLE_TYPES);
        Set<String> tableTypes = this.allTableTypes();
        ArrayList<RowValue> rows = new ArrayList<RowValue>(tableTypes.size());
        for (String tableType : tableTypes) {
            valueBuilder.at(0).setString(tableType);
            rows.add(valueBuilder.toRowValue(false));
        }
        return new FBResultSet(ROW_DESCRIPTOR_TABLE_TYPES, rows);
    }

    public final String[] getTableTypeNames() {
        return this.allTableTypes().toArray(new String[0]);
    }

    private Set<String> toTypesSet(String[] types) {
        return types != null ? new HashSet<String>(Arrays.asList(types)) : this.allTableTypes();
    }

    abstract DbMetadataMediator.MetadataQuery createGetTablesQuery(String var1, Set<String> var2);

    abstract Set<String> allTableTypes();

    public static GetTables create(DbMetadataMediator mediator) {
        if (mediator.isOdsEqualOrAbove(11, 2)) {
            return FB2_5.createInstance(mediator);
        }
        return FB2_1.createInstance(mediator);
    }

    private static final class FB2_5
    extends GetTables {
        private static final String GET_TABLE_ORDER_BY_2_5 = "\norder by 2, 1";
        private static final String LEGACY_IS_TABLE = "rdb$relation_type is null and rdb$view_blr is null";
        private static final String LEGACY_IS_VIEW = "rdb$relation_type is null and rdb$view_blr is not null";
        private static final String TABLE_COLUMNS_2_5 = "select\n  trim(trailing from RDB$RELATION_NAME) as TABLE_NAME,\n  trim(trailing from case    when rdb$relation_type = 0 or rdb$relation_type is null and rdb$view_blr is null then case when RDB$SYSTEM_FLAG = 1 then 'SYSTEM TABLE' else 'TABLE' end\n    when rdb$relation_type = 1 or rdb$relation_type is null and rdb$view_blr is not null then 'VIEW'\n    when rdb$relation_type = 2 then 'TABLE'\n    when rdb$relation_type = 3 then 'SYSTEM TABLE'\n    when rdb$relation_type in (4, 5) then 'GLOBAL TEMPORARY'\n  end) as TABLE_TYPE,\n  RDB$DESCRIPTION as REMARKS,\n  trim(trailing from RDB$OWNER_NAME) as OWNER_NAME,\n  RDB$RELATION_ID as JB_RELATION_ID\nfrom RDB$RELATIONS";
        private static final Set<String> ALL_TYPES_2_5 = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("GLOBAL TEMPORARY", "SYSTEM TABLE", "TABLE", "VIEW")));

        private FB2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetTables createInstance(DbMetadataMediator mediator) {
            return new FB2_5(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetTablesQuery(String tableNamePattern, Set<String> types) {
            List<String> params;
            Clause tableNameClause = new Clause("RDB$RELATION_NAME", tableNamePattern);
            StringBuilder queryBuilder = new StringBuilder(1000).append(TABLE_COLUMNS_2_5);
            if (tableNameClause.hasCondition()) {
                queryBuilder.append("\nwhere ").append(tableNameClause.getCondition(false));
                params = Clause.parameters(tableNameClause);
            } else {
                params = Collections.emptyList();
            }
            if (!types.containsAll(ALL_TYPES_2_5)) {
                StringBuilder typeCondition = new StringBuilder(120);
                if (types.contains("SYSTEM TABLE") && types.contains("TABLE")) {
                    typeCondition.append("(rdb$relation_type in (0, 2, 3) or rdb$relation_type is null and rdb$view_blr is null)");
                } else if (types.contains("SYSTEM TABLE")) {
                    typeCondition.append("(rdb$relation_type in (0, 3) or rdb$relation_type is null and rdb$view_blr is null) and rdb$system_flag = 1");
                } else if (types.contains("TABLE")) {
                    typeCondition.append("(rdb$relation_type in (0, 2) or rdb$relation_type is null and rdb$view_blr is null) and rdb$system_flag = 0");
                }
                if (types.contains("VIEW")) {
                    if (typeCondition.length() > 0) {
                        typeCondition.append(" or ");
                    }
                    typeCondition.append("(rdb$relation_type = 1 or rdb$relation_type is null and rdb$view_blr is not null)");
                }
                if (types.contains("GLOBAL TEMPORARY")) {
                    if (typeCondition.length() > 0) {
                        typeCondition.append(" or ");
                    }
                    typeCondition.append("rdb$relation_type in (4, 5)");
                }
                if (typeCondition.length() == 0) {
                    typeCondition.append("1 = 0");
                }
                if (tableNameClause.hasCondition()) {
                    queryBuilder.append("\nand (").append((CharSequence)typeCondition).append(")");
                } else {
                    queryBuilder.append("\nwhere ").append((CharSequence)typeCondition);
                }
            }
            queryBuilder.append(GET_TABLE_ORDER_BY_2_5);
            return new DbMetadataMediator.MetadataQuery(queryBuilder.toString(), params);
        }

        @Override
        Set<String> allTableTypes() {
            return ALL_TYPES_2_5;
        }
    }

    private static final class FB2_1
    extends GetTables {
        private static final String TABLE_COLUMNS_SYSTEM_2_1 = FB2_1.formatTableQuery("SYSTEM TABLE", "RDB$SYSTEM_FLAG = 1 and rdb$view_blr is null");
        private static final String TABLE_COLUMNS_NORMAL_2_1 = FB2_1.formatTableQuery("TABLE", "RDB$SYSTEM_FLAG = 0 and rdb$view_blr is null");
        private static final String TABLE_COLUMNS_VIEW_2_1 = FB2_1.formatTableQuery("VIEW", "rdb$view_blr is not null");
        private static final String GET_TABLE_ORDER_BY_2_1 = "\norder by 2, 1";
        private static final Map<String, String> QUERY_PER_TYPE;
        private static final Set<String> ALL_TYPES_2_1;

        private FB2_1(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetTables createInstance(DbMetadataMediator mediator) {
            return new FB2_1(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetTablesQuery(String tableNamePattern, Set<String> types) {
            Clause tableNameClause = new Clause("RDB$RELATION_NAME", tableNamePattern);
            ArrayList<Clause> clauses = new ArrayList<Clause>(types.size());
            StringBuilder queryBuilder = new StringBuilder(2000);
            String tableNameCondition = tableNameClause.getCondition("\nand ", "");
            QUERY_PER_TYPE.entrySet().stream().filter(typeAndQuery -> types.contains(typeAndQuery.getKey())).map(Map.Entry::getValue).forEach(query -> {
                if (queryBuilder.length() > 0) {
                    queryBuilder.append("\nunion all\n");
                }
                queryBuilder.append((String)query).append(tableNameCondition);
                clauses.add(tableNameClause);
            });
            queryBuilder.append(GET_TABLE_ORDER_BY_2_1);
            return new DbMetadataMediator.MetadataQuery(queryBuilder.toString(), Clause.parameters(clauses));
        }

        @Override
        Set<String> allTableTypes() {
            return ALL_TYPES_2_1;
        }

        private static String formatTableQuery(String tableType, String condition) {
            return String.format("select\n  RDB$RELATION_NAME as TABLE_NAME,\n  cast('%s' as varchar(31)) as TABLE_TYPE,\n  RDB$DESCRIPTION as REMARKS,\n  RDB$OWNER_NAME as OWNER_NAME,\n  RDB$RELATION_ID as JB_RELATION_ID\nfrom RDB$RELATIONS\nwhere %s", tableType, condition);
        }

        static {
            LinkedHashMap<String, String> queryPerType = new LinkedHashMap<String, String>(5);
            queryPerType.put("SYSTEM TABLE", TABLE_COLUMNS_SYSTEM_2_1);
            queryPerType.put("TABLE", TABLE_COLUMNS_NORMAL_2_1);
            queryPerType.put("VIEW", TABLE_COLUMNS_VIEW_2_1);
            QUERY_PER_TYPE = Collections.unmodifiableMap(queryPerType);
            ALL_TYPES_2_1 = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("SYSTEM TABLE", "TABLE", "VIEW")));
        }
    }
}

