/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.state;

import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.FilterOptions;
import schemacrawler.schemacrawler.GrepOptions;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.LoadOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.ConfigUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.string.StringFormat;

public class ShellState
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(ShellState.class.getName());
    private Config baseConfig;
    private Config commandOptions;
    private Config catalogLoaderOptions;
    private Catalog catalog;
    private DatabaseConnectionSource dataSource;
    private Throwable lastException;
    private SchemaCrawlerOptions schemaCrawlerOptions;
    private SchemaRetrievalOptions schemaRetrievalOptions;
    private boolean isDeferCatalogLoad;

    @Override
    public void close() {
        this.sweep();
    }

    public void disconnect() {
        if (this.dataSource == null) {
            return;
        }
        try {
            this.dataSource.close();
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Closing database connections", new Object[0]));
            this.dataSource = null;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot close database connections");
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public Config getConfig() {
        Config config = ConfigUtility.newConfig();
        config.merge(this.baseConfig);
        config.merge(this.commandOptions);
        config.merge(this.catalogLoaderOptions);
        return config;
    }

    public DatabaseConnectionSource getDataSource() {
        return this.dataSource;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    public SchemaRetrievalOptions getSchemaRetrievalOptions() {
        return this.schemaRetrievalOptions;
    }

    public boolean isConnected() {
        return this.dataSource != null;
    }

    public boolean isDeferCatalogLoad() {
        return this.isDeferCatalogLoad;
    }

    public boolean isLoaded() {
        return this.catalog != null;
    }

    public void setBaseConfig(Config baseConfig) {
        this.baseConfig = baseConfig != null ? baseConfig : ConfigUtility.newConfig();
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setCatalogLoaderOptions(Map<String, Object> catalogLoaderOptions) {
        this.catalogLoaderOptions = catalogLoaderOptions != null ? ConfigUtility.fromMap(catalogLoaderOptions) : null;
    }

    public void setCommandOptions(Map<String, Object> commandOptions) {
        this.commandOptions = commandOptions != null ? ConfigUtility.fromMap(commandOptions) : null;
    }

    public void setDataSource(DatabaseConnectionSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDeferCatalogLoad(boolean isDeferCatalogLoad) {
        this.isDeferCatalogLoad = isDeferCatalogLoad;
    }

    public void setLastException(Throwable lastException) {
        this.lastException = lastException;
    }

    public void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions;
    }

    public void setSchemaRetrievalOptions(SchemaRetrievalOptions schemaRetrievalOptions) {
        this.schemaRetrievalOptions = schemaRetrievalOptions;
    }

    public void sweep() {
        this.catalog = null;
        this.baseConfig = null;
        this.commandOptions = null;
        this.schemaCrawlerOptions = null;
        this.schemaRetrievalOptions = null;
        this.lastException = null;
        this.disconnect();
    }

    public void withFilterOptions(FilterOptions filterOptions) {
        this.schemaCrawlerOptions = this.schemaCrawlerOptions.withFilterOptions(filterOptions);
    }

    public void withGrepOptions(GrepOptions grepOptions) {
        this.schemaCrawlerOptions = this.schemaCrawlerOptions.withGrepOptions(grepOptions);
    }

    public void withLimitOptions(LimitOptions limitOptions) {
        this.schemaCrawlerOptions = this.schemaCrawlerOptions.withLimitOptions(limitOptions);
    }

    public void withLoadOptions(LoadOptions loadOptions) {
        this.schemaCrawlerOptions = this.schemaCrawlerOptions.withLoadOptions(loadOptions);
    }
}

