/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.LineAndColumn;
import org.jetbrains.kotlin.ir.SourceRangeInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrFileEntry;", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "()V", "getLineStartOffsetsForSerialization", "", "", "getLineNumber", "offset", "getColumnNumber", "getLineAndColumnNumbers", "Lorg/jetbrains/kotlin/ir/LineAndColumn;", "getSourceRangeInfo", "Lorg/jetbrains/kotlin/ir/SourceRangeInfo;", "beginOffset", "endOffset", "equals", "", "other", "", "hashCode", "ir.tree"})
public abstract class AbstractIrFileEntry
implements IrFileEntry {
    @NotNull
    public final List<Integer> getLineStartOffsetsForSerialization() {
        return ArraysKt.asList(this.getLineStartOffsets());
    }

    @Override
    public int getLineNumber(int offset) {
        if (offset < 0) {
            return -1;
        }
        int index = ArraysKt.binarySearch$default(this.getLineStartOffsets(), offset, 0, 0, 6, null);
        return this.getFirstRelevantLineIndex() + (index >= 0 ? index : -index - 2);
    }

    @Override
    public int getColumnNumber(int offset) {
        if (offset < 0) {
            return -1;
        }
        int lineNumber = this.getLineNumber(offset);
        int lineIndex = lineNumber - this.getFirstRelevantLineIndex();
        if (lineIndex < 0) {
            return -1;
        }
        return offset - this.getLineStartOffsets()[lineIndex];
    }

    @Override
    @NotNull
    public LineAndColumn getLineAndColumnNumbers(int offset) {
        if (offset < 0) {
            return new LineAndColumn(-1, -1);
        }
        int lineNumber = this.getLineNumber(offset);
        int lineIndex = lineNumber - this.getFirstRelevantLineIndex();
        if (lineIndex < 0) {
            return new LineAndColumn(lineIndex, -1);
        }
        int columnNumber = offset - this.getLineStartOffsets()[lineIndex];
        return new LineAndColumn(lineNumber, columnNumber);
    }

    @Override
    @NotNull
    public SourceRangeInfo getSourceRangeInfo(int beginOffset, int endOffset) {
        LineAndColumn lineAndColumn = this.getLineAndColumnNumbers(beginOffset);
        int startLineNumber = lineAndColumn.component1();
        int startColumnNumber = lineAndColumn.component2();
        LineAndColumn lineAndColumn2 = this.getLineAndColumnNumbers(endOffset);
        int endLineNumber = lineAndColumn2.component1();
        int endColumnNumber = lineAndColumn2.component2();
        return new SourceRangeInfo(this.getName(), beginOffset, startLineNumber, startColumnNumber, endOffset, endLineNumber, endColumnNumber);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof AbstractIrFileEntry && Intrinsics.areEqual(((AbstractIrFileEntry)other).getName(), this.getName()) && Arrays.equals(((AbstractIrFileEntry)other).getLineStartOffsets(), this.getLineStartOffsets());
    }

    public int hashCode() {
        return this.getName().hashCode() * 31 + Arrays.hashCode(this.getLineStartOffsets());
    }
}

