/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xml.util.documentation.XmlDocumentationProvider;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class MavenPomXmlDocumentationProvider
implements DocumentationProvider {
    private final DocumentationProvider myDelegate = new XmlDocumentationProvider(this){

        protected String generateDoc(String str, String name, String typeName, String version) {
            if (str != null) {
                str = StringUtil.unescapeXmlEntities((String)str);
            }
            return super.generateDoc(str, name, typeName, version);
        }
    };

    private static boolean isFromPomXml(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        return containingFile != null && containingFile.getName().equals("maven-4.0.0.xsd");
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (!MavenPomXmlDocumentationProvider.isFromPomXml(element)) {
            return null;
        }
        return this.myDelegate.getQuickNavigateInfo(element, originalElement);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if (!MavenPomXmlDocumentationProvider.isFromPomXml(element)) {
            return null;
        }
        return this.myDelegate.getUrlFor(element, originalElement);
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (!MavenPomXmlDocumentationProvider.isFromPomXml(element)) {
            return null;
        }
        return this.myDelegate.generateDoc(element, originalElement);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (!MavenPomXmlDocumentationProvider.isFromPomXml(element)) {
            return null;
        }
        return this.myDelegate.getDocumentationElementForLookupItem(psiManager, object, element);
    }
}

