/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.cache.Cache;
import org.apache.lucene.util.cache.SimpleLRUCache;

final class TermInfosReader {
    private Directory directory;
    private String segment;
    private FieldInfos fieldInfos;
    private CloseableThreadLocal threadResources = new CloseableThreadLocal();
    private SegmentTermEnum origEnum;
    private long size;
    private Term[] indexTerms = null;
    private TermInfo[] indexInfos;
    private long[] indexPointers;
    private SegmentTermEnum indexEnum;
    private int indexDivisor = 1;
    private int totalIndexInterval;
    private static final int DEFAULT_CACHE_SIZE = 1024;

    TermInfosReader(Directory dir, String seg, FieldInfos fis) throws CorruptIndexException, IOException {
        this(dir, seg, fis, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TermInfosReader(Directory dir, String seg, FieldInfos fis, int readBufferSize) throws CorruptIndexException, IOException {
        boolean success = false;
        try {
            this.directory = dir;
            this.segment = seg;
            this.fieldInfos = fis;
            this.origEnum = new SegmentTermEnum(this.directory.openInput(this.segment + "." + "tis", readBufferSize), this.fieldInfos, false);
            this.size = this.origEnum.size;
            this.totalIndexInterval = this.origEnum.indexInterval;
            this.indexEnum = new SegmentTermEnum(this.directory.openInput(this.segment + "." + "tii", readBufferSize), this.fieldInfos, true);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public int getSkipInterval() {
        return this.origEnum.skipInterval;
    }

    public int getMaxSkipLevels() {
        return this.origEnum.maxSkipLevels;
    }

    public void setIndexDivisor(int indexDivisor) throws IllegalStateException {
        if (indexDivisor < 1) {
            throw new IllegalArgumentException("indexDivisor must be > 0: got " + indexDivisor);
        }
        if (this.indexTerms != null) {
            throw new IllegalStateException("index terms are already loaded");
        }
        this.indexDivisor = indexDivisor;
        this.totalIndexInterval = this.origEnum.indexInterval * indexDivisor;
    }

    public int getIndexDivisor() {
        return this.indexDivisor;
    }

    final void close() throws IOException {
        if (this.origEnum != null) {
            this.origEnum.close();
        }
        if (this.indexEnum != null) {
            this.indexEnum.close();
        }
        this.threadResources.close();
    }

    final long size() {
        return this.size;
    }

    private ThreadResources getThreadResources() {
        ThreadResources resources = (ThreadResources)this.threadResources.get();
        if (resources == null) {
            resources = new ThreadResources();
            resources.termEnum = this.terms();
            resources.termInfoCache = new SimpleLRUCache(1024);
            this.threadResources.set(resources);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ensureIndexIsRead() throws IOException {
        if (this.indexTerms != null) {
            return;
        }
        try {
            int indexSize = 1 + ((int)this.indexEnum.size - 1) / this.indexDivisor;
            this.indexTerms = new Term[indexSize];
            this.indexInfos = new TermInfo[indexSize];
            this.indexPointers = new long[indexSize];
            int i = 0;
            while (this.indexEnum.next()) {
                this.indexTerms[i] = this.indexEnum.term();
                this.indexInfos[i] = this.indexEnum.termInfo();
                this.indexPointers[i] = this.indexEnum.indexPointer;
                for (int j = 1; j < this.indexDivisor && this.indexEnum.next(); ++j) {
                }
                ++i;
            }
        }
        finally {
            this.indexEnum.close();
            this.indexEnum = null;
        }
    }

    private final int getIndexOffset(Term term) {
        int lo = 0;
        int hi = this.indexTerms.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int delta = term.compareTo(this.indexTerms[mid]);
            if (delta < 0) {
                hi = mid - 1;
                continue;
            }
            if (delta > 0) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return hi;
    }

    private final void seekEnum(SegmentTermEnum enumerator, int indexOffset) throws IOException {
        enumerator.seek(this.indexPointers[indexOffset], indexOffset * this.totalIndexInterval - 1, this.indexTerms[indexOffset], this.indexInfos[indexOffset]);
    }

    TermInfo get(Term term) throws IOException {
        return this.get(term, true);
    }

    private TermInfo get(Term term, boolean useCache) throws IOException {
        int enumOffset;
        TermInfo ti;
        if (this.size == 0L) {
            return null;
        }
        this.ensureIndexIsRead();
        ThreadResources resources = this.getThreadResources();
        Cache cache = null;
        if (useCache && (ti = (TermInfo)(cache = resources.termInfoCache).get(term)) != null) {
            return ti;
        }
        SegmentTermEnum enumerator = resources.termEnum;
        if (enumerator.term() != null && (enumerator.prev() != null && term.compareTo(enumerator.prev()) > 0 || term.compareTo(enumerator.term()) >= 0) && (this.indexTerms.length == (enumOffset = (int)(enumerator.position / (long)this.totalIndexInterval) + 1) || term.compareTo(this.indexTerms[enumOffset]) < 0)) {
            int numScans = enumerator.scanTo(term);
            if (enumerator.term() != null && term.compareTo(enumerator.term()) == 0) {
                ti = enumerator.termInfo();
                if (cache != null && numScans > 1) {
                    cache.put(term, ti);
                }
            } else {
                ti = null;
            }
            return ti;
        }
        this.seekEnum(enumerator, this.getIndexOffset(term));
        enumerator.scanTo(term);
        if (enumerator.term() != null && term.compareTo(enumerator.term()) == 0) {
            ti = enumerator.termInfo();
            if (cache != null) {
                cache.put(term, ti);
            }
        } else {
            ti = null;
        }
        return ti;
    }

    final Term get(int position) throws IOException {
        if (this.size == 0L) {
            return null;
        }
        SegmentTermEnum enumerator = this.getThreadResources().termEnum;
        if (enumerator != null && enumerator.term() != null && (long)position >= enumerator.position && (long)position < enumerator.position + (long)this.totalIndexInterval) {
            return this.scanEnum(enumerator, position);
        }
        this.seekEnum(enumerator, position / this.totalIndexInterval);
        return this.scanEnum(enumerator, position);
    }

    private final Term scanEnum(SegmentTermEnum enumerator, int position) throws IOException {
        while (enumerator.position < (long)position) {
            if (enumerator.next()) continue;
            return null;
        }
        return enumerator.term();
    }

    final long getPosition(Term term) throws IOException {
        if (this.size == 0L) {
            return -1L;
        }
        this.ensureIndexIsRead();
        int indexOffset = this.getIndexOffset(term);
        SegmentTermEnum enumerator = this.getThreadResources().termEnum;
        this.seekEnum(enumerator, indexOffset);
        while (term.compareTo(enumerator.term()) > 0 && enumerator.next()) {
        }
        if (term.compareTo(enumerator.term()) == 0) {
            return enumerator.position;
        }
        return -1L;
    }

    public SegmentTermEnum terms() {
        return (SegmentTermEnum)this.origEnum.clone();
    }

    public SegmentTermEnum terms(Term term) throws IOException {
        this.get(term, false);
        return (SegmentTermEnum)this.getThreadResources().termEnum.clone();
    }

    private static final class ThreadResources {
        SegmentTermEnum termEnum;
        Cache termInfoCache;

        private ThreadResources() {
        }
    }
}

