/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive;

import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseEntryWithDetails;
import git4idea.rebase.GitSquashedCommitsMessage;
import git4idea.rebase.interactive.GitRebaseTodoModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0005H\u0000\u001a*\u0010\u0006\u001a\u0004\u0018\u00010\u0007\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001a$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\"\b\b\u0000\u0010\u0002*\u00020\u0003*\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0001H\u0000\u00a8\u0006\f"}, d2={"convertToModel", "Lgit4idea/rebase/interactive/GitRebaseTodoModel;", "T", "Lgit4idea/rebase/GitRebaseEntry;", "entries", "", "amendCommitMessage", "", "root", "Lgit4idea/rebase/interactive/GitRebaseTodoModel$Element$UniteRoot;", "newEntry", "convertToEntries", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRebaseTodoModelConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRebaseTodoModelConverter.kt\ngit4idea/rebase/interactive/GitRebaseTodoModelConverterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1869#2,2:98\n774#2:100\n865#2,2:101\n1869#2,2:103\n1563#2:105\n1634#2,3:106\n*S KotlinDebug\n*F\n+ 1 GitRebaseTodoModelConverter.kt\ngit4idea/rebase/interactive/GitRebaseTodoModelConverterKt\n*L\n11#1:98,2\n60#1:100\n60#1:101,2\n60#1:103,2\n93#1:105\n93#1:106,3\n*E\n"})
public final class GitRebaseTodoModelConverterKt {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final <T extends GitRebaseEntry> GitRebaseTodoModel<T> convertToModel(@NotNull List<? extends T> entries) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitRebaseEntry entry = (GitRebaseEntry)element$iv;
            boolean bl = false;
            int index = result2.size();
            GitRebaseEntry.Action action = entry.getAction();
            if (Intrinsics.areEqual((Object)action, (Object)GitRebaseEntry.Action.PICK.INSTANCE) || Intrinsics.areEqual((Object)action, (Object)GitRebaseEntry.Action.REWORD.INSTANCE)) {
                GitRebaseTodoModel.Type.NonUnite.KeepCommit.Pick pick = GitRebaseTodoModel.Type.NonUnite.KeepCommit.Pick.INSTANCE;
                result2.add(new GitRebaseTodoModel.Element.Simple<GitRebaseEntry>(index, pick, entry));
                continue;
            }
            if (Intrinsics.areEqual((Object)action, (Object)GitRebaseEntry.Action.EDIT.INSTANCE)) {
                GitRebaseTodoModel.Type.NonUnite.KeepCommit.Edit edit = GitRebaseTodoModel.Type.NonUnite.KeepCommit.Edit.INSTANCE;
                result2.add(new GitRebaseTodoModel.Element.Simple<GitRebaseEntry>(index, edit, entry));
                continue;
            }
            if (Intrinsics.areEqual((Object)action, (Object)GitRebaseEntry.Action.DROP.INSTANCE)) continue;
            if (action instanceof GitRebaseEntry.Action.FIXUP || Intrinsics.areEqual((Object)action, (Object)GitRebaseEntry.Action.SQUASH.INSTANCE)) {
                GitRebaseTodoModel.Element.UniteRoot<GitRebaseEntry> uniteRoot;
                GitRebaseTodoModel.Element element;
                if ((GitRebaseTodoModel.Element)CollectionsKt.lastOrNull((List)result2) == null) {
                    throw new IllegalArgumentException("Couldn't unite with non-existed commit");
                }
                GitRebaseTodoModel.Element element2 = element;
                if (element2 instanceof GitRebaseTodoModel.Element.UniteChild) {
                    uniteRoot = ((GitRebaseTodoModel.Element.UniteChild)element).getRoot();
                } else if (element2 instanceof GitRebaseTodoModel.Element.UniteRoot) {
                    uniteRoot = (GitRebaseTodoModel.Element.UniteRoot<GitRebaseEntry>)element;
                } else {
                    if (!(element2 instanceof GitRebaseTodoModel.Element.Simple)) throw new NoWhenBranchMatchedException();
                    GitRebaseTodoModel.Type.NonUnite rootType = ((GitRebaseTodoModel.Element.Simple)element).getType();
                    if (rootType instanceof GitRebaseTodoModel.Type.NonUnite.KeepCommit) {
                        GitRebaseTodoModel.Element.UniteRoot<GitRebaseEntry> newRoot = new GitRebaseTodoModel.Element.UniteRoot<GitRebaseEntry>(((GitRebaseTodoModel.Element.Simple)element).getIndex(), (GitRebaseTodoModel.Type.NonUnite.KeepCommit)rootType, (GitRebaseEntry)((GitRebaseTodoModel.Element.Simple)element).getEntry());
                        result2.set(newRoot.getIndex(), newRoot);
                        uniteRoot = newRoot;
                    } else {
                        if (!(rootType instanceof GitRebaseTodoModel.Type.NonUnite.Drop) && !(rootType instanceof GitRebaseTodoModel.Type.NonUnite.UpdateRef)) throw new NoWhenBranchMatchedException();
                        throw new IllegalStateException();
                    }
                }
                GitRebaseTodoModel.Element.UniteRoot<GitRebaseEntry> root = uniteRoot;
                GitRebaseTodoModel.Element.UniteChild<GitRebaseEntry> element3 = new GitRebaseTodoModel.Element.UniteChild<GitRebaseEntry>(index, entry, root);
                root.addChild(element3);
                result2.add(element3);
                String newMessage = GitRebaseTodoModelConverterKt.amendCommitMessage(root, entry);
                if (newMessage == null) continue;
                root.setType(new GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword(newMessage));
                continue;
            }
            if (Intrinsics.areEqual((Object)action, (Object)GitRebaseEntry.Action.UPDATE_REF.INSTANCE)) {
                GitRebaseTodoModel.Type.NonUnite.UpdateRef updateRef = GitRebaseTodoModel.Type.NonUnite.UpdateRef.INSTANCE;
                GitRebaseTodoModel.Element.Simple<GitRebaseEntry> element = new GitRebaseTodoModel.Element.Simple<GitRebaseEntry>(index, updateRef, entry);
                result2.add(element);
                continue;
            }
            if (!(action instanceof GitRebaseEntry.Action.Other)) throw new NoWhenBranchMatchedException();
            throw new IllegalArgumentException("Couldn't convert unknown action to the model");
        }
        Iterable $this$filter$iv = entries;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitRebaseEntry it = (GitRebaseEntry)element$iv$iv;
            boolean bl = false;
            if (!(it.getAction() instanceof GitRebaseEntry.Action.DROP)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitRebaseEntry entry = (GitRebaseEntry)element$iv;
            boolean bl = false;
            int index = result2.size();
            result2.add(new GitRebaseTodoModel.Element.Simple<GitRebaseEntry>(index, GitRebaseTodoModel.Type.NonUnite.Drop.INSTANCE, entry));
        }
        return new GitRebaseTodoModel(result2);
    }

    private static final <T extends GitRebaseEntry> String amendCommitMessage(GitRebaseTodoModel.Element.UniteRoot<T> root, GitRebaseEntry newEntry) {
        String string;
        if (!(newEntry instanceof GitRebaseEntryWithDetails) || !(root.getEntry() instanceof GitRebaseEntryWithDetails)) {
            return null;
        }
        GitRebaseTodoModel.Type.NonUnite.KeepCommit keepCommit = root.getType();
        Object object = keepCommit instanceof GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword ? (GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword)keepCommit : null;
        if (object == null || (object = ((GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword)object).getNewMessage()) == null) {
            String string2 = ((GitRebaseEntryWithDetails)root.getEntry()).getCommitDetails().getFullMessage();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFullMessage(...)");
        }
        Object oldMessage = object;
        String string3 = ((GitRebaseEntryWithDetails)newEntry).getCommitDetails().getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFullMessage(...)");
        String entryCommitMessage = GitSquashedCommitsMessage.INSTANCE.trimAutosquashSubject(string3);
        if (StringsKt.isBlank((CharSequence)entryCommitMessage)) {
            return null;
        }
        if (newEntry.getAction() instanceof GitRebaseEntry.Action.SQUASH) {
            string = GitSquashedCommitsMessage.INSTANCE.squash((String)oldMessage, entryCommitMessage);
        } else if (newEntry.getAction() instanceof GitRebaseEntry.Action.FIXUP && ((GitRebaseEntry.Action.FIXUP)newEntry.getAction()).getOverrideMessage()) {
            string = entryCommitMessage;
        } else {
            return null;
        }
        String newMessage = string;
        if (Intrinsics.areEqual((Object)oldMessage, (Object)newMessage)) {
            return null;
        }
        return newMessage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends GitRebaseEntry> List<GitRebaseEntry> convertToEntries(@NotNull GitRebaseTodoModel<? extends T> $this$convertToEntries) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$convertToEntries, (String)"<this>");
        Iterable $this$map$iv = $this$convertToEntries.getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void element;
            GitRebaseTodoModel.Element element2 = (GitRebaseTodoModel.Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object entry = element.getEntry();
            collection.add(new GitRebaseEntry(element.getType().getCommand(), ((GitRebaseEntry)entry).getCommit(), ((GitRebaseEntry)entry).getSubject()));
        }
        return (List)destination$iv$iv;
    }
}

