/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.TerminalFocusModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputController;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "focusModel", "Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;)V", "controller", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;", "getController", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "preferredFocusableComponent", "getPreferredFocusableComponent", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "installSearchComponent", "", "searchComponent", "Lcom/intellij/find/SearchReplaceComponent;", "removeSearchComponent", "createEditor", "dispose", "TerminalOutputPanel", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalOutputView
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalOutputController controller;
    @NotNull
    private final JComponent component;
    @NotNull
    private final EditorImpl editor;

    public TerminalOutputView(@NotNull Project project, @NotNull BlockTerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalFocusModel focusModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        this.project = project;
        this.editor = this.createEditor(settings);
        this.controller = new TerminalOutputController(this.project, (EditorEx)this.editor, session2, settings, focusModel);
        this.component = (JComponent)((Object)new TerminalOutputPanel());
    }

    @NotNull
    public final TerminalOutputController getController() {
        return this.controller;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        return (JComponent)editorComponentImpl;
    }

    @RequiresEdt
    public final void installSearchComponent(@NotNull SearchReplaceComponent searchComponent) {
        Intrinsics.checkNotNullParameter((Object)searchComponent, (String)"searchComponent");
        Component component2 = (Component)searchComponent;
        Integer n = JLayeredPane.POPUP_LAYER;
        Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
        this.component.add(component2, n);
        this.component.revalidate();
        this.component.repaint();
    }

    @RequiresEdt
    public final void removeSearchComponent(@NotNull SearchReplaceComponent searchComponent) {
        Intrinsics.checkNotNullParameter((Object)searchComponent, (String)"searchComponent");
        this.component.remove((Component)searchComponent);
        this.component.revalidate();
        this.component.repaint();
    }

    private final EditorImpl createEditor(JBTerminalSystemSettingsProviderBase settings) {
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        EditorImpl editor = TerminalUiUtils.INSTANCE.createOutputEditor((Document)document, this.project, settings, true);
        editor.getSettings().setUseSoftWraps(true);
        JScrollBar jScrollBar = editor.getScrollPane().getVerticalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"getVerticalScrollBar(...)");
        TerminalUiUtilsKt.stickScrollBarToBottom(jScrollBar);
        return editor;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.editor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputView$TerminalOutputPanel;", "Lcom/intellij/ui/components/JBLayeredPane;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputView;)V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getPreferredSize", "Ljava/awt/Dimension;", "doLayout", "layoutEditor", "component", "Ljava/awt/Component;", "layoutSearchComponent", "intellij.terminal"})
    private final class TerminalOutputPanel
    extends JBLayeredPane
    implements UiDataProvider {
        public TerminalOutputPanel() {
            this.setOpaque(false);
            Component component2 = TerminalOutputView.this.editor.getComponent();
            Integer n = JLayeredPane.DEFAULT_LAYER;
            Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
            this.add(component2, n);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey dataKey = CommonDataKeys.EDITOR;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
            sink.set(dataKey, (Object)TerminalOutputView.this.editor);
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension;
            if (TerminalOutputView.this.editor.getDocument().getTextLength() == 0) {
                dimension = new Dimension();
            } else {
                Dimension dimension2 = TerminalOutputView.this.editor.getPreferredSize();
                dimension = dimension2;
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
            }
            return dimension;
        }

        public void doLayout() {
            SearchReplaceComponent searchReplaceComponent = EditorSearchSession.getSearchReplaceComponent((Editor)((Editor)TerminalOutputView.this.editor));
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            for (Component component2 : componentArray) {
                Component component3 = component2;
                if (Intrinsics.areEqual((Object)component3, (Object)TerminalOutputView.this.editor.getComponent())) {
                    Intrinsics.checkNotNull((Object)component2);
                    this.layoutEditor(component2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)component3, (Object)searchReplaceComponent)) continue;
                Intrinsics.checkNotNull((Object)component2);
                this.layoutSearchComponent(component2);
            }
        }

        private final void layoutEditor(Component component2) {
            int prefHeight = component2.getPreferredSize().height;
            int compHeight = Math.min(this.getHeight(), prefHeight);
            component2.setBounds(0, this.getHeight() - compHeight, this.getWidth(), compHeight);
        }

        private final void layoutSearchComponent(Component component2) {
            Dimension prefSize = component2.getPreferredSize();
            Dimension maxSize = component2.getMaximumSize();
            int compWidth = Math.min(this.getWidth(), Math.min(prefSize.width, maxSize.width));
            int compHeight = Math.min(prefSize.height, maxSize.height);
            component2.setBounds(this.getWidth() - compWidth, 0, compWidth, compHeight);
        }
    }
}

