/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.util.HgUtil;

public class HgFile {
    private final VirtualFile vcsRoot;
    private final File file;
    private String relativePath;

    public HgFile(@NotNull VirtualFile vcsRoot, File file) {
        if (vcsRoot == null) {
            HgFile.$$$reportNull$$$0(0);
        }
        this.vcsRoot = vcsRoot;
        this.file = file;
    }

    public HgFile(@NotNull VirtualFile vcsRoot, FilePath filePath) {
        if (vcsRoot == null) {
            HgFile.$$$reportNull$$$0(1);
        }
        this(vcsRoot, filePath.getIOFile());
    }

    public HgFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            HgFile.$$$reportNull$$$0(2);
        }
        if (file == null) {
            HgFile.$$$reportNull$$$0(3);
        }
        this(HgUtil.getHgRootOrNull(project, file), VcsUtil.getFilePath((String)file.getPath()));
    }

    @NotNull
    public VirtualFile getRepo() {
        VirtualFile virtualFile = this.vcsRoot;
        if (virtualFile == null) {
            HgFile.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public File getFile() {
        return this.file;
    }

    @NlsSafe
    @Nullable
    public String getRelativePath() {
        if (this.relativePath == null) {
            this.relativePath = FileUtil.getRelativePath((File)VfsUtilCore.virtualToIoFile((VirtualFile)this.vcsRoot), (File)this.file);
        }
        return this.relativePath;
    }

    @NotNull
    public FilePath toFilePath() {
        FilePath filePath = VcsUtil.getFilePath((File)this.file);
        if (filePath == null) {
            HgFile.$$$reportNull$$$0(5);
        }
        return filePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgFile that = (HgFile)o;
        if (!this.vcsRoot.equals(that.vcsRoot)) {
            return false;
        }
        return !(this.file != null ? !FileUtil.filesEqual((File)this.file, (File)that.file) : that.file != null);
    }

    public int hashCode() {
        return Objects.hash(this.vcsRoot, this.file);
    }

    @NonNls
    public String toString() {
        return MoreObjects.toStringHelper(HgFile.class).add("repo", (Object)this.vcsRoot).add("file", (Object)this.file).add("relativePath", (Object)this.getRelativePath()).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

