/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.index.DomElementClassIndex;
import com.intellij.util.xml.stubs.index.DomNamespaceKeyIndex;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ElementStubSerializer
implements ObjectStubSerializer<ElementStub, ElementStub> {
    public void serialize(@NotNull ElementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            ElementStubSerializer.$$$reportNull$$$0(0);
        }
        if (dataStream == null) {
            ElementStubSerializer.$$$reportNull$$$0(1);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getNamespaceKey());
        dataStream.writeVarInt(stub.getIndex());
        dataStream.writeBoolean(stub.isCustom());
        dataStream.writeName(stub.getElementClass());
        dataStream.writeUTFFast(stub.getValue());
    }

    @NotNull
    public ElementStub deserialize(@NotNull StubInputStream dataStream, ElementStub parentStub) throws IOException {
        if (dataStream == null) {
            ElementStubSerializer.$$$reportNull$$$0(2);
        }
        return new ElementStub(parentStub, Objects.requireNonNull(dataStream.readNameString()), dataStream.readNameString(), dataStream.readVarInt(), dataStream.readBoolean(), dataStream.readNameString(), dataStream.readUTFFast());
    }

    public void indexStub(@NotNull ElementStub stub, @NotNull IndexSink sink) {
        String elementClass;
        String namespaceKey;
        if (stub == null) {
            ElementStubSerializer.$$$reportNull$$$0(3);
        }
        if (sink == null) {
            ElementStubSerializer.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(namespaceKey = stub.getNamespaceKey()))) {
            sink.occurrence(DomNamespaceKeyIndex.KEY, (Object)namespaceKey);
        }
        if ((elementClass = stub.getElementClass()) != null) {
            sink.occurrence(DomElementClassIndex.KEY, (Object)elementClass);
        }
    }

    @NotNull
    public String getExternalId() {
        return "xml.ElementStubSerializer";
    }

    public String toString() {
        return "Element";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/stubs/ElementStubSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

