/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver;

import com.intellij.mcpserver.ClientInfo;
import com.intellij.mcpserver.McpCallAdditionalDataElement;
import com.intellij.mcpserver.McpCallInfo;
import com.intellij.mcpserver.McpExpectedError;
import com.intellij.mcpserver.McpToolDescriptor;
import com.intellij.mcpserver.OpenProjects;
import com.intellij.mcpserver.ProjectInfo;
import com.intellij.mcpserver.impl.util.Schema_utilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u0010*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0019"}, d2={"mcpCallInfoOrNull", "Lcom/intellij/mcpserver/McpCallInfo;", "Lkotlin/coroutines/CoroutineContext;", "getMcpCallInfoOrNull", "(Lkotlin/coroutines/CoroutineContext;)Lcom/intellij/mcpserver/McpCallInfo;", "mcpCallInfo", "getMcpCallInfo", "clientInfo", "Lcom/intellij/mcpserver/ClientInfo;", "getClientInfo", "(Lkotlin/coroutines/CoroutineContext;)Lcom/intellij/mcpserver/ClientInfo;", "currentToolDescriptor", "Lcom/intellij/mcpserver/McpToolDescriptor;", "getCurrentToolDescriptor", "(Lkotlin/coroutines/CoroutineContext;)Lcom/intellij/mcpserver/McpToolDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "(Lkotlin/coroutines/CoroutineContext;)Lcom/intellij/openapi/project/Project;", "projectOrNull", "getProjectOrNull", "noSuitableProjectError", "Lcom/intellij/mcpserver/McpExpectedError;", "messagePrefix", "", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nMcpCallInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpCallInfo.kt\ncom/intellij/mcpserver/McpCallInfoKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,92:1\n11879#2,9:93\n13805#2:102\n13806#2:105\n11888#2:106\n1#3:103\n1#3:104\n205#4:107\n324#5:108\n*S KotlinDebug\n*F\n+ 1 McpCallInfo.kt\ncom/intellij/mcpserver/McpCallInfoKt\n*L\n79#1:93,9\n79#1:102\n79#1:105\n79#1:106\n79#1:104\n85#1:107\n86#1:108\n*E\n"})
public final class McpCallInfoKt {
    @Nullable
    public static final McpCallInfo getMcpCallInfoOrNull(@NotNull CoroutineContext $this$mcpCallInfoOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$mcpCallInfoOrNull, (String)"<this>");
        McpCallAdditionalDataElement mcpCallAdditionalDataElement = (McpCallAdditionalDataElement)$this$mcpCallInfoOrNull.get((CoroutineContext.Key)McpCallAdditionalDataElement.Key);
        return mcpCallAdditionalDataElement != null ? mcpCallAdditionalDataElement.getAdditionalData() : null;
    }

    @NotNull
    public static final McpCallInfo getMcpCallInfo(@NotNull CoroutineContext $this$mcpCallInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$mcpCallInfo, (String)"<this>");
        McpCallInfo mcpCallInfo = McpCallInfoKt.getMcpCallInfoOrNull($this$mcpCallInfo);
        if (mcpCallInfo == null) {
            throw new IllegalStateException("mcpCallAdditionalData called outside of a MCP call".toString());
        }
        return mcpCallInfo;
    }

    @NotNull
    public static final ClientInfo getClientInfo(@NotNull CoroutineContext $this$clientInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$clientInfo, (String)"<this>");
        return McpCallInfoKt.getMcpCallInfo($this$clientInfo).getClientInfo();
    }

    @NotNull
    public static final McpToolDescriptor getCurrentToolDescriptor(@NotNull CoroutineContext $this$currentToolDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$currentToolDescriptor, (String)"<this>");
        return McpCallInfoKt.getMcpCallInfo($this$currentToolDescriptor).getMcpToolDescriptor();
    }

    @NotNull
    public static final Project getProject(@NotNull CoroutineContext $this$project) {
        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"<this>");
        Project project = McpCallInfoKt.getProjectOrNull($this$project);
        if (project == null) {
            throw new McpExpectedError("No project opened", null, 2, null);
        }
        return project;
    }

    @Nullable
    public static final Project getProjectOrNull(@NotNull CoroutineContext $this$projectOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$projectOrNull, (String)"<this>");
        Project projectFromContext = McpCallInfoKt.getMcpCallInfo($this$projectOrNull).getProject();
        if (projectFromContext != null) {
            return projectFromContext;
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project[] openProjects = projectArray;
        switch (openProjects.length) {
            case 0: {
                return null;
            }
            case 1: {
                return openProjects[0];
            }
        }
        throw McpCallInfoKt.noSuitableProjectError("No exact project is specified while multiple projects are opened.");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final McpExpectedError noSuitableProjectError(@NotNull String messagePrefix) {
        void $this$encodeToJsonElement$iv;
        Json this_$iv;
        void $this$mapNotNullTo$iv$iv;
        Json openProjects;
        Intrinsics.checkNotNullParameter((Object)messagePrefix, (String)"messagePrefix");
        Json json = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"getOpenProjects(...)");
        Json $this$mapNotNull$iv = openProjects = json;
        boolean $i$f$mapNotNull = false;
        Json json2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            ProjectInfo projectInfo;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void project = element$iv$iv;
            boolean bl2 = false;
            if (project.getBasePath() != null) {
                boolean bl3 = false;
                projectInfo = new ProjectInfo(String.valueOf(project.getBasePath()));
            } else {
                projectInfo = null;
            }
            if (projectInfo == null) continue;
            ProjectInfo it$iv$iv = projectInfo;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        OpenProjects projects = new OpenProjects(list);
        String string = Schema_utilKt.getProjectPathParameterName();
        String string2 = Schema_utilKt.getProjectPathParameterName();
        $this$mapNotNull$iv = (Json)Json.Default;
        OpenProjects value$iv = projects;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String string3 = StringsKt.trimMargin$default((String)(messagePrefix + "\n              | You may specify the project path via `" + string + "` parameter when calling a tool. \n              | If you're aware of the current working directory you may pass it as `" + string2 + "`. \n              | In the case when it's unobvious which project to use you have to ASK the USER about a project providing him a numbered list of the projects.\n              | Currently open projects: " + this_$iv.encodeToString((SerializationStrategy)OpenProjects.Companion.serializer(), (Object)value$iv)), null, (int)1, null);
        this_$iv = (Json)Json.Default;
        value$iv = projects;
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        return new McpExpectedError(string3, JsonElementKt.getJsonObject((JsonElement)$this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)OpenProjects.Companion.serializer(), (Object)value$iv)));
    }
}

