/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.sisu.plexus.PlexusAnnotatedMetadata;
import org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.eclipse.sisu.plexus.PlexusBeanModule;
import org.eclipse.sisu.plexus.PlexusBeanSource;
import org.eclipse.sisu.plexus.PlexusTypeBinder;
import org.eclipse.sisu.plexus.PlexusTypeVisitor;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.SpaceVisitor;

public final class PlexusAnnotatedBeanModule
implements PlexusBeanModule {
    private static final SpaceModule.Strategy PLEXUS_STRATEGY = new SpaceModule.Strategy(){

        @Override
        public SpaceVisitor visitor(Binder binder) {
            return new PlexusTypeVisitor(new PlexusTypeBinder(binder));
        }
    };
    private Module spaceModule;
    private final PlexusBeanSource beanSource;

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables) {
        this(space, variables, BeanScanning.ON);
    }

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables, BeanScanning scanning) {
        this.spaceModule = space != null && scanning != BeanScanning.OFF ? new SpaceModule(space, scanning).with(PLEXUS_STRATEGY) : null;
        this.beanSource = new PlexusAnnotatedBeanSource(variables);
    }

    public PlexusBeanModule with(SpaceModule.Strategy _strategy) {
        if (this.spaceModule instanceof SpaceModule) {
            this.spaceModule = ((SpaceModule)this.spaceModule).with(_strategy);
        }
        return this;
    }

    @Override
    public PlexusBeanSource configure(Binder binder) {
        if (this.spaceModule != null) {
            this.spaceModule.configure(binder);
        }
        return this.beanSource;
    }

    private static final class PlexusAnnotatedBeanSource
    implements PlexusBeanSource {
        private final PlexusBeanMetadata metadata;

        PlexusAnnotatedBeanSource(Map<?, ?> variables) {
            this.metadata = new PlexusAnnotatedMetadata(variables);
        }

        @Override
        public PlexusBeanMetadata getBeanMetadata(Class<?> implementation) {
            return implementation.isAnnotationPresent(Component.class) ? this.metadata : null;
        }
    }
}

