/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ContextClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.SuperCallReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisClassReceiver;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "frontend"})
public interface ExpressionReceiver
extends ReceiverValue {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver$Companion.$$INSTANCE;

    @NotNull
    public KtExpression getExpression();

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isContextClassReceiverReference", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "ExpressionReceiverImpl", "ThisExpressionClassReceiver", "SuperExpressionReceiver", "frontend"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final ExpressionReceiver create(@NotNull KtExpression expression2, @NotNull KotlinType type, @NotNull BindingContext bindingContext) {
            KotlinType kotlinType;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            KtReferenceExpression referenceExpression = null;
            if (expression2 instanceof KtThisExpression) {
                referenceExpression = ((KtThisExpression)expression2).getInstanceReference();
            } else if (expression2 instanceof KtConstructorDelegationReferenceExpression) {
                referenceExpression = (KtReferenceExpression)expression2;
            }
            if (referenceExpression != null) {
                DeclarationDescriptor descriptor = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, referenceExpression);
                if (descriptor instanceof ClassDescriptor && !this.isContextClassReceiverReference(referenceExpression, bindingContext)) {
                    ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor).getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getOriginal(...)");
                    return new ThisExpressionClassReceiver(classDescriptor, expression2, type, null);
                }
            } else if (expression2 instanceof KtSuperExpression && (kotlinType = (KotlinType)bindingContext.get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2)) != null) {
                KotlinType thisType = kotlinType;
                boolean bl = false;
                return new SuperExpressionReceiver(thisType, expression2, type, null);
            }
            return new ExpressionReceiverImpl(expression2, type, null);
        }

        private final boolean isContextClassReceiverReference(KtReferenceExpression $this$isContextClassReceiverReference, BindingContext bindingContext) {
            ReceiverParameterDescriptor receiverParameterDescriptor = (ReceiverParameterDescriptor)bindingContext.get(BindingContext.THIS_REFERENCE_TARGET, $this$isContextClassReceiverReference);
            return (receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null) instanceof ContextClassReceiver;
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\n\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/AbstractReceiverValue;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "original", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "replaceType", "newType", "toString", "", "frontend"})
        private static class ExpressionReceiverImpl
        extends AbstractReceiverValue
        implements ExpressionReceiver {
            @NotNull
            private final KtExpression expression;

            public ExpressionReceiverImpl(@NotNull KtExpression expression2, @NotNull KotlinType type, @Nullable ReceiverValue original) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                super(type, original);
                this.expression = expression2;
            }

            @Override
            @NotNull
            public KtExpression getExpression() {
                return this.expression;
            }

            @Override
            @NotNull
            public ExpressionReceiverImpl replaceType(@NotNull KotlinType newType) {
                Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
                return new ExpressionReceiverImpl(this.getExpression(), newType, this.getOriginal());
            }

            @NotNull
            public String toString() {
                return this.getType() + " {" + this.getExpression() + ": " + this.getExpression().getText() + '}';
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$SuperExpressionReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/SuperCallReceiverValue;", "thisType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "original", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "<init>", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "getThisType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "replaceType", "newType", "frontend"})
        private static final class SuperExpressionReceiver
        extends ExpressionReceiverImpl
        implements SuperCallReceiverValue {
            @NotNull
            private final KotlinType thisType;

            public SuperExpressionReceiver(@NotNull KotlinType thisType, @NotNull KtExpression expression2, @NotNull KotlinType type, @Nullable ReceiverValue original) {
                Intrinsics.checkNotNullParameter((Object)thisType, (String)"thisType");
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                super(expression2, type, original);
                this.thisType = thisType;
            }

            @Override
            @NotNull
            public KotlinType getThisType() {
                return this.thisType;
            }

            @Override
            @NotNull
            public SuperExpressionReceiver replaceType(@NotNull KotlinType newType) {
                Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
                return new SuperExpressionReceiver(this.getThisType(), this.getExpression(), newType, this.getOriginal());
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ThisExpressionClassReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ThisClassReceiver;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "original", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "replaceType", "newType", "frontend"})
        private static final class ThisExpressionClassReceiver
        extends ExpressionReceiverImpl
        implements ThisClassReceiver {
            @NotNull
            private final ClassDescriptor classDescriptor;

            public ThisExpressionClassReceiver(@NotNull ClassDescriptor classDescriptor, @NotNull KtExpression expression2, @NotNull KotlinType type, @Nullable ReceiverValue original) {
                Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                super(expression2, type, original);
                this.classDescriptor = classDescriptor;
            }

            @Override
            @NotNull
            public ClassDescriptor getClassDescriptor() {
                return this.classDescriptor;
            }

            @Override
            @NotNull
            public ThisExpressionClassReceiver replaceType(@NotNull KotlinType newType) {
                Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
                return new ThisExpressionClassReceiver(this.getClassDescriptor(), this.getExpression(), newType, this.getOriginal());
            }
        }
    }
}

