/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;

@ApiStatus.Internal
public class YamlNumberType
extends YamlScalarType {
    private static final YamlNumberType SHARED_INSTANCE_NO_QUOTED_VALUES_ALLOWED = new YamlNumberType(false);
    private static final YamlNumberType SHARED_INSTANCE_QUOTED_VALUES_ALLOWED = new YamlNumberType(true);
    private final boolean myQuotedValuesAllowed;

    public static YamlNumberType getInstance(boolean quotedValuesAllowed) {
        return quotedValuesAllowed ? SHARED_INSTANCE_QUOTED_VALUES_ALLOWED : SHARED_INSTANCE_NO_QUOTED_VALUES_ALLOWED;
    }

    public YamlNumberType(boolean quotedValuesAllowed) {
        super("yaml:number", "number");
        this.myQuotedValuesAllowed = quotedValuesAllowed;
    }

    @Override
    public boolean isSupportedTag(@NotNull String tag) {
        if (tag == null) {
            YamlNumberType.$$$reportNull$$$0(0);
        }
        return tag.contains("int") || tag.contains("float") || tag.contains("double") || tag.contains("number");
    }

    @Override
    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        if (scalarValue == null) {
            YamlNumberType.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            YamlNumberType.$$$reportNull$$$0(2);
        }
        try {
            if (!this.myQuotedValuesAllowed && scalarValue instanceof YAMLQuotedText) {
                throw new NumberFormatException("no quoted values allowed");
            }
            String textValue = scalarValue.getTextValue();
            if (textValue.startsWith(" ") || textValue.endsWith(" ")) {
                throw new NumberFormatException("contains spaces");
            }
            Float.parseFloat(textValue);
        }
        catch (NumberFormatException e) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message((String)"YamlNumberType.error.numeric.value", (Object[])new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scalarValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlNumberType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedTag";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateScalarValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

