/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadFileTask
extends PleaseWaitRunnable {
    private final String address;
    private final File file;
    private final boolean mkdir;
    private final boolean unpack;
    private boolean canceled;
    private HttpClient downloadConnection;

    public DownloadFileTask(Component parent, String address, File file, boolean mkdir, boolean unpack) {
        super(parent, I18n.tr("Downloading file", new Object[0]), false);
        this.address = address;
        this.file = file;
        this.mkdir = mkdir;
        this.unpack = unpack;
    }

    private synchronized void closeConnectionIfNeeded() {
        if (this.downloadConnection != null) {
            this.downloadConnection.disconnect();
        }
        this.downloadConnection = null;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
        this.closeConnectionIfNeeded();
    }

    @Override
    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws DownloadException {
        try {
            long size;
            File newDir;
            if (this.mkdir && !(newDir = this.file.getParentFile()).exists()) {
                Utils.mkDirs(newDir);
            }
            URL url = new URL(this.address);
            DownloadFileTask downloadFileTask = this;
            synchronized (downloadFileTask) {
                this.downloadConnection = HttpClient.create(url).useCache(false);
                this.downloadConnection.connect();
                size = this.downloadConnection.getResponse().getContentLength();
            }
            this.progressMonitor.setTicksCount(100);
            this.progressMonitor.subTask(I18n.tr("Downloading File {0}: {1} bytes...", this.file.getName(), size));
            try (InputStream in = this.downloadConnection.getResponse().getContent();
                 OutputStream out = Files.newOutputStream(this.file.toPath(), new OpenOption[0]);){
                byte[] buffer = new byte[32768];
                int count = 0;
                long p1 = 0L;
                int read = in.read(buffer);
                while (read != -1) {
                    out.write(buffer, 0, read);
                    count += read;
                    if (this.canceled) {
                        break;
                    }
                    long p2 = 100L * (long)count / size;
                    if (p2 != p1) {
                        this.progressMonitor.setTicks((int)p2);
                        p1 = p2;
                    }
                    read = in.read(buffer);
                }
            }
            if (!this.canceled) {
                Logging.info(I18n.tr("Download finished", new Object[0]));
                if (this.unpack) {
                    Logging.info(I18n.tr("Unpacking {0} into {1}", this.file.getAbsolutePath(), this.file.getParent()));
                    DownloadFileTask.unzipFileRecursively(this.file, this.file.getParent());
                    Utils.deleteFile(this.file);
                }
            }
        }
        catch (MalformedURLException e) {
            String msg = I18n.tr("Cannot download file ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", this.file.getName(), this.address);
            Logging.warn(msg);
            throw new DownloadException(msg, e);
        }
        catch (IOException | InvalidPathException e) {
            if (this.canceled) {
                return;
            }
            throw new DownloadException(e.getMessage(), e);
        }
        finally {
            this.closeConnectionIfNeeded();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException {
        if (this.canceled) {
            return;
        }
        try {
            this.download();
        }
        catch (DownloadException e) {
            Logging.error(e);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public static void unzipFileRecursively(File file, String dir) throws IOException {
        Path dirPath = Paths.get(dir, new String[0]);
        try (ZipFile zf = new ZipFile(file, StandardCharsets.UTF_8);){
            Enumeration<? extends ZipEntry> es = zf.entries();
            while (es.hasMoreElements()) {
                ZipEntry ze = es.nextElement();
                File newFile = new File(dir, ze.getName());
                if (!newFile.toPath().normalize().startsWith(dirPath)) {
                    throw new IOException("Bad zip entry - Invalid or malicious file, potential CWE-22 attack");
                }
                if (ze.isDirectory()) {
                    Utils.mkDirs(newFile);
                    continue;
                }
                InputStream is = zf.getInputStream(ze);
                try {
                    Files.copy(is, newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    private static class DownloadException
    extends Exception {
        DownloadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

