/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.executors.ExecutorsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.workflow.DefaultWorkflowProvider;
import org.keycloak.models.workflow.WorkflowExecutor;
import org.keycloak.models.workflow.WorkflowProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class DefaultWorkflowProviderFactory
implements WorkflowProviderFactory<DefaultWorkflowProvider>,
ProviderEventListener {
    static final String ID = "default";
    private static final long DEFAULT_EXECUTOR_TASK_TIMEOUT = 1000L;
    private WorkflowExecutor executor;
    private boolean blocking;
    private long taskTimeout;

    public String getId() {
        return ID;
    }

    public DefaultWorkflowProvider create(KeycloakSession session, ComponentModel model) {
        return new DefaultWorkflowProvider(session, this.executor);
    }

    public DefaultWorkflowProvider create(KeycloakSession session) {
        return new DefaultWorkflowProvider(session, this.executor);
    }

    public void init(Config.Scope config) {
        this.blocking = config.getBoolean("executorBlocking", Boolean.valueOf(false));
        this.taskTimeout = config.getLong("executorTaskTimeout", Long.valueOf(1000L));
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.executor = new WorkflowExecutor(this.getTaskExecutor(factory), this.blocking, this.taskTimeout);
        factory.register((ProviderEventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ProviderEvent event) {
        if (event instanceof PostMigrationEvent) {
            PostMigrationEvent ev = (PostMigrationEvent)event;
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)ev.getFactory(), session -> session.realms().getRealmsStream().forEach(realm -> {
                session.getContext().setRealm(realm);
                DefaultWorkflowProvider provider = this.create(session);
                try {
                    provider.getWorkflows().forEach(provider::rescheduleWorkflow);
                }
                finally {
                    session.getContext().setRealm(null);
                    provider.close();
                }
            }));
        } else if (event instanceof RealmModel.RealmRemovedEvent) {
            RealmModel.RealmRemovedEvent ev = (RealmModel.RealmRemovedEvent)event;
            KeycloakSession session2 = ev.getKeycloakSession();
            try (DefaultWorkflowProvider provider = this.create(session2);){
                provider.getWorkflows().forEach(provider::cancelScheduledWorkflow);
            }
        }
    }

    public void close() {
    }

    public String getHelpText() {
        return null;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of();
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("executor-task-timeout").type("long").helpText("The time in milliseconds before a workflow task is marked as timed out .").defaultValue((Object)1000L).add().build();
    }

    private ExecutorService getTaskExecutor(KeycloakSessionFactory factory) {
        return ((ExecutorsProvider)factory.getProviderFactory(ExecutorsProvider.class).create(null)).getExecutor("workflow-event-executor");
    }
}

