/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@ProtoTypeId(value=65656)
public class ReplaceFunction<K, T extends SessionEntity>
implements BiFunction<K, SessionEntityWrapper<T>, SessionEntityWrapper<T>> {
    private final UUID expectedVersion;
    private final SessionEntityWrapper<T> newValue;

    @ProtoFactory
    public ReplaceFunction(UUID expectedVersion, SessionEntityWrapper<T> newValue) {
        this.expectedVersion = Objects.requireNonNull(expectedVersion);
        this.newValue = Objects.requireNonNull(newValue);
    }

    @Override
    public SessionEntityWrapper<T> apply(K key, SessionEntityWrapper<T> currentValue) {
        assert (currentValue != null);
        return this.expectedVersion.equals(currentValue.getVersion()) ? this.newValue : currentValue;
    }

    @ProtoField(value=1)
    UUID getExpectedVersion() {
        return this.expectedVersion;
    }

    @ProtoField(value=2)
    SessionEntityWrapper<T> getNewValue() {
        return this.newValue;
    }
}

