/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class Chain<T> {
    private final Link<T>[] vacant;
    private int highWaterMark;
    private Link<T> head = null;
    private Link<T> tail = null;
    private int size = 0;
    private final Runnable emptyingTrigger;

    Chain(Link<T>[] vacant, int highWaterMark, Runnable emptyingTrigger) {
        this.vacant = vacant;
        this.highWaterMark = highWaterMark;
        this.emptyingTrigger = Objects.requireNonNull(emptyingTrigger);
    }

    Chain(Link<T>[] vacant, int highWaterMark) {
        this(vacant, highWaterMark, () -> {});
    }

    static <T> void addHead(T value, Chain<T> ... chains) {
        Link<T> link;
        if (chains.length == 0) {
            link = null;
        } else {
            Link<T>[] vacant = chains[0].vacant;
            int highWaterMark = chains[0].highWaterMark;
            highWaterMark = Math.max(0, highWaterMark - 1);
            link = vacant[highWaterMark];
            vacant[highWaterMark] = null;
        }
        if (link == null) {
            new Link<T>(value, chains);
        } else {
            link.link(value, chains);
        }
    }

    T removeHead() {
        return this.remove(this.head);
    }

    T removeTail() {
        return this.remove(this.tail);
    }

    private T remove(Link<T> chainEdge) {
        if (chainEdge == null) {
            return null;
        }
        this.highWaterMark = Math.min(this.highWaterMark + 1, this.vacant.length - 1);
        this.vacant[this.highWaterMark] = chainEdge;
        return chainEdge.unlink();
    }

    int size() {
        return this.size;
    }

    void forEach(Consumer<? super T> action) {
        Integer index = null;
        Link<T> link = this.head;
        while (null != link && null != link.value && null != link.chains) {
            action.accept(link.value);
            if (index == null) {
                for (int i = 0; i < link.chains.length; ++i) {
                    if (this != link.chains[i]) continue;
                    index = i;
                    break;
                }
            }
            link = link.next[index];
        }
    }

    public String toString() {
        ArrayList list = new ArrayList();
        this.forEach(list::add);
        return "[" + list.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    static final class Link<T> {
        private T value;
        private Chain<T>[] chains;
        private final Link<T>[] prev;
        private final Link<T>[] next;

        private Link(T value, Chain<T> ... chains) {
            this.prev = new Link[chains.length];
            this.next = new Link[chains.length];
            this.link(value, chains);
        }

        private void link(T value, Chain<T> ... chains) {
            this.value = value;
            this.chains = chains;
            for (int i = 0; i < chains.length; ++i) {
                Chain<T> c = chains[i];
                ++c.size;
                this.next[i] = c.head;
                this.prev[i] = null;
                if (null != c.head) {
                    c.head.prev[i] = this;
                }
                c.head = this;
                if (null != c.tail) continue;
                c.tail = this;
            }
        }

        private T unlink() {
            T retVal = this.value;
            this.value = null;
            for (int i = 0; i < this.chains.length; ++i) {
                Chain<T> c = this.chains[i];
                if (0 == --c.size) {
                    c.emptyingTrigger.run();
                }
                if (this.prev[i] == null) {
                    c.head = this.next[i];
                } else {
                    this.prev[i].next[i] = this.next[i];
                }
                if (this.next[i] == null) {
                    c.tail = this.prev[i];
                } else {
                    this.next[i].prev[i] = this.prev[i];
                }
                this.prev[i] = null;
                this.next[i] = null;
                this.chains[i] = null;
            }
            return retVal;
        }

        public String toString() {
            return Objects.toString(this.value);
        }
    }
}

