/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene87;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.backward_codecs.compressing.CompressionMode;
import org.apache.lucene.backward_codecs.lucene50.compressing.Lucene50CompressingStoredFieldsFormat;
import org.apache.lucene.backward_codecs.lucene87.DeflateWithPresetDictCompressionMode;
import org.apache.lucene.backward_codecs.lucene87.LZ4WithPresetDictCompressionMode;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

public class Lucene87StoredFieldsFormat
extends StoredFieldsFormat {
    public static final String MODE_KEY = Lucene87StoredFieldsFormat.class.getSimpleName() + ".mode";
    final Mode mode;
    protected static final int BEST_COMPRESSION_BLOCK_LENGTH = 491520;
    public static final CompressionMode BEST_COMPRESSION_MODE = new DeflateWithPresetDictCompressionMode();
    protected static final int BEST_SPEED_BLOCK_LENGTH = 81920;
    public static final CompressionMode BEST_SPEED_MODE = new LZ4WithPresetDictCompressionMode();

    public Lucene87StoredFieldsFormat() {
        this(Mode.BEST_SPEED);
    }

    public Lucene87StoredFieldsFormat(Mode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        String value = si.getAttribute(MODE_KEY);
        if (value == null) {
            throw new IllegalStateException("missing value for " + MODE_KEY + " for segment: " + si.name);
        }
        Mode mode = Mode.valueOf(value);
        return this.impl(mode).fieldsReader(directory, si, fn, context);
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        throw new UnsupportedOperationException("Old codecs may only be used for reading");
    }

    StoredFieldsFormat impl(Mode mode) {
        switch (mode.ordinal()) {
            case 0: {
                return new Lucene50CompressingStoredFieldsFormat("Lucene87StoredFieldsFastData", BEST_SPEED_MODE, 81920, 1024, 10);
            }
            case 1: {
                return new Lucene50CompressingStoredFieldsFormat("Lucene87StoredFieldsHighData", BEST_COMPRESSION_MODE, 491520, 4096, 10);
            }
        }
        throw new AssertionError();
    }

    public static enum Mode {
        BEST_SPEED,
        BEST_COMPRESSION;

    }
}

