/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.MathUtils;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class SecToTimeFunction
extends ImplementorUDF {
    public SecToTimeFunction() {
        super(new SecToTimeImplementor(), NullPolicy.ARG0);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.TIME_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.NUMERIC;
    }

    public static class SecToTimeImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.call(SecToTimeImplementor.class, (String)"secToTime", (Expression[])new Expression[]{Expressions.convert_((Expression)Expressions.box((Expression)translatedOperands.getFirst()), Number.class)});
        }

        public static String secToTime(Number seconds) {
            ExprValue transferredValue = ExprValueUtils.fromObjectValue(seconds);
            ExprValue returnTimeValue = MathUtils.isIntegral(seconds) ? DateTimeFunctions.exprSecToTime(transferredValue) : DateTimeFunctions.exprSecToTimeWithNanos(transferredValue);
            return (String)returnTimeValue.valueForCalcite();
        }
    }
}

