/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.OpenSearchParseException;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.breaker.MLCircuitBreakerService;
import org.opensearch.ml.breaker.ThresholdCircuitBreaker;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStats;

public final class MLNodeUtils {
    public static boolean isMLNode(DiscoveryNode node) {
        return node.getRoles().stream().anyMatch(role -> role.roleName().equalsIgnoreCase("ml"));
    }

    public static XContentParser createXContentParserFromRegistry(NamedXContentRegistry xContentRegistry, BytesReference bytesReference) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)XContentType.JSON);
    }

    public static void parseArrayField(XContentParser parser, Set<String> set) throws IOException {
        MLNodeUtils.parseField(parser, set, null, String.class);
    }

    public static <T> void parseField(XContentParser parser, Set<T> set, Function<String, T> function, Class<T> clazz) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            String value = parser.text();
            if (function != null) {
                set.add(function.apply(value));
                continue;
            }
            if (!clazz.isInstance(value)) continue;
            set.add(clazz.cast(value));
        }
    }

    public static void validateSchema(String schemaString, String instanceString) throws IOException {
        JsonNode jsonNode;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode schemaNode = mapper.readTree(schemaString);
        JsonSchema schema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012).getSchema(schemaNode);
        Set errors = schema.validate(jsonNode = mapper.readTree(instanceString));
        if (!errors.isEmpty()) {
            throw new OpenSearchParseException("Validation failed: " + Arrays.toString(errors.toArray(new ValidationMessage[0])) + " for instance: " + instanceString + " with schema: " + schemaString, new Object[0]);
        }
    }

    public static String processRemoteInferenceInputDataSetParametersValue(String inputJson, String schemaJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(inputJson);
        JsonNode schemaNode = mapper.readTree(schemaJson);
        JsonNode parametersSchema = schemaNode.path("properties").path("parameters").path("properties");
        if (rootNode.has("parameters") && rootNode.get("parameters").isObject()) {
            ObjectNode parametersNode = (ObjectNode)rootNode.get("parameters");
            parametersNode.fields().forEachRemaining(entry -> {
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                if (value.isTextual() && !MLNodeUtils.isStringTypeInSchema(parametersSchema, key)) {
                    try {
                        JsonNode parsedValue = mapper.readTree(value.asText());
                        parametersNode.set(key, parsedValue);
                    }
                    catch (IOException e) {
                        parametersNode.set(key, value);
                    }
                }
            });
        }
        return mapper.writeValueAsString((Object)rootNode);
    }

    private static boolean isStringTypeInSchema(JsonNode schema, String fieldName) {
        JsonNode typeNode = schema.path(fieldName).path("type");
        return typeNode.isTextual() && typeNode.asText().equals("string");
    }

    public static void checkOpenCircuitBreaker(MLCircuitBreakerService mlCircuitBreakerService, MLStats mlStats) {
        ThresholdCircuitBreaker openCircuitBreaker = mlCircuitBreakerService.checkOpenCB();
        if (openCircuitBreaker != null) {
            mlStats.getStat(MLNodeLevelStat.ML_CIRCUIT_BREAKER_TRIGGER_COUNT).increment();
            throw new CircuitBreakingException(openCircuitBreaker.getName() + " is open, please check your resources!", CircuitBreaker.Durability.TRANSIENT);
        }
    }

    @Generated
    private MLNodeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

