/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.color;

import java.awt.Color;
import java.util.Collection;
import java.util.TreeSet;

public class ColorTrieNode {
    private final ColorTrieNode[] children = new ColorTrieNode[26];
    private Color value;
    public static final ColorTrieNode INSTANCE = new ColorTrieNode();
    public static final Collection<String> NAMES = new TreeSet<String>();

    private ColorTrieNode child(char k, boolean create) {
        int idx = (k | 0x20) - 97;
        if (idx < 0 || idx >= 26) {
            return null;
        }
        ColorTrieNode c = this.children[idx];
        if (c == null && create) {
            this.children[idx] = c = new ColorTrieNode();
        }
        return c;
    }

    private static void register(String name, Color color) {
        NAMES.add(name);
        INSTANCE.putColor(name, color);
    }

    public void putColor(CharSequence name, Color color) {
        ColorTrieNode n = this;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            if ((n = n.child(name.charAt(i), true)) != null) continue;
            return;
        }
        n.value = color;
    }

    public Color getColor(CharSequence name) {
        ColorTrieNode n = this;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            if ((n = n.child(name.charAt(i), false)) != null) continue;
            return null;
        }
        return n.value;
    }

    static {
        ColorTrieNode.register("AliceBlue", new Color(0xF0F8FF));
        ColorTrieNode.register("AntiqueWhite", new Color(16444375));
        ColorTrieNode.register("Aqua", new Color(65535));
        ColorTrieNode.register("Aquamarine", new Color(8388564));
        ColorTrieNode.register("Azure", new Color(0xF0FFFF));
        ColorTrieNode.register("Beige", new Color(16119260));
        ColorTrieNode.register("Bisque", new Color(16770244));
        ColorTrieNode.register("Black", new Color(0));
        ColorTrieNode.register("BlanchedAlmond", new Color(16772045));
        ColorTrieNode.register("Blue", new Color(255));
        ColorTrieNode.register("BlueViolet", new Color(9055202));
        ColorTrieNode.register("Brown", new Color(0xA52A2A));
        ColorTrieNode.register("BurlyWood", new Color(14596231));
        ColorTrieNode.register("CadetBlue", new Color(6266528));
        ColorTrieNode.register("Chartreuse", new Color(0x7FFF00));
        ColorTrieNode.register("Chocolate", new Color(13789470));
        ColorTrieNode.register("Coral", new Color(16744272));
        ColorTrieNode.register("CornflowerBlue", new Color(6591981));
        ColorTrieNode.register("Cornsilk", new Color(16775388));
        ColorTrieNode.register("Crimson", new Color(14423100));
        ColorTrieNode.register("Cyan", new Color(65535));
        ColorTrieNode.register("DarkBlue", new Color(139));
        ColorTrieNode.register("DarkCyan", new Color(35723));
        ColorTrieNode.register("DarkGoldenRod", new Color(12092939));
        ColorTrieNode.register("DarkGray", new Color(0xA9A9A9));
        ColorTrieNode.register("DarkGrey", new Color(0xA9A9A9));
        ColorTrieNode.register("DarkGreen", new Color(25600));
        ColorTrieNode.register("DarkKhaki", new Color(12433259));
        ColorTrieNode.register("DarkMagenta", new Color(0x8B008B));
        ColorTrieNode.register("DarkOliveGreen", new Color(5597999));
        ColorTrieNode.register("Darkorange", new Color(16747520));
        ColorTrieNode.register("DarkOrchid", new Color(10040012));
        ColorTrieNode.register("DarkRed", new Color(0x8B0000));
        ColorTrieNode.register("DarkSalmon", new Color(15308410));
        ColorTrieNode.register("DarkSeaGreen", new Color(9419919));
        ColorTrieNode.register("DarkSlateBlue", new Color(4734347));
        ColorTrieNode.register("DarkSlateGray", new Color(0x2F4F4F));
        ColorTrieNode.register("DarkSlateGrey", new Color(0x2F4F4F));
        ColorTrieNode.register("DarkTurquoise", new Color(52945));
        ColorTrieNode.register("DarkViolet", new Color(9699539));
        ColorTrieNode.register("DeepPink", new Color(16716947));
        ColorTrieNode.register("DeepSkyBlue", new Color(49151));
        ColorTrieNode.register("DimGray", new Color(0x696969));
        ColorTrieNode.register("DimGrey", new Color(0x696969));
        ColorTrieNode.register("DodgerBlue", new Color(2003199));
        ColorTrieNode.register("FireBrick", new Color(0xB22222));
        ColorTrieNode.register("FloralWhite", new Color(0xFFFAF0));
        ColorTrieNode.register("ForestGreen", new Color(0x228B22));
        ColorTrieNode.register("Fuchsia", new Color(0xFF00FF));
        ColorTrieNode.register("Gainsboro", new Color(0xDCDCDC));
        ColorTrieNode.register("GhostWhite", new Color(0xF8F8FF));
        ColorTrieNode.register("Gold", new Color(16766720));
        ColorTrieNode.register("GoldenRod", new Color(14329120));
        ColorTrieNode.register("Gray", new Color(0x808080));
        ColorTrieNode.register("Grey", new Color(0x808080));
        ColorTrieNode.register("Green", new Color(32768));
        ColorTrieNode.register("GreenYellow", new Color(11403055));
        ColorTrieNode.register("HoneyDew", new Color(0xF0FFF0));
        ColorTrieNode.register("HotPink", new Color(16738740));
        ColorTrieNode.register("IndianRed", new Color(0xCD5C5C));
        ColorTrieNode.register("Indigo", new Color(4915330));
        ColorTrieNode.register("Ivory", new Color(0xFFFFF0));
        ColorTrieNode.register("Khaki", new Color(15787660));
        ColorTrieNode.register("Lavender", new Color(15132410));
        ColorTrieNode.register("LavenderBlush", new Color(0xFFF0F5));
        ColorTrieNode.register("LawnGreen", new Color(8190976));
        ColorTrieNode.register("LemonChiffon", new Color(16775885));
        ColorTrieNode.register("LightBlue", new Color(11393254));
        ColorTrieNode.register("LightCoral", new Color(0xF08080));
        ColorTrieNode.register("LightCyan", new Color(0xE0FFFF));
        ColorTrieNode.register("LightGoldenRodYellow", new Color(16448210));
        ColorTrieNode.register("LightGray", new Color(0xD3D3D3));
        ColorTrieNode.register("LightGrey", new Color(0xD3D3D3));
        ColorTrieNode.register("LightGreen", new Color(0x90EE90));
        ColorTrieNode.register("LightPink", new Color(16758465));
        ColorTrieNode.register("LightSalmon", new Color(16752762));
        ColorTrieNode.register("LightSeaGreen", new Color(2142890));
        ColorTrieNode.register("LightSkyBlue", new Color(8900346));
        ColorTrieNode.register("LightSlateGray", new Color(0x778899));
        ColorTrieNode.register("LightSlateGrey", new Color(0x778899));
        ColorTrieNode.register("LightSteelBlue", new Color(11584734));
        ColorTrieNode.register("LightYellow", new Color(0xFFFFE0));
        ColorTrieNode.register("Lime", new Color(65280));
        ColorTrieNode.register("LimeGreen", new Color(3329330));
        ColorTrieNode.register("Linen", new Color(16445670));
        ColorTrieNode.register("Magenta", new Color(0xFF00FF));
        ColorTrieNode.register("Maroon", new Color(0x800000));
        ColorTrieNode.register("MediumAquaMarine", new Color(6737322));
        ColorTrieNode.register("MediumBlue", new Color(205));
        ColorTrieNode.register("MediumOrchid", new Color(12211667));
        ColorTrieNode.register("MediumPurple", new Color(9662680));
        ColorTrieNode.register("MediumSeaGreen", new Color(3978097));
        ColorTrieNode.register("MediumSlateBlue", new Color(8087790));
        ColorTrieNode.register("MediumSpringGreen", new Color(64154));
        ColorTrieNode.register("MediumTurquoise", new Color(4772300));
        ColorTrieNode.register("MediumVioletRed", new Color(13047173));
        ColorTrieNode.register("MidnightBlue", new Color(1644912));
        ColorTrieNode.register("MintCream", new Color(0xF5FFFA));
        ColorTrieNode.register("MistyRose", new Color(16770273));
        ColorTrieNode.register("Moccasin", new Color(16770229));
        ColorTrieNode.register("NavajoWhite", new Color(16768685));
        ColorTrieNode.register("Navy", new Color(128));
        ColorTrieNode.register("OldLace", new Color(16643558));
        ColorTrieNode.register("Olive", new Color(0x808000));
        ColorTrieNode.register("OliveDrab", new Color(7048739));
        ColorTrieNode.register("Orange", new Color(16753920));
        ColorTrieNode.register("OrangeRed", new Color(16729344));
        ColorTrieNode.register("Orchid", new Color(14315734));
        ColorTrieNode.register("PaleGoldenRod", new Color(0xEEE8AA));
        ColorTrieNode.register("PaleGreen", new Color(10025880));
        ColorTrieNode.register("PaleTurquoise", new Color(0xAFEEEE));
        ColorTrieNode.register("PaleVioletRed", new Color(14184595));
        ColorTrieNode.register("PapayaWhip", new Color(16773077));
        ColorTrieNode.register("PeachPuff", new Color(16767673));
        ColorTrieNode.register("Peru", new Color(13468991));
        ColorTrieNode.register("Pink", new Color(16761035));
        ColorTrieNode.register("Plum", new Color(0xDDA0DD));
        ColorTrieNode.register("PowderBlue", new Color(11591910));
        ColorTrieNode.register("Purple", new Color(0x800080));
        ColorTrieNode.register("Red", new Color(0xFF0000));
        ColorTrieNode.register("RosyBrown", new Color(12357519));
        ColorTrieNode.register("RoyalBlue", new Color(4286945));
        ColorTrieNode.register("SaddleBrown", new Color(9127187));
        ColorTrieNode.register("Salmon", new Color(16416882));
        ColorTrieNode.register("SandyBrown", new Color(16032864));
        ColorTrieNode.register("SeaGreen", new Color(3050327));
        ColorTrieNode.register("SeaShell", new Color(0xFFF5EE));
        ColorTrieNode.register("Sienna", new Color(10506797));
        ColorTrieNode.register("Silver", new Color(0xC0C0C0));
        ColorTrieNode.register("SkyBlue", new Color(8900331));
        ColorTrieNode.register("SlateBlue", new Color(6970061));
        ColorTrieNode.register("SlateGray", new Color(7372944));
        ColorTrieNode.register("SlateGrey", new Color(7372944));
        ColorTrieNode.register("Snow", new Color(0xFFFAFA));
        ColorTrieNode.register("SpringGreen", new Color(65407));
        ColorTrieNode.register("SteelBlue", new Color(4620980));
        ColorTrieNode.register("Tan", new Color(13808780));
        ColorTrieNode.register("Teal", new Color(32896));
        ColorTrieNode.register("Thistle", new Color(14204888));
        ColorTrieNode.register("Tomato", new Color(16737095));
        ColorTrieNode.register("Turquoise", new Color(4251856));
        ColorTrieNode.register("Violet", new Color(0xEE82EE));
        ColorTrieNode.register("Wheat", new Color(16113331));
        ColorTrieNode.register("White", new Color(0xFFFFFF));
        ColorTrieNode.register("WhiteSmoke", new Color(0xF5F5F5));
        ColorTrieNode.register("Yellow", new Color(0xFFFF00));
        ColorTrieNode.register("YellowGreen", new Color(10145074));
        ColorTrieNode.register("BUSINESS", new Color(0xFFFFCC));
        ColorTrieNode.register("APPLICATION", new Color(12775679));
        ColorTrieNode.register("MOTIVATION", new Color(0xCCCCFF));
        ColorTrieNode.register("STRATEGY", new Color(16312256));
        ColorTrieNode.register("TECHNOLOGY", new Color(0xC9FFC9));
        ColorTrieNode.register("PHYSICAL", new Color(0x97FF97));
        ColorTrieNode.register("IMPLEMENTATION", new Color(0xFFE0E0));
    }
}

