/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class BufferingTextSplitter {
    @NotNull
    private final StringBuilder myLineBuffer;
    private boolean myBufferedCr;
    @NotNull
    private final LineConsumer myLineConsumer;

    @VisibleForTesting
    public BufferingTextSplitter(@NotNull LineConsumer lineConsumer) {
        if (lineConsumer == null) {
            BufferingTextSplitter.$$$reportNull$$$0(0);
        }
        this.myLineBuffer = new StringBuilder();
        this.myBufferedCr = false;
        this.myLineConsumer = lineConsumer;
    }

    public void process(char[] input, int contentLength) {
        int offset = 0;
        while (offset < contentLength) {
            boolean isCrLine;
            boolean isCr;
            int nextLine = BufferingTextSplitter.indexOfNewline(input, offset, contentLength);
            if (nextLine == -1) {
                if (this.myBufferedCr) {
                    this.sendBufferLine();
                }
                this.myLineBuffer.append(input, offset, contentLength - offset);
                break;
            }
            boolean bl = isCr = input[nextLine] == '\r';
            if (isCr && nextLine + 1 == contentLength) {
                if (this.myBufferedCr) {
                    this.sendBufferLine();
                }
                this.myLineBuffer.append(input, offset, nextLine - offset);
                this.myBufferedCr = true;
                break;
            }
            if (this.myBufferedCr) {
                if (input[offset] == '\n') {
                    this.myBufferedCr = false;
                } else {
                    this.sendBufferLine();
                }
            }
            boolean isCrLf = isCr && input[nextLine + 1] == '\n';
            boolean bl2 = isCrLine = isCr && !isCrLf;
            if (this.myLineBuffer.isEmpty()) {
                String text2 = new String(input, offset, nextLine - offset);
                this.myLineConsumer.consume(text2, isCrLine);
            } else {
                this.myBufferedCr = isCrLine;
                this.myLineBuffer.append(input, offset, nextLine - offset);
                this.sendBufferLine();
            }
            offset = isCrLf ? nextLine + 2 : nextLine + 1;
        }
    }

    private static int indexOfNewline(char[] input, int offset, int contentLength) {
        for (int i = offset; i < contentLength; ++i) {
            char character = input[i];
            if (character != '\n' && character != '\r') continue;
            return i;
        }
        return -1;
    }

    private void sendBufferLine() {
        this.myLineConsumer.consume(this.myLineBuffer.toString(), this.myBufferedCr);
        this.myLineBuffer.setLength(0);
        this.myBufferedCr = false;
    }

    public void flush() {
        if (!this.myLineBuffer.isEmpty() || this.myBufferedCr) {
            this.sendBufferLine();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineConsumer", "git4idea/commands/BufferingTextSplitter", "<init>"));
    }

    @ApiStatus.Internal
    public static interface LineConsumer {
        public void consume(@NotNull String var1, boolean var2);
    }
}

