/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.execution.CommandLineUtil;
import git4idea.commands.GitScriptGenerator;
import git4idea.commit.signing.PinentryLauncherGenerator;
import git4idea.config.GitExecutable;
import git4idea.gpg.PinentryApp;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lgit4idea/commit/signing/PinentryShellScriptLauncherGenerator;", "Lgit4idea/commands/GitScriptGenerator;", "Lgit4idea/commit/signing/PinentryLauncherGenerator;", "executable", "Lgit4idea/config/GitExecutable;", "<init>", "(Lgit4idea/config/GitExecutable;)V", "getExecutable", "()Lgit4idea/config/GitExecutable;", "getScriptTemplate", "", "fallbackPinentryPath", "intellij.vcs.git"})
public final class PinentryShellScriptLauncherGenerator
extends GitScriptGenerator
implements PinentryLauncherGenerator {
    @NotNull
    private final GitExecutable executable;

    public PinentryShellScriptLauncherGenerator(@NotNull GitExecutable executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        super(executable);
        this.executable = executable;
    }

    @Override
    @NotNull
    public GitExecutable getExecutable() {
        return this.executable;
    }

    @Override
    @Language(value="Shell Script")
    @NotNull
    public String getScriptTemplate(@Nullable String fallbackPinentryPath) {
        if (fallbackPinentryPath == null) {
            String[] stringArray = this.getCommandLineParameters();
            return StringsKt.trimMargin$default((String)("|#!/bin/sh\n                |" + this.addParameters(Arrays.copyOf(stringArray, stringArray.length)).commandLine(PinentryApp.class, false) + "\n             "), null, (int)1, null);
        }
        String[] stringArray = this.getCommandLineParameters();
        return StringsKt.trimMargin$default((String)("|#!/bin/sh\n              |if [ -n \"$PINENTRY_USER_DATA\" ]; then\n              |  case \"$PINENTRY_USER_DATA\" in\n              |    IJ_PINENTRY=*)\n              |      " + this.addParameters(Arrays.copyOf(stringArray, stringArray.length)).commandLine(PinentryApp.class, false) + "\n              |      exit $?\n              |    ;;\n              |  esac\n              |fi\n              |exec " + CommandLineUtil.posixQuote((String)fallbackPinentryPath) + " \"$@\"\n           "), null, (int)1, null);
    }
}

