/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.ColumnHeaderActionBase;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HideOtherColumnsAction
extends ColumnHeaderActionBase {
    public HideOtherColumnsAction() {
        super(true);
    }

    @Override
    protected void actionPerformed(AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> columnIdxs) {
        if (grid == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(0);
        }
        if (columnIdxs == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(1);
        }
        for (ModelIndex index : columnIdxs.asIterable()) {
            grid.setColumnEnabled(index, false);
        }
    }

    @Override
    @NotNull
    protected ModelIndexSet<GridColumn> getColumns(@NotNull DataGrid grid) {
        ModelIndexSet<GridColumn> selected;
        if (grid == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(2);
        }
        ModelIndexSet<GridColumn> modelIndexSet = (selected = super.getColumns(grid)).size() > 0 ? HideOtherColumnsAction.getOtherColumns(grid, selected) : selected;
        if (modelIndexSet == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(3);
        }
        return modelIndexSet;
    }

    @NotNull
    private static ModelIndexSet<GridColumn> getOtherColumns(@NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> selected) {
        if (grid == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(4);
        }
        if (selected == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(5);
        }
        List selectedList = selected.asList();
        List<ModelIndex<GridColumn>> additionalColumnsToKeep = HideOtherColumnsAction.getAdditionalColumnsToKeep(grid, selectedList);
        List indices = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnIndices().asList();
        IntArrayList other = new IntArrayList();
        for (ModelIndex idx : indices) {
            if (selectedList.contains(idx) || additionalColumnsToKeep.contains(idx)) continue;
            other.add(idx.value);
        }
        ModelIndexSet modelIndexSet = ModelIndexSet.forColumns((CoreGrid)grid, (int[])other.toIntArray());
        if (modelIndexSet == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(6);
        }
        return modelIndexSet;
    }

    private static List<ModelIndex<GridColumn>> getAdditionalColumnsToKeep(@NotNull DataGrid grid, @NotNull List<ModelIndex<GridColumn>> selectedColumns) {
        if (grid == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(7);
        }
        if (selectedColumns == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(8);
        }
        ArrayList<Object> additionalColumnsToKeep = new ArrayList<Object>();
        for (ModelIndex<GridColumn> colIdx : selectedColumns) {
            GridColumn column = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(colIdx);
            if (!(column instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn)) continue;
            HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)column;
            additionalColumnsToKeep.addAll(HideOtherColumnsAction.getAncestorsBranchToKeep(hierarchicalColumn));
            if (!hierarchicalColumn.isLeftMostChildOfDirectAncestor()) continue;
            additionalColumnsToKeep.addAll(HideOtherColumnsAction.getLeaves(hierarchicalColumn.getParent()));
        }
        return HideOtherColumnsAction.getColumnIndices(grid, additionalColumnsToKeep);
    }

    private static List<HierarchicalColumnsDataGridModel.HierarchicalGridColumn> getLeaves(@Nullable HierarchicalColumnsDataGridModel.HierarchicalGridColumn column) {
        if (column == null) {
            return Collections.emptyList();
        }
        return column.getLeaves();
    }

    private static List<GridColumn> getAncestorsBranchToKeep(@NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn) {
        if (hierarchicalColumn == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(9);
        }
        ArrayList<GridColumn> ancestorsToKeep = new ArrayList<GridColumn>();
        for (HierarchicalColumnsDataGridModel.HierarchicalGridColumn ancestor = hierarchicalColumn.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            List leaves = ancestor.getLeaves();
            HierarchicalColumnsDataGridModel.HierarchicalGridColumn leftMostChild = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)leaves.get(0);
            ancestorsToKeep.add((GridColumn)leftMostChild);
        }
        return ancestorsToKeep;
    }

    private static List<ModelIndex<GridColumn>> getColumnIndices(@NotNull DataGrid grid, @NotNull List<? extends GridColumn> columns) {
        if (grid == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(10);
        }
        if (columns == null) {
            HideOtherColumnsAction.$$$reportNull$$$0(11);
        }
        ArrayList<ModelIndex<GridColumn>> indices = new ArrayList<ModelIndex<GridColumn>>(columns.size());
        for (GridColumn gridColumn : columns) {
            indices.add((ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)grid, (int)gridColumn.getColumnNumber()));
        }
        return indices;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdxs";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/HideOtherColumnsAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedColumns";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchicalColumn";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/HideOtherColumnsAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOtherColumns";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalColumnsToKeep";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorsBranchToKeep";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColumnIndices";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

