/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Arrays;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Line2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYGeometry;

public class XYLine
extends XYGeometry {
    private final float[] x;
    private final float[] y;
    public final float minX;
    public final float maxX;
    public final float minY;
    public final float maxY;

    public XYLine(float[] x, float[] y) {
        if (x == null) {
            throw new IllegalArgumentException("x must not be null");
        }
        if (y == null) {
            throw new IllegalArgumentException("y must not be null");
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must be equal length");
        }
        if (x.length < 2) {
            throw new IllegalArgumentException("at least 2 line points required");
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        for (int i = 0; i < x.length; ++i) {
            minX = Math.min(XYEncodingUtils.checkVal(x[i]), minX);
            minY = Math.min(XYEncodingUtils.checkVal(y[i]), minY);
            maxX = Math.max(x[i], maxX);
            maxY = Math.max(y[i], maxY);
        }
        this.x = (float[])x.clone();
        this.y = (float[])y.clone();
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public int numPoints() {
        return this.x.length;
    }

    public float getX(int vertex) {
        return this.x[vertex];
    }

    public float getY(int vertex) {
        return this.y[vertex];
    }

    public float[] getX() {
        return (float[])this.x.clone();
    }

    public float[] getY() {
        return (float[])this.y.clone();
    }

    @Override
    protected Component2D toComponent2D() {
        return Line2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XYLine)) {
            return false;
        }
        XYLine line = (XYLine)o;
        return Arrays.equals(this.x, line.x) && Arrays.equals(this.y, line.y);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYLine(");
        for (int i = 0; i < this.x.length; ++i) {
            sb.append("[").append(this.x[i]).append(", ").append(this.y[i]).append("]");
        }
        sb.append(')');
        return sb.toString();
    }
}

