/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCallableParameterImpl
implements PyCallableParameter {
    @Nullable
    @NlsSafe
    private final String myName;
    @Nullable
    private final Ref<PyType> myType;
    @Nullable
    private final PyExpression myDefaultValue;
    @Nullable
    private final PyParameter myElement;
    @Nullable
    private final PsiElement myDeclarationElement;
    private final boolean myIsPositional;
    private final boolean myIsKeyword;

    PyCallableParameterImpl(@Nullable String name, @Nullable Ref<PyType> type, @Nullable PyExpression defaultValue, @Nullable PyParameter element, boolean isPositional, boolean isKeyword, @Nullable PsiElement declarationElement) {
        this.myName = name;
        this.myType = type;
        this.myDefaultValue = defaultValue;
        this.myElement = element;
        this.myIsPositional = isPositional;
        this.myIsKeyword = isKeyword;
        this.myDeclarationElement = declarationElement;
    }

    @NotNull
    public static PyCallableParameter nonPsi(@Nullable PyType type) {
        return PyCallableParameterImpl.nonPsi(null, type);
    }

    @NotNull
    public static PyCallableParameter nonPsi(@Nullable String name, @Nullable PyType type) {
        return PyCallableParameterImpl.nonPsi(name, type, null);
    }

    @NotNull
    public static PyCallableParameter nonPsi(@Nullable String name, @Nullable PyType type, @Nullable PyExpression defaultValue) {
        return new PyCallableParameterImpl(name, (Ref<PyType>)Ref.create((Object)type), defaultValue, null, false, false, null);
    }

    @NotNull
    public static PyCallableParameter nonPsi(@Nullable String name, @Nullable PyType type, @Nullable PyExpression defaultValue, @NotNull PsiElement declarationElement) {
        if (declarationElement == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(0);
        }
        return new PyCallableParameterImpl(name, (Ref<PyType>)Ref.create((Object)type), defaultValue, null, false, false, declarationElement);
    }

    @NotNull
    public static PyCallableParameter positionalNonPsi(@Nullable String name, @Nullable PyType type) {
        return new PyCallableParameterImpl(name, (Ref<PyType>)Ref.create((Object)type), null, null, true, false, null);
    }

    @NotNull
    public static PyCallableParameter keywordNonPsi(@Nullable String name, @Nullable PyType type) {
        return new PyCallableParameterImpl(name, (Ref<PyType>)Ref.create((Object)type), null, null, false, true, null);
    }

    @NotNull
    public static PyCallableParameter psi(@NotNull PyParameter parameter) {
        if (parameter == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(1);
        }
        return new PyCallableParameterImpl(null, null, null, parameter, false, false, null);
    }

    @NotNull
    public static PyCallableParameter psi(@NotNull PyParameter parameter, @Nullable PyType type) {
        if (parameter == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(2);
        }
        return new PyCallableParameterImpl(null, (Ref<PyType>)Ref.create((Object)type), null, parameter, false, false, null);
    }

    @Nullable
    @Nls
    public String getName() {
        if (this.myName != null) {
            return this.myName;
        }
        if (this.myElement != null) {
            return this.myElement.getName();
        }
        return null;
    }

    @Nullable
    public PyType getType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(3);
        }
        if (this.myType != null) {
            return (PyType)this.myType.get();
        }
        if (this.myElement instanceof PyNamedParameter) {
            return context.getType((PyTypedElement)((PyNamedParameter)this.myElement));
        }
        return null;
    }

    @Nullable
    public PyParameter getParameter() {
        return this.myElement;
    }

    @Nullable
    public PsiElement getDeclarationElement() {
        if (this.myDeclarationElement != null) {
            return this.myDeclarationElement;
        }
        return this.getParameter();
    }

    @Nullable
    public PyExpression getDefaultValue() {
        return this.myElement == null ? this.myDefaultValue : this.myElement.getDefaultValue();
    }

    public boolean hasDefaultValue() {
        return this.myElement == null ? this.myDefaultValue != null : this.myElement.hasDefaultValue();
    }

    @Nullable
    public String getDefaultValueText() {
        if (this.myElement != null) {
            return this.myElement.getDefaultValueText();
        }
        return this.myDefaultValue == null ? null : this.myDefaultValue.getText();
    }

    public boolean isPositionalContainer() {
        if (this.myIsPositional) {
            return true;
        }
        PyNamedParameter namedParameter = PyUtil.as(this.myElement, PyNamedParameter.class);
        return namedParameter != null && namedParameter.isPositionalContainer();
    }

    public boolean isKeywordContainer() {
        if (this.myIsKeyword) {
            return true;
        }
        PyNamedParameter namedParameter = PyUtil.as(this.myElement, PyNamedParameter.class);
        return namedParameter != null && namedParameter.isKeywordContainer();
    }

    public boolean isSelf() {
        return this.myElement != null && this.myElement.isSelf();
    }

    public boolean isPositionOnlySeparator() {
        return this.myElement instanceof PySlashParameter;
    }

    public boolean isKeywordOnlySeparator() {
        return this.myElement instanceof PySingleStarParameter;
    }

    @NotNull
    public String getPresentableText(boolean includeDefaultValue, @Nullable TypeEvalContext context) {
        String string = this.getPresentableText(includeDefaultValue, context, Objects::isNull);
        if (string == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getPresentableText(boolean includeDefaultValue, @Nullable TypeEvalContext context, @NotNull Predicate<PyType> typeFilter) {
        if (typeFilter == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(5);
        }
        if (this.myElement instanceof PyNamedParameter || this.myElement == null) {
            PyType argumentType;
            StringBuilder sb = new StringBuilder();
            sb.append(ParamHelper.getNameInSignature(this));
            boolean renderedAsTyped = false;
            if (context != null && !typeFilter.test(argumentType = this.getArgumentType(context))) {
                sb.append(": ");
                sb.append(PythonDocumentationProvider.getTypeName(argumentType, context));
                renderedAsTyped = true;
            }
            if (includeDefaultValue) {
                sb.append((String)ObjectUtils.notNull((Object)ParamHelper.getDefaultValuePartInSignature(this.getDefaultValueText(), renderedAsTyped), (Object)""));
            }
            String string = sb.toString();
            if (string == null) {
                PyCallableParameterImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = PyUtil.getReadableRepr((PsiElement)this.myElement, false);
        if (string == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public PyType getArgumentType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(8);
        }
        PyType parameterType = this.getType(context);
        if (this.isPositionalContainer() && parameterType instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)parameterType;
            PyUnpackedTupleType unpackedTupleType = tupleType.asUnpackedTupleType();
            if (unpackedTupleType.isUnbound()) {
                return (PyType)unpackedTupleType.getElementTypes().get(0);
            }
            return unpackedTupleType;
        }
        if (this.isKeywordContainer() && parameterType instanceof PyCollectionType) {
            PyCollectionType dictType = (PyCollectionType)parameterType;
            return (PyType)ContainerUtil.getOrElse(dictType.getElementTypes(), (int)1, null);
        }
        return parameterType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyCallableParameterImpl parameter = (PyCallableParameterImpl)o;
        return this.myIsPositional == parameter.myIsPositional && this.myIsKeyword == parameter.myIsKeyword && Objects.equals(this.myName, parameter.myName) && Objects.equals(Ref.deref(this.myType), Ref.deref(parameter.myType)) && Objects.equals(this.myDefaultValue, parameter.myDefaultValue) && Objects.equals(this.myElement, parameter.myElement);
    }

    public int hashCode() {
        return Objects.hash(this.myName, Ref.deref(this.myType), this.myDefaultValue, this.myElement, this.myIsPositional, this.myIsKeyword);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyCallableParameterImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyCallableParameterImpl";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nonPsi";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "psi";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

