/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.terminal.pty.PtyProcessTtyConnector;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.LocalTerminalTtyConnector;
import org.jetbrains.plugins.terminal.ShellProcessHolder;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalStartupKt;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.runner.LocalOptionsConfigurer;
import org.jetbrains.plugins.terminal.runner.LocalShellIntegrationInjector;
import org.jetbrains.plugins.terminal.runner.LocalTerminalStartCommandBuilder;
import org.jetbrains.plugins.terminal.shell_integration.TerminalPSReadLineUpdateUtil;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    @ApiStatus.Internal
    public static final String LOGIN_CLI_OPTION = "--login";
    @ApiStatus.Internal
    public static final List<String> LOGIN_CLI_OPTIONS = List.of("--login", "-l");
    protected final Charset myDefaultCharset = StandardCharsets.UTF_8;

    public LocalTerminalDirectRunner(Project project) {
        super(project);
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        return new LocalTerminalDirectRunner(project);
    }

    @Override
    @NotNull
    public ShellStartupOptions configureStartupOptions(@NotNull ShellStartupOptions baseOptions) {
        if (baseOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        ShellStartupOptions updatedOptions = LocalOptionsConfigurer.configureStartupOptions(baseOptions, this.myProject);
        if (this.enableShellIntegration()) {
            updatedOptions = LocalShellIntegrationInjector.injectShellIntegration(updatedOptions, this.isGenOneTerminalEnabled(), this.isGenTwoTerminalEnabled());
        }
        updatedOptions = TerminalPSReadLineUpdateUtil.configureOptions(updatedOptions);
        return this.applyTerminalCustomizers(updatedOptions);
    }

    @NotNull
    private ShellStartupOptions applyTerminalCustomizers(@NotNull ShellStartupOptions options) {
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        List<String> shellCommand = ContainerUtil.notNullize(options.getShellCommand());
        EelDescriptor eelDescriptor = TerminalStartupKt.findEelDescriptor(options.getWorkingDirectory(), shellCommand);
        Map<String, String> envs = ShellStartupOptionsKt.createEnvVariablesMap(options.getEnvVariables());
        for (LocalTerminalCustomizer customizer : LocalTerminalCustomizer.EP_NAME.getExtensionList()) {
            try {
                shellCommand = customizer.customizeCommandAndEnvironment(this.myProject, options.getWorkingDirectory(), shellCommand, envs, eelDescriptor);
            }
            catch (Exception e) {
                LOG.error("Exception during customization of the terminal session", (Throwable)e);
            }
        }
        ShellStartupOptions shellStartupOptions = options.builder().shellCommand(shellCommand).envVariables(envs).build();
        if (shellStartupOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(2);
        }
        return shellStartupOptions;
    }

    @Override
    @Deprecated(forRemoval=true)
    @NotNull
    public PtyProcess createProcess(@NotNull ShellStartupOptions options) throws ExecutionException {
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(3);
        }
        PtyProcess ptyProcess = this.doCreateProcess(options).getPtyProcess();
        if (ptyProcess == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(4);
        }
        return ptyProcess;
    }

    @NotNull
    private ShellProcessHolder doCreateProcess(@NotNull ShellStartupOptions options) throws ExecutionException {
        ShellProcessHolder shellProcessHolder;
        boolean isBlockTerminal;
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(5);
        }
        List<String> command2 = Objects.requireNonNull(options.getShellCommand(), () -> "Shell command must not be null, " + String.valueOf(options));
        Map<String, String> envs = options.getEnvVariables();
        TermSize initialTermSize = Objects.requireNonNull(options.getInitialTermSize(), () -> "Initial term size must not be null, " + String.valueOf(options));
        String workingDir = Objects.requireNonNull(options.getWorkingDirectory(), () -> "Working directory must not be null, " + String.valueOf(options));
        ShellIntegration shellIntegration = options.getShellIntegration();
        boolean bl = isBlockTerminal = this.isGenOneTerminalEnabled() && shellIntegration != null && shellIntegration.getCommandBlocks();
        if (this.isGenTwoTerminalEnabled()) {
            ReworkedTerminalUsageCollector.logLocalShellStarted(this.myProject, command2);
        } else {
            TerminalUsageTriggerCollector.triggerLocalShellStarted(this.myProject, command2, isBlockTerminal);
        }
        try {
            long startNano = System.nanoTime();
            Path workingDirPath = Path.of(workingDir, new String[0]);
            ShellProcessHolder processHolder = TerminalStartupKt.shouldUseEelApi() ? TerminalStartupKt.startProcess(command2, envs, workingDirPath, initialTermSize) : TerminalStartupKt.startLocalProcess(command2, envs, workingDir, initialTermSize);
            LOG.info("Started " + processHolder.getPtyProcess().getClass().getName() + " in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms from " + LocalTerminalDirectRunner.stringifyProcessInfo(command2, workingDir, initialTermSize, envs, !LOG.isDebugEnabled()));
            shellProcessHolder = processHolder;
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to start " + LocalTerminalDirectRunner.stringifyProcessInfo(command2, workingDir, initialTermSize, envs, false), e);
        }
        if (shellProcessHolder == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(6);
        }
        return shellProcessHolder;
    }

    protected boolean enableShellIntegration() {
        return TerminalOptionsProvider.getInstance().getShellIntegration();
    }

    @NotNull
    private static String stringifyProcessInfo(@NotNull List<String> command2, @NotNull String workingDirectory, @Nullable TermSize initialTermSize, @NotNull Map<String, String> environment, boolean envDiff) {
        if (command2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(7);
        }
        if (workingDirectory == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(8);
        }
        if (environment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(9);
        }
        String info = String.valueOf(command2) + " in " + workingDirectory + (LocalTerminalDirectRunner.isDirectory(workingDirectory) ? "" : " [no such directory]") + ", [" + String.valueOf(initialTermSize) + "]";
        if (envDiff) {
            String string = info + ", diff_envs=" + String.valueOf(LocalTerminalDirectRunner.getEnvironmentDiff(environment, System.getenv()));
            if (string == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = info + ", envs=" + String.valueOf(environment);
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static Map<String, String> getEnvironmentDiff(@NotNull Map<String, String> environment, @NotNull Map<String, String> baseEnvironment) {
        if (environment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(12);
        }
        if (baseEnvironment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(13);
        }
        Map map2 = environment.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> Objects.equals(entry.getValue(), baseEnvironment.get(entry.getKey())) ? null : entry).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
        if (map2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(14);
        }
        return map2;
    }

    @ApiStatus.Internal
    public static boolean isDirectory(@NotNull String directory) {
        if (directory == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(15);
        }
        try {
            boolean ok = Files.isDirectory(Path.of(directory, new String[0]), new LinkOption[0]);
            if (!ok) {
                LOG.info("Cannot start local terminal in " + directory + ": no such directory");
            }
            return ok;
        }
        catch (InvalidPathException e) {
            LOG.info("Cannot start local terminal in " + directory + ": invalid path", (Throwable)e);
            return false;
        }
    }

    @Override
    @NotNull
    public TtyConnector createTtyConnector(@NotNull ShellStartupOptions startupOptions) throws ExecutionException {
        if (startupOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(16);
        }
        ShellProcessHolder processHolder = this.doCreateProcess(startupOptions);
        return new LocalTerminalTtyConnector(processHolder, this.myDefaultCharset);
    }

    @Override
    @Deprecated(forRemoval=true)
    @NotNull
    public TtyConnector createTtyConnector(@NotNull PtyProcess process) {
        if (process == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(17);
        }
        return new PtyProcessTtyConnector(process, this.myDefaultCharset);
    }

    @Override
    @NotNull
    public String getDefaultTabTitle() {
        String string = TerminalOptionsProvider.getInstance().getTabName();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Deprecated(since="2024.3", forRemoval=true)
    @NotNull
    public List<String> getInitialCommand(@NotNull Map<String, String> envs) {
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(19);
        }
        List<String> list = LocalTerminalStartCommandBuilder.convertShellPathToCommand(this.getShellPath());
        if (list == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(20);
        }
        return list;
    }

    @ApiStatus.Internal
    protected boolean isGenOneTerminalEnabled() {
        return false;
    }

    @ApiStatus.Internal
    protected boolean isGenTwoTerminalEnabled() {
        return false;
    }

    @NotNull
    private String getShellPath() {
        String string = TerminalProjectOptionsProvider.getInstance(this.myProject).getShellPath();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(21);
        }
        return string;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public ShellStartupOptions injectShellIntegration(@NotNull List<String> shellCommand, @NotNull Map<String, String> envs) {
        if (shellCommand == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(22);
        }
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(23);
        }
        ShellStartupOptions options = new ShellStartupOptions.Builder().shellCommand(shellCommand).envVariables(envs).build();
        ShellStartupOptions shellStartupOptions = LocalShellIntegrationInjector.injectShellIntegration(options, this.isGenOneTerminalEnabled(), this.isGenTwoTerminalEnabled());
        if (shellStartupOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(24);
        }
        return shellStartupOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 10, 11, 14, 18, 20, 21, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseOptions";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseEnvironment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupOptions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTerminalCustomizers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateProcess";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyProcessInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentDiff";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTabTitle";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialCommand";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "injectShellIntegration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureStartupOptions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyTerminalCustomizers";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 24: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreateProcess";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stringifyProcessInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentDiff";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createTtyConnector";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCommand";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "injectShellIntegration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 10, 11, 14, 18, 20, 21, 24 -> new IllegalStateException(string);
        };
    }
}

