/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

public final class TcpMultiplexer {
    private static final Consumer<Throwable> NO_OP_CALLBACK;
    private static volatile boolean isStarted;
    private final Selector selector;
    private final ConcurrentLinkedQueue<Runnable> registrationQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger pendingRegistrationCount = new AtomicInteger(0);
    private final Thread pollingThread;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    private static TcpMultiplexer soleInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void registerForReadEvent(SocketChannel channel, Consumer<Throwable> onReady) throws IOException {
        TcpMultiplexer.soleInstance().register(channel, 1, onReady);
    }

    public static void registerForWriteEvent(SocketChannel channel, Consumer<Throwable> onReady) throws IOException {
        TcpMultiplexer.soleInstance().register(channel, 4, onReady);
    }

    public static void registerForConnectEvent(SocketChannel sc, Consumer<Throwable> onReady) throws IOException {
        TcpMultiplexer.soleInstance().register(sc, 8, onReady);
    }

    public static void cancelRegistration(SocketChannel channel, Throwable callbackArg) {
        if (!isStarted) {
            return;
        }
        SelectionKey key = TcpMultiplexer.soleInstance().getKeyForChannel(channel);
        if (key == null) {
            return;
        }
        TcpMultiplexer.onReadReady(key, callbackArg);
    }

    public static void stop() {
        if (!isStarted) {
            return;
        }
        isStarted = false;
        TcpMultiplexer.soleInstance().pollingThread.interrupt();
    }

    private TcpMultiplexer(Selector selector) {
        this.selector = selector;
        this.pollingThread = new Thread(this::poll, this.getClass().getName());
        this.pollingThread.setDaemon(true);
        this.pollingThread.start();
        isStarted = true;
    }

    private void register(SocketChannel channel, int interest, Consumer<Throwable> onReady) throws IOException {
        this.registrationQueue.add(() -> {
            try {
                channel.configureBlocking(false);
                channel.register(this.selector, interest, onReady);
            }
            catch (Throwable e2) {
                try {
                    channel.configureBlocking(true);
                }
                catch (Throwable e22) {
                    e2.addSuppressed(e22);
                }
                onReady.accept(e2);
            }
        });
        if (this.pendingRegistrationCount.getAndIncrement() == 0) {
            this.selector.wakeup();
        }
    }

    private SelectionKey getKeyForChannel(SocketChannel channel) {
        return channel.keyFor(this.selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll() {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        try {
            try {
                while (true) {
                    int registrationCount;
                    int selected = this.selector.select();
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedIOException(Thread.currentThread().getName() + " received a thread interrupt");
                    }
                    while (selected != 0) {
                        for (SelectionKey key2 : this.selector.selectedKeys()) {
                            TcpMultiplexer.onReadReady(key2);
                        }
                        this.selector.selectedKeys().clear();
                        selected = this.selector.selectNow();
                    }
                    do {
                        registrationCount = 0;
                        Runnable registration = this.registrationQueue.poll();
                        while (registration != null) {
                            ++registrationCount;
                            registration.run();
                            registration = this.registrationQueue.poll();
                        }
                    } while (this.pendingRegistrationCount.addAndGet(-registrationCount) > 0);
                }
            }
            catch (IOException selectFailure) {
                this.invokeAllReadinessCallbacks(selectFailure);
                Consumer[] callbacks = (Consumer[])this.selector.keys().stream().map(key -> (Consumer)key.attach(NO_OP_CALLBACK)).toArray(Consumer[]::new);
                IOException finalCallbackResult = new IOException("Selector has stopped polling");
                try {
                    this.selector.close();
                }
                catch (IOException closeFailure) {
                    if (bl) {
                        this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, closeFailure.getMessage());
                    }
                    finalCallbackResult.addSuppressed(closeFailure);
                }
                for (Consumer callback : callbacks) {
                    callback.accept(finalCallbackResult);
                }
            }
        }
        catch (Throwable throwable) {
            Consumer[] callbacks = (Consumer[])this.selector.keys().stream().map(key -> (Consumer)key.attach(NO_OP_CALLBACK)).toArray(Consumer[]::new);
            IOException finalCallbackResult = new IOException("Selector has stopped polling");
            try {
                this.selector.close();
            }
            catch (IOException closeFailure) {
                if (bl) {
                    this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, closeFailure.getMessage());
                }
                finalCallbackResult.addSuppressed(closeFailure);
            }
            for (Consumer callback : callbacks) {
                callback.accept(finalCallbackResult);
            }
            throw throwable;
        }
    }

    private static final void onReadReady(SelectionKey key) {
        TcpMultiplexer.onReadReady(key, null);
    }

    private static final void onReadReady(SelectionKey key, Throwable callbackResult) {
        try {
            key.cancel();
            key.channel().configureBlocking(true);
        }
        catch (IOException e2) {
            if (callbackResult == null) {
                callbackResult = e2;
            }
            callbackResult.addSuppressed(e2);
        }
        TcpMultiplexer.invokeReadinessCallback(key, callbackResult);
    }

    /*
     * WARNING - void declaration
     */
    private static final void invokeReadinessCallback(SelectionKey selectionKey, Throwable throwable) {
        block2: {
            SelectionKey key;
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            Consumer callback = (Consumer)key.attach(NO_OP_CALLBACK);
            try {
                void callbackResult;
                callback.accept(callbackResult);
            }
            catch (Throwable callbackFailure) {
                if (!bl) break block2;
                OracleLog.log($$$loggerRef$$$11, Level.FINEST, TcpMultiplexer.class, $$$methodRef$$$11, "I/O Readiness callback threw an exception", callbackFailure);
            }
        }
    }

    private void invokeAllReadinessCallbacks(Throwable callbackResult) {
        for (SelectionKey key : this.selector.keys()) {
            TcpMultiplexer.invokeReadinessCallback(key, callbackResult);
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$18 = TcpMultiplexer.class.getDeclaredConstructor(Selector.class, 1.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TcpMultiplexer.class.getDeclaredConstructor(Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TcpMultiplexer.class.getDeclaredMethod("lambda$static$0", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TcpMultiplexer.class.getDeclaredMethod("lambda$register$1", SocketChannel.class, Integer.TYPE, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TcpMultiplexer.class.getDeclaredMethod("lambda$poll$2", SelectionKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TcpMultiplexer.class.getDeclaredMethod("lambda$poll$3", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TcpMultiplexer.class.getDeclaredMethod("invokeAllReadinessCallbacks", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpMultiplexer.class.getDeclaredMethod("invokeReadinessCallback", SelectionKey.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpMultiplexer.class.getDeclaredMethod("onReadReady", SelectionKey.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpMultiplexer.class.getDeclaredMethod("onReadReady", SelectionKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpMultiplexer.class.getDeclaredMethod("poll", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpMultiplexer.class.getDeclaredMethod("getKeyForChannel", SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpMultiplexer.class.getDeclaredMethod("register", SocketChannel.class, Integer.TYPE, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpMultiplexer.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpMultiplexer.class.getDeclaredMethod("cancelRegistration", SocketChannel.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpMultiplexer.class.getDeclaredMethod("registerForConnectEvent", SocketChannel.class, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpMultiplexer.class.getDeclaredMethod("registerForWriteEvent", SocketChannel.class, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpMultiplexer.class.getDeclaredMethod("registerForReadEvent", SocketChannel.class, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpMultiplexer.class.getDeclaredMethod("soleInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NO_OP_CALLBACK = e2 -> {};
        isStarted = false;
    }

    private static final class LazyHolder {
        private static final TcpMultiplexer INSTANCE;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        private LazyHolder() {
        }

        static {
            Selector selector;
            try {
                $$$methodRef$$$1 = LazyHolder.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = LazyHolder.class.getDeclaredMethod("access$100", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                selector = Selector.open();
            }
            catch (IOException ioEx) {
                throw new RuntimeException(ioEx);
            }
            INSTANCE = new TcpMultiplexer(selector);
        }
    }
}

