/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.InternalPluginException;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazon.redshift.plugin.httpserver.RequestHandler;
import com.amazon.redshift.plugin.httpserver.Server;
import com.amazon.redshift.plugin.utils.CheckUtils;
import com.amazon.redshift.plugin.utils.ResponseUtils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import org.apache.http.NameValuePair;

public class BrowserSamlCredentialsProvider
extends SamlCredentialsProvider {
    public static final String KEY_LOGIN_URL = "login_url";
    public static final String KEY_IDP_RESPONSE_TIMEOUT = "idp_response_timeout";
    public static final String KEY_LISTEN_PORT = "listen_port";
    private static final String SAML_RESPONSE_PARAM_NAME = "SAMLResponse";
    private String m_login_url;
    private int m_idp_response_timeout = 120;
    private int m_listen_port = 7890;

    @Override
    protected String getSamlAssertion() throws IOException {
        try {
            CheckUtils.checkMissingAndThrows(this.m_login_url, KEY_LOGIN_URL);
            CheckUtils.checkAndThrowsWithMessage(this.m_idp_response_timeout < 10, "idp_response_timeout should be 10 seconds or greater.");
            CheckUtils.checkInvalidAndThrows(this.m_listen_port < 1 || this.m_listen_port > 65535, KEY_LISTEN_PORT);
            this.validateURL(this.m_login_url);
            return this.authenticate();
        }
        catch (InternalPluginException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void addParameter(String key, String value) {
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("key: {0}", key);
        }
        switch (key) {
            case "listen_port": {
                this.m_listen_port = Integer.parseInt(value);
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_listen_port: {0}", this.m_listen_port);
                break;
            }
            case "login_url": {
                this.m_login_url = value;
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_login_url: {0}", this.m_login_url);
                break;
            }
            case "idp_response_timeout": {
                this.m_idp_response_timeout = Integer.parseInt(value);
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_idp_response_timeout: {0}", this.m_idp_response_timeout);
                break;
            }
            default: {
                super.addParameter(key, value);
            }
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return this.m_login_url != null ? this.m_login_url : "";
    }

    private String authenticate() throws IOException {
        RequestHandler requestHandler = new RequestHandler(new Function<List<NameValuePair>, Object>(){

            @Override
            public Object apply(List<NameValuePair> nameValuePairs) {
                if (RedshiftLogger.isEnable()) {
                    for (NameValuePair pair : nameValuePairs) {
                        if (pair.getName().equals(BrowserSamlCredentialsProvider.SAML_RESPONSE_PARAM_NAME)) {
                            BrowserSamlCredentialsProvider.this.m_log.logDebug("nameValuePair:name= {0}", BrowserSamlCredentialsProvider.SAML_RESPONSE_PARAM_NAME);
                            continue;
                        }
                        BrowserSamlCredentialsProvider.this.m_log.logDebug("nameValuePair: {0}", pair);
                    }
                }
                return ResponseUtils.findParameter(BrowserSamlCredentialsProvider.SAML_RESPONSE_PARAM_NAME, nameValuePairs);
            }
        });
        Server server = new Server(this.m_listen_port, requestHandler, Duration.ofSeconds(this.m_idp_response_timeout), this.m_log);
        server.listen();
        if (RedshiftLogger.isEnable()) {
            this.m_log.log(LogLevel.DEBUG, String.format("Listening for connection on port %d", this.m_listen_port), new Object[0]);
        }
        try {
            this.openBrowser();
            server.waitForResult();
        }
        catch (IOException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(ex);
            }
            server.stop();
            throw ex;
        }
        server.waitForResult();
        Object result = requestHandler.getResult();
        if (result instanceof InternalPluginException) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("Error occurred while fetching SAML assertion: {0}", result);
            }
            throw (InternalPluginException)result;
        }
        if (result instanceof String) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.DEBUG, "Got SAML assertion of length={0}", ((String)result).length());
            }
            return (String)result;
        }
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("result: {0}", result);
        }
        throw new InternalPluginException("Fail to login during timeout.");
    }

    private void openBrowser() throws IOException {
        URI authorizeRequestUrl = URI.create(this.m_login_url);
        if (RedshiftLogger.isEnable()) {
            this.m_log.log(LogLevel.DEBUG, String.format("SSO URI: \n%s", authorizeRequestUrl.toString()), new Object[0]);
        }
        Desktop.getDesktop().browse(authorizeRequestUrl);
    }
}

