/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.object;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorBuiltins;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetBuiltins;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRepr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSetAttr;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.DeleteDictNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PythonObject})
public final class ObjectBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ObjectBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ObjectBuiltinsFactory.getFactories();
    }

    @Builtin(name="__getstate__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetStateNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getstate(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached ObjectNodes.ObjectGetStateDefaultNode getstateDefaultNode) {
            return getstateDefaultNode.execute(frame, inliningTarget, self, false);
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1, doc="__dir__ for generic objects\n\n\tReturns __dict__, __class__ and recursively up the\n\t__class__.__bases__ chain.")
    @GenerateNodeFactory
    public static abstract class DirNode
    extends PythonBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object dir(VirtualFrame frame, Object obj, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached SetBuiltins.UpdateSingleNode updateSetNode, @Cached PyObjectLookupAttr lookupAttrNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached ListNodes.ConstructListNode constructListNode, @Bind PythonLanguage language) {
            Object klass;
            PSet names = PFactory.createSet(language);
            Object ns = lookupAttrNode.execute((Frame)frame, inliningTarget, obj, SpecialAttributeNames.T___DICT__);
            if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, ns), (Object)PythonBuiltinClassType.PDict)) {
                updateSetNode.execute(frame, names, ns);
            }
            if ((klass = lookupAttrNode.execute((Frame)frame, inliningTarget, obj, SpecialAttributeNames.T___CLASS__)) != PNone.NO_VALUE) {
                Object state = ExecutionContext.IndirectCallContext.enter(frame, inliningTarget, indirectCallData);
                try {
                    TypeBuiltins.DirNode.dir(names, klass);
                }
                finally {
                    ExecutionContext.IndirectCallContext.exit(frame, inliningTarget, indirectCallData, state);
                }
            }
            return constructListNode.execute((Frame)frame, names);
        }
    }

    @Builtin(name="__reduce_ex__", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "protocol"})
    @ArgumentClinic(name="protocol", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    public static abstract class ReduceExNode
    extends PythonClinicBuiltinNode {
        static final Object REDUCE_FACTORY = ObjectBuiltinsFactory.ReduceNodeFactory.getInstance();

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ObjectBuiltinsClinicProviders.ReduceExNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object doit(VirtualFrame frame, Object obj, int proto, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookupAttr, @Cached CallNode callNode, @Cached InlinedConditionProfile reduceProfile, @Cached ObjectNodes.CommonReduceNode commonReduceNode) {
            Object _reduce = lookupAttr.execute((Frame)frame, inliningTarget, obj, SpecialMethodNames.T___REDUCE__);
            if (reduceProfile.profile(inliningTarget, _reduce != PNone.NO_VALUE) && (!(_reduce instanceof PBuiltinMethod) || ((PBuiltinMethod)_reduce).getBuiltinFunction().getBuiltinNodeFactory() != REDUCE_FACTORY)) {
                return callNode.execute((Frame)frame, _reduce, new Object[0]);
            }
            return commonReduceNode.execute(frame, inliningTarget, obj, proto);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonBuiltinNode {
        @Specialization
        static Object doit(VirtualFrame frame, Object obj, Object ignored, @Bind Node inliningTarget, @Cached ObjectNodes.CommonReduceNode commonReduceNode) {
            return commonReduceNode.execute(frame, inliningTarget, obj, 0);
        }
    }

    @Builtin(name="__sizeof__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class SizeOfNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doit(VirtualFrame frame, Object obj, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectSizeNode sizeNode, @Cached PyObjectLookupAttr lookupAttr, @Cached TypeNodes.GetBasicSizeNode getBasicSizeNode, @Cached TypeNodes.GetItemSizeNode getItemSizeNode) {
            Object objLen;
            Object cls = getClassNode.execute(inliningTarget, obj);
            long size = 0L;
            long itemsize = getItemSizeNode.execute(inliningTarget, cls);
            if (itemsize != 0L && (objLen = lookupAttr.execute((Frame)frame, inliningTarget, obj, SpecialMethodNames.T___LEN__)) != PNone.NO_VALUE) {
                size = (long)sizeNode.execute((Frame)frame, inliningTarget, obj) * itemsize;
            }
            return size += getBasicSizeNode.execute(inliningTarget, cls);
        }
    }

    @Builtin(name="__subclasshook__", minNumOfPositionalArgs=1, declaresExplicitSelf=true, takesVarArgs=true, takesVarKeywordArgs=true, isClassmethod=true)
    @GenerateNodeFactory
    static abstract class SubclassHookNode
    extends PythonVarargsBuiltinNode {
        SubclassHookNode() {
        }

        @Specialization
        static Object notImplemented(Object self, Object[] arguments, PKeyword[] keywords) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__init_subclass__", minNumOfPositionalArgs=1, isClassmethod=true)
    @GenerateNodeFactory
    static abstract class InitSubclass
    extends PythonUnaryBuiltinNode {
        InitSubclass() {
        }

        @Specialization
        static PNone initSubclass(Object self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="__format__", minNumOfPositionalArgs=2, parameterNames={"$self", "format_spec"})
    @ArgumentClinic(name="format_spec", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class FormatNode
    extends PythonBinaryClinicBuiltinNode {
        FormatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ObjectBuiltinsClinicProviders.FormatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        static Object format(Object self, TruffleString formatString, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_FORMAT_STRING_PASSED_TO_P_FORMAT, self);
        }

        @Specialization(guards={"formatString.isEmpty()"})
        static Object format(VirtualFrame frame, Object self, TruffleString formatString, @Bind Node inliningTarget, @Cached PyObjectStrAsObjectNode str) {
            return str.execute((Frame)frame, inliningTarget, self);
        }
    }

    @Builtin(name="__dict__", autoRegister=false, minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class DictNode
    extends PythonBinaryBuiltinNode {
        protected static boolean isExactObject(Node inliningTarget, BuiltinClassProfiles.IsBuiltinClassExactProfile profile, Object clazz) {
            return profile.profileClass(inliningTarget, clazz, PythonBuiltinClassType.PythonObject);
        }

        protected static boolean isAnyBuiltinButModule(Node inliningTarget, BuiltinClassProfiles.IsOtherBuiltinClassProfile profile, Object clazz) {
            return profile.profileIsOtherBuiltinClass(inliningTarget, clazz, PythonBuiltinClassType.PythonModule);
        }

        @Specialization(guards={"!isAnyBuiltinButModule(inliningTarget, otherBuiltinClassProfile, selfClass)", "!isExactObject(inliningTarget, isBuiltinClassProfile, selfClass)", "isNoValue(none)"}, limit="1")
        static Object dict(VirtualFrame frame, Object self, PNone none, @Bind Node inliningTarget, @Cached.Exclusive @Cached BuiltinClassProfiles.IsOtherBuiltinClassProfile otherBuiltinClassProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isBuiltinClassProfile, @Cached.Exclusive @Cached GetClassNode getClassNode, @Bind(value="getClassNode.execute(inliningTarget, self)") Object selfClass, @Cached.Exclusive @Cached TypeNodes.GetBaseClassNode getBaseNode, @Cached(value="createForLookupOfUnmanagedClasses(T___DICT__)") @Cached.Shared LookupAttributeInMRONode getDescrNode, @Cached DescriptorBuiltins.DescrGetNode getNode, @Cached GetOrCreateDictNode getDict, @Cached.Exclusive @Cached InlinedBranchProfile branchProfile) {
            Object func = DictNode.getDescrFromBuiltinBase(inliningTarget, selfClass, getBaseNode, getDescrNode);
            if (func != null) {
                branchProfile.enter(inliningTarget);
                return getNode.execute(frame, func, self);
            }
            return getDict.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isAnyBuiltinButModule(inliningTarget, otherBuiltinClassProfile, selfClass)", "!isExactObject(inliningTarget, isBuiltinClassProfile, selfClass)", "!isPythonModule(self)"}, limit="1")
        static Object dict(VirtualFrame frame, Object self, PDict dict, @Bind Node inliningTarget, @Cached.Exclusive @Cached BuiltinClassProfiles.IsOtherBuiltinClassProfile otherBuiltinClassProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isBuiltinClassProfile, @Cached.Exclusive @Cached GetClassNode getClassNode, @Bind(value="getClassNode.execute(inliningTarget, self)") Object selfClass, @Cached.Exclusive @Cached TypeNodes.GetBaseClassNode getBaseNode, @Cached.Shared @Cached(value="createForLookupOfUnmanagedClasses(T___DICT__)") LookupAttributeInMRONode getDescrNode, @Cached DescriptorBuiltins.DescrSetNode setNode, @Cached SetDictNode setDict, @Cached.Exclusive @Cached InlinedBranchProfile branchProfile) {
            Object func = DictNode.getDescrFromBuiltinBase(inliningTarget, getClassNode.execute(inliningTarget, self), getBaseNode, getDescrNode);
            if (func != null) {
                branchProfile.enter(inliningTarget);
                return setNode.execute(frame, func, self, dict);
            }
            setDict.execute(inliningTarget, self, dict);
            return PNone.NONE;
        }

        @Specialization
        static Object dict(VirtualFrame frame, PythonObject self, DescriptorDeleteMarker marker, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached TypeNodes.GetBaseClassNode getBaseNode, @Cached.Shared @Cached(value="createForLookupOfUnmanagedClasses(T___DICT__)") LookupAttributeInMRONode getDescrNode, @Cached DescriptorBuiltins.DescrDeleteNode deleteNode, @Cached DeleteDictNode deleteDictNode, @Cached.Exclusive @Cached InlinedBranchProfile branchProfile) {
            Object func = DictNode.getDescrFromBuiltinBase(inliningTarget, getClassNode.execute(inliningTarget, self), getBaseNode, getDescrNode);
            if (func != null) {
                branchProfile.enter(inliningTarget);
                return deleteNode.execute(frame, func, self);
            }
            deleteDictNode.execute(self);
            return PNone.NONE;
        }

        private static Object getDescrFromBuiltinBase(Node inliningTarget, Object type, TypeNodes.GetBaseClassNode getBaseNode, LookupAttributeInMRONode getDescrNode) {
            Object t = type;
            Object base = getBaseNode.execute(inliningTarget, t);
            while (base != null) {
                Object func;
                if (t instanceof PythonBuiltinClass && (func = getDescrNode.execute(t)) != PNone.NO_VALUE) {
                    return func;
                }
                t = base;
                base = getBaseNode.execute(inliningTarget, t);
            }
            return null;
        }

        @Specialization(guards={"!isNoValue(mapping)", "!isDict(mapping)", "!isDeleteMarker(mapping)"})
        static Object dict(Object self, Object mapping, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, mapping);
        }

        @Specialization(guards={"isFallback(self, mapping, inliningTarget, getClassNode, otherBuiltinClassProfile, isBuiltinClassProfile)"}, limit="1")
        static Object raise(Object self, Object mapping, @Bind Node inliningTarget, @Cached.Exclusive @Cached BuiltinClassProfiles.IsOtherBuiltinClassProfile otherBuiltinClassProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isBuiltinClassProfile, @Cached.Exclusive @Cached GetClassNode getClassNode) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, self, "__dict__");
        }

        static boolean isFallback(Object self, Object mapping, Node inliningTarget, GetClassNode getClassNode, BuiltinClassProfiles.IsOtherBuiltinClassProfile otherBuiltinClassProfile, BuiltinClassProfiles.IsBuiltinClassExactProfile isBuiltinClassProfile) {
            Object selfClass = getClassNode.execute(inliningTarget, self);
            boolean classFilter = !DictNode.isAnyBuiltinButModule(inliningTarget, otherBuiltinClassProfile, selfClass) && !DictNode.isExactObject(inliningTarget, isBuiltinClassProfile, selfClass);
            return !(classFilter && PGuards.isNoValue(mapping) || classFilter && !PGuards.isPythonModule(self) && PGuards.isDict(mapping) || PGuards.isPythonObject(self) && PGuards.isDeleteMarker(mapping) || !PGuards.isNoValue(mapping) && !PGuards.isDict(mapping) && !PGuards.isDeleteMarker(mapping));
        }

        @NeverDefault
        public static DictNode create() {
            return ObjectBuiltinsFactory.DictNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.tp_setattro, isComplex=true)
    @GenerateNodeFactory
    public static abstract class SetattrNode
    extends TpSlotSetAttr.SetAttrBuiltinNode {
        @Specialization
        void setString(VirtualFrame frame, Object object, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached ObjectNodes.GenericSetAttrNode genericSetAttrNode, @Cached.Shared @Cached WriteAttributeToObjectNode write) {
            genericSetAttrNode.execute(inliningTarget, frame, object, key, value, write);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        void setGeneric(VirtualFrame frame, Object object, Object key, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached ObjectNodes.GenericSetAttrNode genericSetAttrNode, @Cached.Shared @Cached WriteAttributeToObjectNode write) {
            genericSetAttrNode.execute(inliningTarget, frame, object, key, value, write);
        }

        @NeverDefault
        public static SetattrNode create() {
            return ObjectBuiltinsFactory.SetattrNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class GetAttributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        @CompilerDirectives.CompilationFinal
        private int profileFlags = 0;
        private static final int HAS_DESCR = 1;
        private static final int HAS_VALUE = 2;
        private static final int HAS_NO_VALUE = 4;
        @Node.Child
        private TpSlotDescrGet.CallSlotDescrGet callSlotDescrGet;
        @Node.Child
        private ReadAttributeFromObjectNode attrRead;

        @Idempotent
        protected static int tsLen(TruffleString ts) {
            CompilerAsserts.neverPartOfCompilation();
            return TruffleString.CodePointLengthNode.getUncached().execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING) + 1;
        }

        @Specialization(guards={"keyObj == cachedKey", "tsLen(cachedKey) < 32"}, limit="1")
        Object doItTruffleString(VirtualFrame frame, Object object, TruffleString keyObj, @Bind Node inliningTarget, @Cached(value="keyObj") TruffleString cachedKey, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached(value="create(cachedKey)") LookupAttributeInMRONode lookup, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object type = getClassNode.execute(inliningTarget, object);
            Object descr = lookup.execute(type);
            return this.fullLookup(frame, inliningTarget, object, cachedKey, type, descr, getSlotsNode, raiseNode);
        }

        @Specialization
        Object doIt(VirtualFrame frame, Object object, Object keyObj, @Bind Node inliningTarget, @Cached LookupAttributeInMRONode.Dynamic lookup, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            TruffleString key;
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObj);
            }
            Object type = getClassNode.execute(inliningTarget, object);
            Object descr = lookup.execute(type, key);
            return this.fullLookup(frame, inliningTarget, object, key, type, descr, getSlotsNode, raiseNode);
        }

        private Object fullLookup(VirtualFrame frame, Node inliningTarget, Object object, TruffleString key, Object type, Object descr, TpSlots.GetObjectSlotsNode getSlotsNode, PRaiseNode raiseNode) {
            boolean hasValue;
            TpSlots descrSlots;
            boolean hasDescr;
            boolean bl = hasDescr = descr != PNone.NO_VALUE;
            if (hasDescr && (this.profileFlags & 1) == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.profileFlags |= 1;
            }
            TpSlot descrGetSlot = null;
            if (hasDescr && (descrGetSlot = (descrSlots = getSlotsNode.execute(inliningTarget, descr)).tp_descr_get()) != null && TpSlotDescrSet.PyDescr_IsData(descrSlots)) {
                return this.dispatch(frame, object, type, descr, descrGetSlot);
            }
            Object value = this.readAttribute(object, key);
            boolean bl2 = hasValue = value != PNone.NO_VALUE;
            if (hasValue && (this.profileFlags & 2) == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.profileFlags |= 2;
            }
            if (hasValue) {
                return value;
            }
            if ((this.profileFlags & 4) == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.profileFlags |= 4;
            }
            if (hasDescr) {
                if (descrGetSlot == null) {
                    return descr;
                }
                return this.dispatch(frame, object, type, descr, descrGetSlot);
            }
            throw raiseNode.raiseAttributeError(inliningTarget, object, key);
        }

        private Object readAttribute(Object object, TruffleString key) {
            if (this.attrRead == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.attrRead = (ReadAttributeFromObjectNode)this.insert(ReadAttributeFromObjectNode.create());
            }
            return this.attrRead.execute(object, key);
        }

        private Object dispatch(VirtualFrame frame, Object object, Object type, Object descr, TpSlot getSlot) {
            if (this.callSlotDescrGet == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callSlotDescrGet = (TpSlotDescrGet.CallSlotDescrGet)this.insert(TpSlotDescrGet.CallSlotDescrGet.create());
            }
            return this.callSlotDescrGet.executeCached(frame, getSlot, descr, object, type);
        }

        @NeverDefault
        public static GetAttributeNode create() {
            return ObjectBuiltinsFactory.GetAttributeNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization(guards={"isNone(self)"})
        static TruffleString reprNone(PNone self) {
            return StringLiterals.T_NONE;
        }

        @Specialization(guards={"!isNone(self)"})
        static TruffleString repr(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached ObjectNodes.DefaultObjectReprNode defaultReprNode) {
            return defaultReprNode.execute((Frame)frame, inliningTarget, self);
        }
    }

    @Slot(value=Slot.SlotKind.tp_str, isComplex=true)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        StrNode() {
        }

        @Specialization
        static Object str(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotRepr.CallSlotReprNode callSlot, @Cached ObjectNodes.DefaultObjectReprNode defaultRepr) {
            TpSlots slots = getSlots.execute(inliningTarget, self);
            if (slots.tp_repr() != null) {
                return callSlot.execute(frame, inliningTarget, slots.tp_repr(), self);
            }
            return defaultRepr.execute((Frame)frame, inliningTarget, self);
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization(guards={"op.isEq()"})
        static Object eq(Object self, Object other, RichCmpOp op, @Bind Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile isEq, @Cached IsNode isNode) {
            if (isEq.profile(inliningTarget, isNode.execute(self, other))) {
                return true;
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization(guards={"op.isNe()"})
        static Object ne(VirtualFrame frame, Object self, Object other, RichCmpOp op, @Bind Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile isEq, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached TpSlotRichCompare.CallSlotRichCmpNode callSlotRichCmp, @Cached PyObjectIsTrueNode isTrueNode) {
            TpSlot selfRichCmp = getSlotsNode.execute(inliningTarget, self).tp_richcmp();
            if (selfRichCmp == null) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            Object result = callSlotRichCmp.execute(frame, inliningTarget, selfRichCmp, self, other, RichCmpOp.Py_EQ);
            if (result != PNotImplemented.NOT_IMPLEMENTED) {
                return !isTrueNode.execute((Frame)frame, result);
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Fallback
        static Object doOthers(Object self, Object other, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        @Specialization
        public long hash(PythonBuiltinClassType self) {
            return HashNode.hash(this.getContext().lookupType(self));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isPythonBuiltinClassType(self)"})
        public static long hash(Object self) {
            return self.hashCode();
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(takesVarArgs=true, minNumOfPositionalArgs=1, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        @Specialization(guards={"arguments.length == 0", "keywords.length == 0"})
        static PNone initNoArgs(Object self, Object[] arguments, PKeyword[] keywords) {
            return PNone.NONE;
        }

        @Specialization(replaces={"initNoArgs"})
        static PNone init(Object self, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached PRaiseNode raiseNode) {
            if (arguments.length != 0 || keywords.length != 0) {
                Object type = getClassNode.execute(inliningTarget, self);
                TpSlots slots = getSlots.execute(inliningTarget, type);
                if (slots.tp_init() != SLOTS.tp_init()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INIT_TAKES_ONE_ARG_OBJECT);
                }
                if (slots.tp_new() == SLOTS.tp_new()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INIT_TAKES_ONE_ARG, type);
                }
            }
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="object", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class ObjectNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private ReportAbstractClassNode reportAbstractClassNode;

        @Specialization(guards={"!self.needsNativeAllocation()"})
        Object doManagedObject(VirtualFrame frame, PythonManagedClass self, Object[] varargs, PKeyword[] kwargs, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached CheckExcessArgsNode checkExcessArgsNode, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            checkExcessArgsNode.execute(inliningTarget, self, varargs, kwargs);
            if (self.isAbstractClass()) {
                throw this.reportAbstractClass(frame, self);
            }
            return PFactory.createPythonObject(language, self, getInstanceShape.execute(self));
        }

        @Specialization
        static Object doBuiltinTypeType(PythonBuiltinClassType self, Object[] varargs, PKeyword[] kwargs, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared @Cached CheckExcessArgsNode checkExcessArgsNode, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            checkExcessArgsNode.execute(inliningTarget, (Object)self, varargs, kwargs);
            return PFactory.createPythonObject(language, (Object)self, getInstanceShape.execute((Object)self));
        }

        @Specialization(guards={"self.needsNativeAllocation()"})
        @HostCompilerDirectives.InliningCutoff
        Object doNativeObjectIndirect(VirtualFrame frame, PythonManagedClass self, Object[] varargs, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached.Shared @Cached CheckExcessArgsNode checkExcessArgsNode, @Cached.Shared @Cached CallNativeGenericNewNode callNativeGenericNewNode) {
            checkExcessArgsNode.execute(inliningTarget, self, varargs, kwargs);
            if (self.isAbstractClass()) {
                throw this.reportAbstractClass(frame, self);
            }
            return callNativeGenericNewNode.execute(inliningTarget, self);
        }

        @Specialization(guards={"isNativeClass(self)"})
        @HostCompilerDirectives.InliningCutoff
        Object doNativeObjectDirect(VirtualFrame frame, Object self, Object[] varargs, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached.Shared @Cached CheckExcessArgsNode checkExcessArgsNode, @Cached.Exclusive @Cached TypeNodes.GetTypeFlagsNode getTypeFlagsNode, @Cached.Shared @Cached CallNativeGenericNewNode callNativeGenericNewNode) {
            checkExcessArgsNode.execute(inliningTarget, self, varargs, kwargs);
            if ((getTypeFlagsNode.execute(self) & 0x100000L) != 0L) {
                throw this.reportAbstractClass(frame, self);
            }
            return callNativeGenericNewNode.execute(inliningTarget, self);
        }

        @Fallback
        Object fallback(Object o, Object[] varargs, PKeyword[] kwargs) {
            throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "object.__new__(X): X", o);
        }

        @HostCompilerDirectives.InliningCutoff
        private PException reportAbstractClass(VirtualFrame frame, Object type) {
            if (this.reportAbstractClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportAbstractClassNode = (ReportAbstractClassNode)this.insert(ObjectBuiltinsFactory.ObjectNodeFactory.ReportAbstractClassNodeGen.create());
            }
            return this.reportAbstractClassNode.execute(frame, type);
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class CheckExcessArgsNode
        extends Node {
            CheckExcessArgsNode() {
            }

            abstract void execute(Node var1, Object var2, Object[] var3, PKeyword[] var4);

            @Specialization(guards={"args.length == 0", "kwargs.length == 0"})
            static void doNothing(Object type, Object[] args, PKeyword[] kwargs) {
            }

            @Fallback
            static void check(Node inliningTarget, Object type, Object[] args, PKeyword[] kwargs, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached PRaiseNode raiseNode) {
                TpSlots slots = getSlots.execute(inliningTarget, type);
                if (slots.tp_new() != SLOTS.tp_new()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.NEW_TAKES_ONE_ARG);
                }
                if (slots.tp_init() == SLOTS.tp_init()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.NEW_TAKES_NO_ARGS, type);
                }
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        protected static abstract class CallNativeGenericNewNode
        extends Node {
            protected CallNativeGenericNewNode() {
            }

            abstract Object execute(Node var1, Object var2);

            @Specialization
            static Object call(Object cls, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached(inline=false) CExtNodes.PCallCapiFunction callCapiFunction) {
                return toPythonNode.execute(callCapiFunction.call(NativeCAPISymbol.FUN_PY_OBJECT_NEW, toNativeNode.execute(cls)));
            }
        }

        @GenerateInline(value=false)
        static abstract class ReportAbstractClassNode
        extends PNodeWithContext {
            ReportAbstractClassNode() {
            }

            public abstract PException execute(VirtualFrame var1, Object var2);

            @Specialization
            static PException report(VirtualFrame frame, Object type, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callSort, @Cached PyObjectCallMethodObjArgs callJoin, @Cached PyObjectSizeNode sizeNode, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CastToTruffleStringNode cast, @Cached ListNodes.ConstructListNode constructListNode, @Cached PRaiseNode raiseNode) {
                PList list = constructListNode.execute((Frame)frame, readAttributeFromObjectNode.execute(type, SpecialAttributeNames.T___ABSTRACTMETHODS__));
                int methodCount = sizeNode.execute((Frame)frame, inliningTarget, list);
                callSort.execute((Frame)frame, inliningTarget, list, SpecialMethodNames.T_SORT, new Object[0]);
                TruffleString joined = cast.execute(inliningTarget, callJoin.execute((Frame)frame, inliningTarget, StringLiterals.T_SINGLE_QUOTE_COMMA_SPACE, SpecialMethodNames.T_JOIN, list));
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_INSTANTIATE_ABSTRACT_CLASS_WITH_ABSTRACT_METHODS, type, methodCount > 1 ? "s" : "", joined);
            }
        }
    }

    @Builtin(name="__class__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class ClassNode
    extends PythonBinaryBuiltinNode {
        ClassNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object getClass(Object self, PNone value, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode) {
            return getClassNode.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static PNone setClass(VirtualFrame frame, Object self, Object value, @Bind Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached BuiltinClassProfiles.IsBuiltinClassProfile isModuleProfile, @Cached TypeNodes.GetTypeFlagsNode getTypeFlagsNode, @Cached TypeNodes.CheckCompatibleForAssigmentNode checkCompatibleForAssigmentNode, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached SetClassNode setClassNode, @Cached PRaiseNode raiseNode) {
            boolean bothMutable;
            if (!isTypeNode.execute(inliningTarget, value)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CLASS_MUST_BE_SET_TO_CLASS, value);
            }
            Object type = getClassNode.execute(inliningTarget, self);
            boolean bothModuleSubtypes = isModuleProfile.profileClass(inliningTarget, type, PythonBuiltinClassType.PythonModule) && isModuleProfile.profileClass(inliningTarget, value, PythonBuiltinClassType.PythonModule);
            boolean bl = bothMutable = (getTypeFlagsNode.execute(type) & 0x100L) == 0L && (getTypeFlagsNode.execute(value) & 0x100L) == 0L;
            if (!bothModuleSubtypes && !bothMutable) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CLASS_ASSIGNMENT_ONLY_SUPPORTED_FOR_HEAP_TYPES_OR_MODTYPE_SUBCLASSES);
            }
            checkCompatibleForAssigmentNode.execute(frame, type, value);
            setClassNode.execute(inliningTarget, self, value);
            return PNone.NONE;
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class SetClassNode
        extends Node {
            SetClassNode() {
            }

            public abstract void execute(Node var1, Object var2, Object var3);

            @Specialization
            static void doPythonObject(Node inliningTarget, PythonObject self, Object newClass, @Cached HiddenAttr.WriteNode writeHiddenAttrNode) {
                writeHiddenAttrNode.execute(inliningTarget, self, HiddenAttr.CLASS, newClass);
            }

            @Specialization
            static void doNative(PythonAbstractNativeObject self, Object newClass, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode writeObjectNewRefNode) {
                writeObjectNewRefNode.writeToObject(self, CFields.PyObject__ob_type, newClass);
            }
        }
    }
}

