/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.set;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.set.BaseSetBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.set.BaseSetBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetStateNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSet, PythonBuiltinClassType.PFrozenSet})
public final class BaseSetBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = BaseSetBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BaseSetBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    protected static abstract class ConvertKeyNode
    extends PNodeWithContext {
        protected ConvertKeyNode() {
        }

        public abstract Object execute(Node var1, Object var2);

        @Specialization(guards={"!isPSet(key)"})
        static Object doNotPSet(Object key) {
            return key;
        }

        @Specialization
        static Object doPSet(Node inliningTarget, PSet key, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached TpSlots.GetObjectSlotsNode getSlotsNode) {
            TpSlots slots = getSlotsNode.execute(inliningTarget, key);
            if (slots.tp_hash() == null || slots.tp_hash() == TpSlotHashFun.HASH_NOT_IMPLEMENTED) {
                return PFactory.createFrozenSet(PythonLanguage.get(inliningTarget), copyNode.execute(inliningTarget, key.getDictStorage()));
            }
            return key;
        }
    }

    @Builtin(name="isdisjoint", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseIsDisjointNode
    extends PythonBinaryBuiltinNode {
        protected BaseIsDisjointNode() {
        }

        @Specialization(guards={"self == other"})
        static boolean isDisjointSameObject(PBaseSet self, PBaseSet other, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, self.getDictStorage()) == 0;
        }

        @Specialization(guards={"self != other", "isBuiltinAnySet(other)"})
        static boolean isDisjointFastPath(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageAreDisjoint disjointNode) {
            return disjointNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), other.getDictStorage());
        }

        @Fallback
        static boolean isDisjointGeneric(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getHashingStorageItem, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode) {
            Object nextValue;
            HashingStorage selfStorage = ((PBaseSet)self).getDictStorage();
            Object iterator = getIter.execute((Frame)frame, inliningTarget, other);
            do {
                try {
                    nextValue = nextNode.execute((Frame)frame, inliningTarget, iterator);
                }
                catch (IteratorExhausted e) {
                    return true;
                }
            } while (!getHashingStorageItem.hasKey((Frame)frame, inliningTarget, selfStorage, nextValue));
            return false;
        }
    }

    @Builtin(name="issuperset", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseIsSupersetNode
    extends PythonBinaryBuiltinNode {
        protected BaseIsSupersetNode() {
        }

        @Specialization
        static boolean isSuperSetGeneric(VirtualFrame frame, PBaseSet self, Object other, @Bind Node inliningTarget, @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached HashingStorageNodes.IsKeysSubset compareKeys) {
            HashingStorage otherStorage = getSetStorageNode.execute(frame, inliningTarget, other);
            return compareKeys.execute((Frame)frame, inliningTarget, otherStorage, self.getDictStorage());
        }
    }

    @Builtin(name="issubset", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseIsSubsetNode
    extends PythonBinaryBuiltinNode {
        protected BaseIsSubsetNode() {
        }

        @Specialization
        static boolean isSubSetGeneric(VirtualFrame frame, PBaseSet self, Object other, @Bind Node inliningTarget, @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached HashingStorageNodes.IsKeysSubset compareKeys) {
            HashingStorage otherStorage = getSetStorageNode.execute(frame, inliningTarget, other);
            return compareKeys.execute((Frame)frame, inliningTarget, self.getDictStorage(), otherStorage);
        }
    }

    @Slot(value=Slot.SlotKind.nb_xor, isComplex=true)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class XorNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        @Specialization
        static Object doSet(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageXor xorNode, @Cached CreateSetNode createSetNode) {
            HashingStorage storage = xorNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), other.getDictStorage());
            return createSetNode.execute(inliningTarget, storage, self);
        }

        @Fallback
        Object doOther(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    public static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        @Specialization
        static Object doSet(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCopy copyStorage, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached CreateSetNode createSetNode) {
            HashingStorage resultStorage = copyStorage.execute(inliningTarget, self.getDictStorage());
            resultStorage = addAllToOther.execute((Frame)frame, inliningTarget, other.getDictStorage(), resultStorage);
            return createSetNode.execute(inliningTarget, resultStorage, self);
        }

        @Fallback
        Object doOther(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.nb_and, isComplex=true)
    @GenerateNodeFactory
    public static abstract class AndNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        @Specialization
        static PBaseSet doPBaseSet(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached InlinedConditionProfile swapProfile, @Cached CreateSetNode createSetNode) {
            HashingStorage storage1 = self.getDictStorage();
            HashingStorage storage2 = other.getDictStorage();
            if (swapProfile.profile(inliningTarget, lenNode.execute(inliningTarget, storage2) > lenNode.execute(inliningTarget, storage1))) {
                HashingStorage tmp = storage1;
                storage1 = storage2;
                storage2 = tmp;
            }
            HashingStorage storage = intersectNode.execute((Frame)frame, inliningTarget, storage2, storage1);
            return createSetNode.execute(inliningTarget, storage, self);
        }

        @Fallback
        Object doOther(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.nb_subtract, isComplex=true)
    @GenerateNodeFactory
    static abstract class SubNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        SubNode() {
        }

        @Specialization
        static PBaseSet doPBaseSet(VirtualFrame frame, PBaseSet left, PBaseSet right, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Cached CreateSetNode createSetNode) {
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, left.getDictStorage(), right.getDictStorage());
            return createSetNode.execute(inliningTarget, storage, left);
        }

        @Fallback
        static Object doOther(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CreateSetNode
    extends Node {
        CreateSetNode() {
        }

        public abstract PBaseSet execute(Node var1, HashingStorage var2, PBaseSet var3);

        @Specialization
        static PBaseSet doSet(HashingStorage storage, PSet template, @Bind PythonLanguage language) {
            return PFactory.createSet(language, storage);
        }

        @Specialization
        static PBaseSet doFrozenSet(HashingStorage storage, PFrozenSet template, @Bind PythonLanguage language) {
            return PFactory.createFrozenSet(language, storage);
        }
    }

    @Slot(value=Slot.SlotKind.sq_contains, isComplex=true)
    @GenerateNodeFactory
    protected static abstract class BaseContainsNode
    extends TpSlotSqContains.SqContainsBuiltinNode {
        protected BaseContainsNode() {
        }

        @Specialization
        static boolean contains(VirtualFrame frame, PBaseSet self, Object key, @Bind Node inliningTarget, @Cached ConvertKeyNode conv, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            return getItem.hasKey((Frame)frame, inliningTarget, self.getDictStorage(), conv.execute(inliningTarget, key));
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    protected static abstract class BaseSetRichCmpNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        protected BaseSetRichCmpNode() {
        }

        static boolean lengthsMismatch(int len1, int len2, RichCmpOp op) {
            return switch (op) {
                default -> throw new IncompatibleClassChangeError();
                case RichCmpOp.Py_EQ -> {
                    if (len1 != len2) {
                        yield true;
                    }
                    yield false;
                }
                case RichCmpOp.Py_LT -> {
                    if (len1 >= len2) {
                        yield true;
                    }
                    yield false;
                }
                case RichCmpOp.Py_GT -> {
                    if (len1 <= len2) {
                        yield true;
                    }
                    yield false;
                }
                case RichCmpOp.Py_LE -> {
                    if (len1 > len2) {
                        yield true;
                    }
                    yield false;
                }
                case RichCmpOp.Py_GE -> {
                    if (len1 < len2) {
                        yield true;
                    }
                    yield false;
                }
                case RichCmpOp.Py_NE -> throw CompilerDirectives.shouldNotReachHere();
            };
        }

        @Specialization
        static Object doIt(VirtualFrame frame, PBaseSet self, PBaseSet other, RichCmpOp opIn, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenSelfNode, @Cached HashingStorageNodes.HashingStorageLen lenOtherNode, @Cached InlinedConditionProfile sizeProfile, @Cached HashingStorageNodes.IsKeysSubset issubsetNode) {
            PBaseSet right;
            PBaseSet left;
            int len2;
            int len1;
            boolean wasNe = opIn.isNe();
            RichCmpOp op = opIn;
            if (wasNe) {
                op = RichCmpOp.Py_EQ;
            }
            if (sizeProfile.profile(inliningTarget, BaseSetRichCmpNode.lengthsMismatch(len1 = lenSelfNode.execute(inliningTarget, self.getDictStorage()), len2 = lenOtherNode.execute(inliningTarget, other.getDictStorage()), op))) {
                return wasNe;
            }
            if (op.isEq() || op.isLe() || op.isLt()) {
                left = self;
                right = other;
            } else {
                left = other;
                right = self;
            }
            boolean result = issubsetNode.execute((Frame)frame, inliningTarget, left.getDictStorage(), right.getDictStorage());
            if (wasNe) {
                return !result;
            }
            return result;
        }

        @Fallback
        static PNotImplemented doGeneric(Object self, Object other, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class BaseReduceNode
    extends PythonUnaryBuiltinNode {
        protected BaseReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PBaseSet self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey getIterKey, @Cached GetClassNode getClassNode, @Cached PyObjectGetStateNode getStateNode, @Bind PythonLanguage language) {
            HashingStorage storage = self.getDictStorage();
            int len = lenNode.execute(inliningTarget, storage);
            Object[] keysArray = new Object[len];
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, storage);
            for (int i = 0; i < len; ++i) {
                boolean hasNext = iterNext.execute(inliningTarget, storage, it);
                assert (hasNext);
                keysArray[i] = getIterKey.execute(inliningTarget, storage, it);
            }
            PTuple contents = PFactory.createTuple(language, new Object[]{PFactory.createList(language, keysArray)});
            Object state = getStateNode.execute(frame, inliningTarget, self);
            return PFactory.createTuple(language, new Object[]{getClassNode.execute(inliningTarget, self), contents, state});
        }
    }

    @Slot(value=Slot.SlotKind.sq_length)
    @GenerateUncached
    @GenerateNodeFactory
    protected static abstract class BaseSetLenSlotNode
    extends TpSlotLen.LenBuiltinNode {
        protected BaseSetLenSlotNode() {
        }

        @Specialization
        public static int len(PBaseSet self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, self.getDictStorage());
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    protected static abstract class BaseIterNode
    extends PythonUnaryBuiltinNode {
        protected BaseIterNode() {
        }

        @Specialization
        static Object doBaseSet(PBaseSet self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Bind PythonLanguage language) {
            HashingStorage storage = self.getDictStorage();
            return PFactory.createBaseSetIterator(language, self, getIterator.execute(inliningTarget, storage), lenNode.execute(inliningTarget, storage));
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class BaseReprNode
    extends PythonUnaryBuiltinNode {
        BaseReprNode() {
        }

        private static void fillItems(VirtualFrame frame, Node inliningTarget, HashingStorage storage, TruffleStringBuilder sb, PyObjectReprAsTruffleStringNode repr, HashingStorageNodes.HashingStorageGetIterator getIter, HashingStorageNodes.HashingStorageIteratorNext iterNext, HashingStorageNodes.HashingStorageIteratorKey iterKey, TruffleStringBuilder.AppendStringNode appendStringNode) {
            boolean first = true;
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LBRACE);
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, storage);
            while (iterNext.execute(inliningTarget, storage, it)) {
                if (first) {
                    first = false;
                } else {
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                }
                appendStringNode.execute(sb, (AbstractTruffleString)repr.execute((Frame)frame, inliningTarget, iterKey.execute(inliningTarget, storage, it)));
            }
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RBRACE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public static Object repr(VirtualFrame frame, PBaseSet self, @Bind Node inliningTarget, @Cached PyObjectReprAsTruffleStringNode repr, @Cached TypeNodes.GetNameNode getNameNode, @Cached GetClassNode getClassNode, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getStorageIterator, @Cached HashingStorageNodes.HashingStorageIteratorNext iteratorNext, @Cached HashingStorageNodes.HashingStorageIteratorKey iteratorKey, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            Object clazz = getClassNode.execute(inliningTarget, self);
            PythonContext ctxt = PythonContext.get(getNameNode);
            int len = lenNode.execute(inliningTarget, self.getDictStorage());
            if (len == 0) {
                appendStringNode.execute(sb, (AbstractTruffleString)getNameNode.execute(inliningTarget, clazz));
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_EMPTY_PARENS);
                return toStringNode.execute(sb);
            }
            if (!ctxt.reprEnter(self)) {
                appendStringNode.execute(sb, (AbstractTruffleString)getNameNode.execute(inliningTarget, clazz));
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_ELLIPSIS_IN_PARENS);
                return toStringNode.execute(sb);
            }
            try {
                boolean showType;
                boolean bl = showType = clazz != PythonBuiltinClassType.PSet;
                if (showType) {
                    appendStringNode.execute(sb, (AbstractTruffleString)getNameNode.execute(inliningTarget, clazz));
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LPAREN);
                }
                BaseReprNode.fillItems(frame, inliningTarget, self.getDictStorage(), sb, repr, getStorageIterator, iteratorNext, iteratorKey, appendStringNode);
                if (showType) {
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RPAREN);
                }
                TruffleString truffleString = toStringNode.execute(sb);
                return truffleString;
            }
            finally {
                ctxt.reprLeave(self);
            }
        }
    }
}

