/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.object.CoreLocation;
import com.oracle.truffle.api.object.CoreLocations;
import com.oracle.truffle.api.object.DefaultLayout;
import com.oracle.truffle.api.object.Flags;
import com.oracle.truffle.api.object.LayoutImpl;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectStorageOptions;
import com.oracle.truffle.api.object.ShapeImpl;
import sun.misc.Unsafe;

class CoreAllocator
extends ShapeImpl.BaseAllocator {
    CoreAllocator(LayoutImpl layout) {
        super(layout);
    }

    CoreAllocator(ShapeImpl shape) {
        super(shape);
    }

    private DefaultLayout getLayout() {
        return (DefaultLayout)this.layout;
    }

    @Override
    public CoreLocation constantLocation(Object value) {
        return new CoreLocations.ConstantLocation(value);
    }

    @Override
    public CoreLocation declaredLocation(Object value) {
        return new CoreLocations.DeclaredLocation(value);
    }

    @Override
    protected Location moveLocation(Location oldLocation) {
        if (oldLocation instanceof CoreLocations.LongLocation) {
            CoreLocations.LongLocation longLocation = (CoreLocations.LongLocation)((Object)oldLocation);
            return this.newLongLocation(longLocation.isImplicitCastIntToLong());
        }
        if (oldLocation instanceof CoreLocations.IntLocation) {
            return this.newIntLocation();
        }
        if (oldLocation instanceof CoreLocations.DoubleLocation) {
            CoreLocations.DoubleLocation doubleLocation = (CoreLocations.DoubleLocation)((Object)oldLocation);
            return this.newDoubleLocation(doubleLocation.isImplicitCastIntToDouble());
        }
        if (oldLocation instanceof CoreLocations.BooleanLocation) {
            return this.newBooleanLocation();
        }
        if (oldLocation instanceof CoreLocations.ObjectLocation) {
            return this.newObjectLocation();
        }
        assert (oldLocation instanceof CoreLocations.ValueLocation) : oldLocation;
        return this.advance(oldLocation);
    }

    private Location newObjectLocation() {
        int insertPos;
        if (ObjectStorageOptions.InObjectFields && (insertPos = this.objectFieldSize) + 1 <= this.getLayout().getObjectFieldCount()) {
            return this.advance((Location)((Object)this.getLayout().getObjectFieldLocation(insertPos)));
        }
        return this.newObjectArrayLocation();
    }

    private Location newObjectArrayLocation() {
        return this.advance(new CoreLocations.ObjectArrayLocation(this.objectArraySize));
    }

    private Location newIntLocation() {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.IntegerLocations) {
            if (ObjectStorageOptions.InObjectFields && this.primitiveFieldSize + this.getLayout().getLongFieldSize() <= this.getLayout().getPrimitiveFieldCount()) {
                return this.advance(new CoreLocations.IntLocationDecorator(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize)));
            }
            if (this.getLayout().hasPrimitiveExtensionArray()) {
                int alignedIndex = CoreAllocator.alignArrayIndex(this.primitiveArraySize, 8);
                return this.advance(new CoreLocations.IntLocationDecorator(new CoreLocations.LongArrayLocation(alignedIndex)));
            }
        }
        return this.newObjectLocation();
    }

    private Location newDoubleLocation() {
        return this.newDoubleLocation(this.getLayout().isAllowedIntToDouble());
    }

    Location newDoubleLocation(boolean allowedIntToDouble) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.DoubleLocations) {
            if (ObjectStorageOptions.InObjectFields && this.primitiveFieldSize + this.getLayout().getLongFieldSize() <= this.getLayout().getPrimitiveFieldCount()) {
                return this.advance(new CoreLocations.DoubleLocationDecorator(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize), allowedIntToDouble));
            }
            if (this.getLayout().hasPrimitiveExtensionArray()) {
                int alignedIndex = CoreAllocator.alignArrayIndex(this.primitiveArraySize, 8);
                return this.advance(new CoreLocations.DoubleLocationDecorator(new CoreLocations.LongArrayLocation(alignedIndex), allowedIntToDouble));
            }
        }
        return this.newObjectLocation();
    }

    private Location newLongLocation() {
        return this.newLongLocation(this.getLayout().isAllowedIntToLong());
    }

    Location newLongLocation(boolean allowedIntToLong) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.LongLocations) {
            if (ObjectStorageOptions.InObjectFields && this.primitiveFieldSize + this.getLayout().getLongFieldSize() <= this.getLayout().getPrimitiveFieldCount()) {
                return this.advance((Location)((Object)CoreLocations.createLongLocation(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize), allowedIntToLong)));
            }
            if (this.getLayout().hasPrimitiveExtensionArray()) {
                int alignedIndex = CoreAllocator.alignArrayIndex(this.primitiveArraySize, 8);
                return this.advance(new CoreLocations.LongArrayLocation(alignedIndex, allowedIntToLong));
            }
        }
        return this.newObjectLocation();
    }

    private Location newBooleanLocation() {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.BooleanLocations && this.primitiveFieldSize + this.getLayout().getLongFieldSize() <= this.getLayout().getPrimitiveFieldCount()) {
            return this.advance(new CoreLocations.BooleanLocationDecorator(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize)));
        }
        return this.newObjectLocation();
    }

    @Override
    public Location locationForValue(Object value) {
        return this.locationForValue(value, 0);
    }

    Location locationForValue(Object value, int putFlags) {
        if (Flags.isConstant(putFlags)) {
            return this.constantLocation(value);
        }
        if (Flags.isDeclaration(putFlags)) {
            return this.declaredLocation(value);
        }
        if (value instanceof Integer) {
            return this.newIntLocation();
        }
        if (value instanceof Double) {
            return this.newDoubleLocation(Flags.isImplicitCastIntToDouble(putFlags) || this.layout.isAllowedIntToDouble());
        }
        if (value instanceof Long) {
            return this.newLongLocation(Flags.isImplicitCastIntToLong(putFlags) || this.layout.isAllowedIntToLong());
        }
        if (value instanceof Boolean) {
            return this.newBooleanLocation();
        }
        return this.newObjectLocation();
    }

    @Override
    public Location locationForType(Class<?> type) {
        if (type == Integer.TYPE) {
            return this.newIntLocation();
        }
        if (type == Double.TYPE) {
            return this.newDoubleLocation();
        }
        if (type == Long.TYPE) {
            return this.newLongLocation();
        }
        if (type == Boolean.TYPE) {
            return this.newBooleanLocation();
        }
        return this.newObjectLocation();
    }

    @Override
    protected Location locationForValueUpcast(Object value, Location oldLocation, int putFlags) {
        assert (!oldLocation.canStore(value));
        if (oldLocation instanceof CoreLocations.ConstantLocation && Flags.isConstant(putFlags)) {
            return this.constantLocation(value);
        }
        if (oldLocation instanceof CoreLocations.ValueLocation) {
            return this.locationForValue(value, putFlags);
        }
        if (oldLocation instanceof CoreLocations.TypedLocation && ((CoreLocations.TypedLocation)((Object)oldLocation)).getType().isPrimitive()) {
            if (!this.shared && ((CoreLocations.TypedLocation)((Object)oldLocation)).getType() == Integer.TYPE) {
                boolean allowedIntToDouble;
                CoreLocations.LongLocation primLocation = ((CoreLocations.PrimitiveLocationDecorator)oldLocation).getInternalLongLocation();
                boolean allowedIntToLong = this.layout.isAllowedIntToLong() || Flags.isImplicitCastIntToLong(putFlags);
                boolean bl = allowedIntToDouble = this.layout.isAllowedIntToDouble() || Flags.isImplicitCastIntToDouble(putFlags);
                if (allowedIntToLong && value instanceof Long) {
                    return new CoreLocations.LongLocationDecorator(primLocation, true);
                }
                if (allowedIntToDouble && value instanceof Double) {
                    return new CoreLocations.DoubleLocationDecorator(primLocation, true);
                }
            }
            return this.newObjectLocation();
        }
        return this.locationForValue(value, putFlags);
    }

    private static int alignArrayIndex(int index, int bytes) {
        assert (bytes > 0 && (bytes & bytes - 1) == 0);
        int baseOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        int indexScale = Unsafe.ARRAY_INT_INDEX_SCALE;
        if (bytes <= indexScale) {
            return index;
        }
        int misalignment = baseOffset + indexScale * index & bytes - 1;
        if (misalignment == 0) {
            return index;
        }
        return index + (bytes - misalignment) / indexScale;
    }
}

