/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.base;

import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Path;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.UTF8Writer;

public abstract class TextualTSFactory
extends DecorableTSFactory
implements Serializable {
    private static final long serialVersionUID = 3L;

    protected TextualTSFactory(StreamReadConstraints src, StreamWriteConstraints swc, ErrorReportConfiguration erc, int formatPF, int formatGF) {
        super(src, swc, erc, formatPF, formatGF);
    }

    protected TextualTSFactory(DecorableTSFactory.DecorableTSFBuilder<?, ?> baseBuilder) {
        super(baseBuilder);
    }

    protected TextualTSFactory(TextualTSFactory src) {
        super(src);
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return false;
    }

    public boolean canUseCharArrays() {
        return true;
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, File f) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(f), true);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, this._fileInputStream(f)));
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, Path p) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(p), true);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, this._pathInputStream(p)));
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, InputStream in) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(in), false);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, in));
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, Reader r) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(r), false);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, r));
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, byte[] data, int offset, int len) throws JacksonException {
        InputStream in;
        IOContext ioCtxt = this._createContext(this._createContentReference(data, offset, len), true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ioCtxt, data, offset, len)) != null) {
            return this._createParser(readCtxt, ioCtxt, in);
        }
        return this._createParser(readCtxt, ioCtxt, data, offset, len);
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, String content) throws JacksonException {
        int strLen = content.length();
        if (this._inputDecorator != null || strLen > 32768 || !this.canUseCharArrays()) {
            return this.createParser(readCtxt, new StringReader(content));
        }
        IOContext ioCtxt = this._createContext(this._createContentReference(content), true);
        char[] buf = ioCtxt.allocTokenBuffer(strLen);
        content.getChars(0, strLen, buf, 0);
        return this._createParser(readCtxt, ioCtxt, buf, 0, strLen, true);
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, char[] content, int offset, int len) throws JacksonException {
        if (this._inputDecorator != null) {
            return this.createParser(readCtxt, new CharArrayReader(content, offset, len));
        }
        return this._createParser(readCtxt, this._createContext(this._createContentReference(content, offset, len), true), content, offset, len, false);
    }

    @Override
    public JsonParser createParser(ObjectReadContext readCtxt, DataInput in) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(in), false);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, in));
    }

    protected abstract JsonParser _createParser(ObjectReadContext var1, IOContext var2, InputStream var3) throws JacksonException;

    protected abstract JsonParser _createParser(ObjectReadContext var1, IOContext var2, Reader var3) throws JacksonException;

    protected abstract JsonParser _createParser(ObjectReadContext var1, IOContext var2, byte[] var3, int var4, int var5) throws JacksonException;

    protected abstract JsonParser _createParser(ObjectReadContext var1, IOContext var2, char[] var3, int var4, int var5, boolean var6) throws JacksonException;

    protected abstract JsonParser _createParser(ObjectReadContext var1, IOContext var2, DataInput var3) throws JacksonException;

    @Override
    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, OutputStream out, JsonEncoding enc) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(out), false, enc);
        if (enc == JsonEncoding.UTF8) {
            return this._decorate(this._createUTF8Generator(writeCtxt, ioCtxt, this._decorate(ioCtxt, out)));
        }
        return this._decorate(this._createGenerator(writeCtxt, ioCtxt, this._decorate(ioCtxt, this._createWriter(ioCtxt, out, enc))));
    }

    @Override
    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, Writer w) throws JacksonException {
        IOContext ioCtxt = this._createContext(this._createContentReference(w), false);
        return this._decorate(this._createGenerator(writeCtxt, ioCtxt, this._decorate(ioCtxt, w)));
    }

    @Override
    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, File f, JsonEncoding enc) throws JacksonException {
        OutputStream out = this._fileOutputStream(f);
        IOContext ioCtxt = this._createContext(this._createContentReference(f), true, enc);
        if (enc == JsonEncoding.UTF8) {
            return this._decorate(this._createUTF8Generator(writeCtxt, ioCtxt, this._decorate(ioCtxt, out)));
        }
        return this._decorate(this._createGenerator(writeCtxt, ioCtxt, this._decorate(ioCtxt, this._createWriter(ioCtxt, out, enc))));
    }

    @Override
    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, Path p, JsonEncoding enc) throws JacksonException {
        OutputStream out = this._pathOutputStream(p);
        IOContext ioCtxt = this._createContext(this._createContentReference(p), true, enc);
        if (enc == JsonEncoding.UTF8) {
            return this._decorate(this._createUTF8Generator(writeCtxt, ioCtxt, this._decorate(ioCtxt, out)));
        }
        return this._decorate(this._createGenerator(writeCtxt, ioCtxt, this._decorate(ioCtxt, this._createWriter(ioCtxt, out, enc))));
    }

    @Override
    protected ContentReference _createContentReference(Object contentRef) {
        return ContentReference.construct(true, contentRef, this._errorReportConfiguration);
    }

    @Override
    protected ContentReference _createContentReference(Object contentRef, int offset, int length) {
        return ContentReference.construct(true, contentRef, offset, length, this._errorReportConfiguration);
    }

    protected abstract JsonGenerator _createGenerator(ObjectWriteContext var1, IOContext var2, Writer var3) throws JacksonException;

    protected abstract JsonGenerator _createUTF8Generator(ObjectWriteContext var1, IOContext var2, OutputStream var3) throws JacksonException;

    protected Writer _createWriter(IOContext ioCtxt, OutputStream out, JsonEncoding enc) throws JacksonException {
        if (enc == JsonEncoding.UTF8) {
            return new UTF8Writer(ioCtxt, out);
        }
        try {
            return new OutputStreamWriter(out, enc.getJavaName());
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }
}

