/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.BlobParameterBufferImp;
import org.firebirdsql.gds.impl.TransactionParameterBufferImpl;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.AbstractFbAttachment;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.DatabaseListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractFbDatabase<T extends AbstractConnection<IConnectionProperties, ? extends FbDatabase>>
extends AbstractFbAttachment<T>
implements FbDatabase,
TransactionListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractFbDatabase.class);
    private static final byte[] DESCRIBE_DATABASE_INFO_BLOCK = new byte[]{62, 103, 32, 33, 1};
    protected final DatabaseListenerDispatcher databaseListenerDispatcher = new DatabaseListenerDispatcher();
    private final Set<FbTransaction> activeTransactions = new HashSet<FbTransaction>();
    private final WarningMessageCallback warningCallback = warning -> this.databaseListenerDispatcher.warningReceived(this, warning);
    private final RowDescriptor emptyRowDescriptor;
    private short databaseDialect;
    private int odsMajor;
    private int odsMinor;

    protected AbstractFbDatabase(T connection, DatatypeCoder datatypeCoder) {
        super(connection, datatypeCoder);
        this.emptyRowDescriptor = RowDescriptor.empty(datatypeCoder);
    }

    public final WarningMessageCallback getDatabaseWarningCallback() {
        return this.warningCallback;
    }

    public final int getActiveTransactionCount() {
        try (LockCloseable ignored = this.withLock();){
            int n = this.activeTransactions.size();
            return n;
        }
    }

    protected final void transactionAdded(FbTransaction transaction) {
        try (LockCloseable ignored = this.withLock();){
            if (transaction.getState() == TransactionState.ACTIVE) {
                this.activeTransactions.add(transaction);
            }
            transaction.addTransactionListener(this);
            transaction.addExceptionListener(this.exceptionListenerDispatcher);
        }
    }

    @Override
    public final short getConnectionDialect() {
        return (short)((IConnectionProperties)this.connection.getAttachProperties()).getSqlDialect();
    }

    @Override
    public final short getDatabaseDialect() {
        return this.databaseDialect;
    }

    protected final void setDatabaseDialect(short dialect) {
        this.databaseDialect = dialect;
    }

    @Override
    public final void addDatabaseListener(DatabaseListener listener) {
        this.databaseListenerDispatcher.addListener(listener);
    }

    @Override
    public final void addWeakDatabaseListener(DatabaseListener listener) {
        this.databaseListenerDispatcher.addWeakListener(listener);
    }

    @Override
    public final void removeDatabaseListener(DatabaseListener listener) {
        this.databaseListenerDispatcher.removeListener(listener);
    }

    protected abstract void internalDetach() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkConnected();
            int activeTransactionCount = this.getActiveTransactionCount();
            if (activeTransactionCount > 0) {
                throw new FbExceptionBuilder().exception(335544357).messageParameter(activeTransactionCount).toSQLException();
            }
            this.databaseListenerDispatcher.detaching(this);
            try {
                this.internalDetach();
            }
            finally {
                this.databaseListenerDispatcher.detached(this);
                this.databaseListenerDispatcher.shutdown();
                this.exceptionListenerDispatcher.shutdown();
            }
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    @Override
    public final int getOdsMajor() {
        return this.odsMajor;
    }

    protected final void setOdsMajor(int odsMajor) {
        this.odsMajor = odsMajor;
    }

    @Override
    public final int getOdsMinor() {
        return this.odsMinor;
    }

    protected final void setOdsMinor(int odsMinor) {
        this.odsMinor = odsMinor;
    }

    public final byte[] getStatementInfoRequestItems() {
        return this.getServerVersionInformation().getStatementInfoRequestItems();
    }

    public final byte[] getParameterDescriptionInfoRequestItems() {
        return this.getServerVersionInformation().getParameterDescriptionInfoRequestItems();
    }

    public final <R> R getDatabaseInfo(byte[] requestItems, int bufferLength, InfoProcessor<R> infoProcessor) throws SQLException {
        byte[] responseBuffer = this.getDatabaseInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(responseBuffer);
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    protected byte[] getDescribeDatabaseInfoBlock() {
        return DESCRIBE_DATABASE_INFO_BLOCK;
    }

    protected InfoProcessor<FbDatabase> getDatabaseInformationProcessor() {
        return new DatabaseInformationProcessor();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        switch (1.$SwitchMap$org$firebirdsql$gds$ng$TransactionState[newState.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                ignored = this.withLock();
                var5_6 = null;
                this.activeTransactions.remove(transaction);
                if (ignored == null) break;
                if (var5_6 == null) ** GOTO lbl16
                try {
                    ignored.close();
                }
                catch (Throwable var6_8) {
                    var5_6.addSuppressed(var6_8);
                }
                break;
lbl16:
                // 1 sources

                ignored.close();
                break;
                catch (Throwable var6_9) {
                    try {
                        var5_6 = var6_9;
                        throw var6_9;
                    }
                    catch (Throwable var7_12) {
                        if (ignored != null) {
                            if (var5_6 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var8_13) {
                                    var5_6.addSuppressed(var8_13);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        throw var7_12;
                    }
                }
            }
            case 4: 
            case 5: {
                ignored = this.withLock();
                var5_7 = null;
                this.activeTransactions.remove(transaction);
                transaction.removeTransactionListener(this);
                transaction.removeExceptionListener(this.exceptionListenerDispatcher);
                if (ignored == null) break;
                if (var5_7 == null) ** GOTO lbl49
                try {
                    ignored.close();
                }
                catch (Throwable var6_10) {
                    var5_7.addSuppressed(var6_10);
                }
                break;
lbl49:
                // 1 sources

                ignored.close();
                break;
                catch (Throwable var6_11) {
                    try {
                        var5_7 = var6_11;
                        throw var6_11;
                    }
                    catch (Throwable var9_14) {
                        if (ignored != null) {
                            if (var5_7 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var10_15) {
                                    var5_7.addSuppressed(var10_15);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        throw var9_14;
                    }
                }
            }
        }
    }

    @Override
    public BlobParameterBuffer createBlobParameterBuffer() {
        return new BlobParameterBufferImp();
    }

    @Override
    public TransactionParameterBufferImpl createTransactionParameterBuffer() {
        return new TransactionParameterBufferImpl();
    }

    @Override
    public IConnectionProperties getConnectionProperties() {
        return ((IConnectionProperties)this.connection.getAttachProperties()).asImmutable();
    }

    @Override
    public final RowDescriptor emptyRowDescriptor() {
        return this.emptyRowDescriptor;
    }

    private class DatabaseInformationProcessor
    implements InfoProcessor<FbDatabase> {
        private DatabaseInformationProcessor() {
        }

        @Override
        public FbDatabase process(byte[] info) throws SQLException {
            if (info.length == 0) {
                throw FbExceptionBuilder.forException(337248307).messageParameter("database").toSQLException();
            }
            boolean debug = log.isDebugEnabled();
            if (debug) {
                log.debugf("DatabaseInformationProcessor.process: first 2 bytes are %04X or: %02X, %02X", (Object)VaxEncoding.iscVaxInteger2(info, 0), (Object)info[0], (Object)info[1]);
            }
            int i = 0;
            block7: while (info[i] != 1) {
                switch (info[i++]) {
                    case 62: {
                        int len = VaxEncoding.iscVaxInteger2(info, i);
                        int value = VaxEncoding.iscVaxInteger(info, i += 2, len);
                        i += len;
                        AbstractFbDatabase.this.setDatabaseDialect((short)value);
                        if (!debug) continue block7;
                        log.debugf("isc_info_db_sql_dialect: %d", (Object)value);
                        continue block7;
                    }
                    case 32: {
                        int len = VaxEncoding.iscVaxInteger2(info, i);
                        int value = VaxEncoding.iscVaxInteger(info, i += 2, len);
                        i += len;
                        AbstractFbDatabase.this.setOdsMajor(value);
                        if (!debug) continue block7;
                        log.debugf("isc_info_ods_version: %d", (Object)value);
                        continue block7;
                    }
                    case 33: {
                        int len = VaxEncoding.iscVaxInteger2(info, i);
                        int value = VaxEncoding.iscVaxInteger(info, i += 2, len);
                        i += len;
                        AbstractFbDatabase.this.setOdsMinor(value);
                        if (!debug) continue block7;
                        log.debugf("isc_info_ods_minor_version: %d", (Object)value);
                        continue block7;
                    }
                    case 103: {
                        int len = VaxEncoding.iscVaxInteger2(info, i);
                        int expectedIndex = (i += 2) + len;
                        int versionCount = info[i++] & 0xFF;
                        Object[] versionParts = new String[versionCount];
                        for (int versionIndex = 0; versionIndex < versionCount; ++versionIndex) {
                            int versionLength = info[i++] & 0xFF;
                            versionParts[versionIndex] = new String(info, i, versionLength, StandardCharsets.UTF_8);
                            i += versionLength;
                        }
                        assert (i == expectedIndex) : "Parsing version information lead to wrong index";
                        AbstractFbDatabase.this.setServerVersion((String[])versionParts);
                        if (!debug) continue block7;
                        log.debugf("isc_info_firebird_version: %s", (Object)Arrays.toString(versionParts));
                        continue block7;
                    }
                    case 2: {
                        log.debug("isc_info_truncated");
                        return AbstractFbDatabase.this;
                    }
                }
                throw new FbExceptionBuilder().exception(335544341).toSQLException();
            }
            return AbstractFbDatabase.this;
        }
    }
}

